<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
  <#if queryAttr??>
    const ${importName!}Obj = {
    ${queryAttr}
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
      <#list dims as dim>
        "${dim}"<#if dim_has_next>,</#if>
      </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
    targets:[
        <#list targets as target>
          {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
        </#list>
    ]
    </#if>
    };
    <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
        const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
        if (queryConditions && queryConditions.length) {
            ${importName!}Obj.superQueryConditionDto = queryConditions;
        }
    </#if>
  <#--    若查询条件项为空，则清空option-->
<#--    <#if (queryCheck?? && queryCheck != "")>-->
<#--      if(${queryCheck}){-->
<#--      return;-->
<#--      }-->
<#--    </#if>-->
  <#else>
    const ${importName!}Obj = {
        <#if orders??>
          ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
          dims:[
            <#list dims as dim>
              "${dim}"<#if dim_has_next>,</#if>
            </#list>
          ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
                <#list targets as target>
                  {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
                </#list>
            ]
        </#if>
    };
  </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
      if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
        const dataBaseArray = res.data.data;
        const dimArr = [
        <#if dims?? && (dims?size>0) >
          <#list dims as dim>
            "${dim}Dim"<#if dim_has_next>,</#if>
          </#list>
        </#if>
        ];
        const metricsArr = [
          <#if targets?? && (targets?size>0) >
              <#list targets as target>
                <#if target['agg']??>
                  "${target['asAlias']!}"<#if target_has_next>,</#if>
                </#if>
              </#list>
          </#if>
        ];
        const legendData = [
          <#if targets?? && (targets?size>0) >
              <#list targets as target>
                <#if target['agg']??>
                  "${target['legendName']}"<#if target_has_next>,</#if>
                </#if>
              </#list>
          </#if>
        ];
        ${curPropsData!}.legendData = legendData.map((item) => `[${'$'}{item}]`);

        const dimArrList = dataBaseArray.map((item) => item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()]);
        const metricsArrList = metricsArr.map((metric) => dataBaseArray.map((item) => item[metric] || item[metric.toLowerCase()] || item[metric.toUpperCase()]));
        const listArr = [];
        if (metricsArrList && metricsArrList.length) {
          metricsArrList.forEach((metric, i) => {
          const arr1 = dimArrList.map((item, index) => [item, metric[index], legendData[i]]);
          listArr.push(arr1);
        })
      }
       ${curPropsData!}.seriesResult = listArr

        self.${instanceKey!}OptionData = {
        seriesResult: self.${instanceKey!}PropsData.seriesResult,
        legendData: self.${instanceKey!}PropsData.legendData,
        };
        self.$nextTick(() => {
        self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.addLegendselectchanged && self.$refs.${instanceKey!}Ref.addLegendselectchanged();
        });
      } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
      }
    }).catch(function() {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    })
    <#else>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      const dataBaseArray = res.data.data;
      const groupedArray = Object.values(
        dataBaseArray.reduce((acc, item) => {
          if (!acc[item.${legendCols!}]) {
            acc[item.${legendCols!}] = []
          }
          acc[item.${legendCols!}].push([item.${xAxisCols!}, item.${seriesCols!}, item.${legendCols!}]);
          return acc;
        }, {})
      )
      const legendData = [...new Set(dataBaseArray.map((item) => item.${legendCols!}))];
      ${curPropsData!}.seriesResult = groupedArray;
      ${curPropsData!}.legendData = legendData
      self.${instanceKey!}OptionData = {
        seriesResult: self.${instanceKey!}PropsData.seriesResult,
        legendData: self.${instanceKey!}PropsData.legendData
      };
      self.$nextTick(() => {
      self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.addLegendselectchanged && self.$refs.${instanceKey!}Ref.addLegendselectchanged();
      });
    } else {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
  }).catch(function() {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  })
  </#if>
<#elseif isDataSetType??>
<#-- START +++++++++++++++++++++++++++++++++ 请求数据集数据接口 +++++++++++++++++++++++++++++++ -->
  const modelFields = {
  dataModelId: '${dataModelId!}',
  dim: [
  <#list dims! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}'
    },
  </#list>
  ],
  metrics: [
  <#list metrics! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}',
    function: '${item.function!}',
    rename: '${item.rename!}'
    },
  </#list>
  ]
  };
  const dataSetSort = [
  <#list dataSetSort! as item>
    {
    column: '${item.column!}',
    asc: ${item.asc?string("true", "false")}
    }
  </#list>
  ];
  const superQuery = [
  ${DataSetQueryCondition!}
  ];
  const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
  const legendData = modelFields.metrics.map((item) => item.rename || item.field);
  const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
  chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
  if (res && res.code === 10000 && res.data) {
  const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
  const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
  self.${instanceKey!}OptionData.xAxisData = res.data.data.map((item) => item[dimArr[0]]);
  self.${instanceKey!}OptionData.yAxisData = metricsArr.map((metric) => res.data.data.map((item) => item[metric]));
  self.${instanceKey!}OptionData.legendData = legendData.map((item) => <#noparse>`[${item}]`</#noparse>);
  }
  }).catch(function () {
  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  });
<#else>
<#-- 没有设置数据模型时-->
if (self.${instanceKey!}OptionData.seriesResult.length === 0 && self.${instanceKey!}OptionData.legendData.length === 0) {
<#if isDefaultValue?? && isDefaultValue == false>
  self.${instanceKey!}OptionData.seriesResult = [
    [
        [2, 5, '指标1'],[4, 13, '指标1'],[15, 22, '指标2'],[25, 35, '指标2'],[31, 39, '指标1']
    ],
    [
        [6, 6, '指标2'],[8, 31, '指标2'],[15, 41, '指标1'],[35, 39, '指标2'],[16, 73, '指标1']
    ]
  ];
  self.${instanceKey!}OptionData.legendData = ['指标1', '指标2'];
</#if>
  }
  self.$nextTick(() => {
  self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.addLegendselectchanged && self.$refs.${instanceKey!}Ref.addLegendselectchanged();
  });
</#if>
