const resultSeries = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
const dataZoom = [
    {
        type: 'slider',
        <#if (isZooShow?? && isZooShow)>
            show: true,
        <#elseif (!isZooShow?? || !isZooShow)>
            show: false,
        </#if>
        xAxisIndex: [0],
    },
];
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end) + '\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
const totalArr = [];
self.${instanceKey!}OptionData.yAxisData.forEach((item) => {
    item.forEach((ele, jndex) => {
        if (totalArr[jndex]) {
        totalArr[jndex] += ele;
        } else {
        totalArr[jndex] = ele;
        }
    });
});
const echatrsTooltip = {
    trigger: 'axis',
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
        lineHeight: '${toolLineHeight!}',
    },
    formatter(params) {
        let str = params[0].axisValue + '<br />';
        params.forEach((item, index) => {
            let { value, seriesName } = item;
            <#if (percentage?? && percentage)>
                if (totalArr.length) {
                    const total = totalArr[item.dataIndex];
                    const num = (item.value / total).toFixed(2) * 100;
                    value = Math.round(num) + '%';
                }
            </#if>
            <#if (percentage?? && percentage)>
                if (index === params.length - 1) {
                    seriesName = '合计';
                    value = totalArr[item.dataIndex];
                }
            </#if>
            str += "<span style='display:inline-block;margin-right:5px;border-radius:50%;width:10px;height:10px;left:5px;background-color:#5AAEE9'></span>seriesName : value<br />";

        });
        return str;
    },
    axisPointer: {
        type: 'shadow',
        shadowStyle: {
        color: '${hoverBackgroundColor!}' && '${hoverBackgroundColor!}' !== 'transparent'  ? '${hoverBackgroundColor!}' : 'transparent',
        width: '1',
        },
    },
};
<#--网格-->
const grid = {
    left: '${gridLeft!}',
    top: '${gridTop!}',
    right: '${gridRight!}',
    bottom: '${gridBottom!}',
<#--    containLabel: ${containLabel?string!},-->
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const nameTextStyle = {
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
    padding: [${xPaddingTop!}, ${xPaddingRight!}, ${xPaddingBottom!}, ${xPaddingLeft!}],
};
const axisLine = {
    show: true,
    type: 'solid',
    lineStyle: {
        width: '${lineWidth!}',
        color: '${lineColor!}',
    },
};
const axisLabel = {
    show: true,
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
};
const axisTick ={
    length:'${xyAxisTickLength!}',
};
const yAxis = {
    type: 'value',
    name: '${yAxisName!}',
    nameGap: '${yNameGap!}',
<#if nameLocation??>
    nameLocation: '${nameLocation}',
</#if>
<#--    nameLocation: '${nameLocation}',-->
    nameTextStyle: {
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
        padding: [${yPaddingTop!}, ${yPaddingRight!}, ${yPaddingBottom!}, ${yPaddingLeft!}],
    },
    axisLine: {
        show: true,
        type: 'solid',
        lineStyle: {
            width: '${lineWidth!}',
            color: '${lineColor!}',
        },
    },
    axisLabel: {
        show: true,
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
    },
    axisTick: {
        length:'${xyAxisTickLength!}',
    },
};
const topicColorStr = '${topicColorStr!}';
<#--series样式设置-->
const seriesItemStyle = {
    normal: {
        barBorderRadius: '${barRadius!}',
    },
};
self.${instanceKey!}OptionData.legendData.forEach((legend, index) => {
    resultSeries.push({
        name: legend,
        itemStyle: seriesItemStyle,
        barWidth: '${barWidth!}',
        data: self.${instanceKey!}OptionData.yAxisData[index] || [],
        type: 'bar',
        stack:'default',
        label: {
            <#if (showlabel?? && showlabel)>
                show: true,
            <#elseif (!showlabel?? || !showlabel)>
                show: false,
            </#if>
            formatter(item) {
                <#if (percentage?? && percentage)>
                    if (totalArr.length) {
                        const total = totalArr[item.dataIndex];
                        const num = (item.value / total).toFixed(2) * 100;
                        return Math.round(num) + '%';
                    }
                </#if>
                return item.value;
            },
        },
        emphasis: {
            label: {
                fontSize: '${hoverLabelFontSize!}',
                color: '${hoverLabelColor!}' !== 'transparent' ? '${xyColor!}' : undefined,
                fontFamily: '${hoverLabelFontFamily!}',
                fontWeight: '${hoverLabelFontWeight!}',
            },
            itemStyle: {
                color: '${hoverBackgroundColor!}' !== 'transparent' ? '${hoverBackgroundColor!}' : undefined,
                borderWidth: '${isShowHoverBorder!}' ? '${hoverBorderWidth!}' : 0,
                borderColor: '${hoverBorderColor!}',
                borderType: '${hoverBorderType!}',
            },
        },
    });
});
<#if (self.${instanceKey!}OptionData.rightBarYAixsData?? && self.${instanceKey!}OptionData.rightBarYAixsData.length)>
    resultSeries.push({
          name: 'Progress',
          type: 'custom',
          renderItem: function(params, api) {
            const idx = api.value(0);
            const progress = api.value(1);
            const chartHeight = api.getHeight();
            const stackBarX = api.coord([idx, 0])[0];
            const stackBarWidth = '${barWidth}' / 2 + 2;
            const progressBarWidth = '${rightBarWidth}';
            const progressBarX = stackBarX + stackBarWidth;
            let prevStackTotal = 0;
            const data = self.${instanceKey!}OptionData.yAxisData.length;
            for (let i = 0; i < data.length; i++) {
              prevStackTotal += data[i][idx];
            }
            const [prevX, prevY] = api.coord([idx, prevStackTotal]);
            const gridBottom = '${gridBottom!}';
            const prevStackHeight = chartHeight - prevY - gridBottom; // 从图表x轴到堆叠图顶部的高度
            const stackTopY = api.coord([idx, prevStackTotal]); // stackTopY[1]堆积图顶部的 Y 坐标
            const stackBottomY = api.coord([idx, 0]); // stackBottomY[1]堆积图底部的 Y 坐标 (X 轴位置)
            const stackHeight = stackBottomY[1] - stackTopY[1];
            const proportion = progress / prevStackTotal;
            const progressBarHeight = prevStackHeight * proportion;
            const barBorderRadius='${rightBarRadius}';
            const bgColor = topicColorStr[topicColorStr.length -2];
            const progressBarColor = topicColorStr[topicColorStr.length -1];
            // 绘制背景条（高度等于前一个堆积图的高度）
            const background = {
              type: 'rect',
              shape: {
                x: progressBarX,
                y: stackBottomY[1] - stackHeight,
                width: progressBarWidth,
                height: prevStackHeight,
                r: barBorderRadius,
              },
              style: {
                fill: bgColor,
                borderRadius: 2
              },
            };

            // 绘制进度条
            const progressBar = {
              type: 'rect',
              shape: {
                x: progressBarX,
                y: stackBottomY[1] - progressBarHeight,
                width: progressBarWidth,
                height: progressBarHeight,
                r: barBorderRadius,
              },
              style: {
                fill: progressBarColor,
                borderRadius: 2
              },
            };

            return {
              type: 'group',
              children: [background, progressBar]
            };
          },
          data: self.${instanceKey!}OptionData.xAxisData.map((_, idx) => [idx, self.${instanceKey!}OptionData.rightBarYAixsData[idx]]),
          z: 10 // 确保在最上层显示
        })
</#if>

<#if (total?? && total)>
    const arr = [];
    if (self.${instanceKey!}OptionData.yAxisData.length) {
        self.${instanceKey!}OptionData.yAxisData[0].forEach(() => arr.push(0));
    }
    resultSeries.push({
        name: '',
        barWidth: '${barWidth!}',
        data: arr,
        type: 'bar',
        stack: 'default',
        label: {
        <#if (showlabel?? && showlabel)>
            show: true,
        <#elseif (!showlabel?? || !showlabel)>
            show: false,
        </#if>
            color: '#505960',
            position: 'top',
            formatter(item) {
                return totalArr[item.dataIndex];
            },
        },
    });
</#if>
return {
    color: topicColorStr,
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    grid: grid,
    legend: {
  <#if (isShowFlag?? && isShowFlag)>
    show: true,
  <#elseif (!isShowFlag?? || !isShowFlag)>
    show: false,
  </#if>
        itemGap: 20,
        itemWidth: 15,
        itemHeight: 15,
        left: '${legendLocation!}',
        textStyle: textStyle,
        data: self.${instanceKey!}OptionData.legendData || [],
        itemGap: self.${instanceKey!}OptionData.legendSpacing,
    },
    xAxis: {
        type: 'category',
        name: '${xAxisName!}',
        nameGap: '${xNameGap!}',
        nameLocation: '${nameLocation!}',
        nameTextStyle: nameTextStyle,
        axisLine: axisLine,
        axisLabel: {
            ...axisLabel,
            rotate: '${isRotate!}' ? '${rotateAngle!}' : 0,
        },
        axisTick:axisTick,
        data: self.${instanceKey!}OptionData.xAxisData || []
    },
    yAxis: yAxis,
    series: resultSeries
};
