<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
<#-- 查询数据库赋值 -->
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
            <#list dims as dim>
                "${dim}"<#if dim_has_next>,</#if>
            </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
            ],
        </#if>
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
            ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
        const ${importName!}Obj = {
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
            <#list dims as dim>
                "${dim}"<#if dim_has_next>,</#if>
            </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
            ],
        </#if>
    };
  </#if>
  <#-- 设置数据模型后请求数据 -->
  <#-- 绑定的是新的数据集模型 -->
  <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
        const dataBaseArray = res.data.data;
        const dimArr = [
        <#if dims?? && (dims?size>0) >
            <#list dims as dim>
                "${dim}Dim"<#if dim_has_next>,</#if>
            </#list>
        </#if>
        ];
        const metricsArr = [
        <#if targets?? && (targets?size>0) >
            <#list targets as target>
                <#if target['agg']??>
                    "${target['asAlias']!}"<#if target_has_next>,</#if>
                </#if>
            </#list>
        </#if>
        ];
        const legendData = [
        <#if targets?? && (targets?size>0) >
            <#list targets as target>
                <#if target['agg']??>
                    "${target['legendName']!}"<#if target_has_next>,</#if>
                </#if>
            </#list>
        </#if>
        ];
        ${curPropsData!}.xAxisData = dataBaseArray.map((item) => item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()]);
        ${curPropsData!}.yAxisData = metricsArr.map((metric) => dataBaseArray.map((item) => item[metric] || item[metric.toLowerCase()] || item[metric.toUpperCase()]));;
        ${curPropsData!}.legendData = legendData.map((item) => `[${'$'}{item}]`);
        self.${instanceKey!}OptionData = {
        yAxisData: self.${instanceKey!}PropsData.yAxisData,
        xAxisData: self.${instanceKey!}PropsData.xAxisData,
        legendData: self.${instanceKey!}PropsData.legendData
        };
        self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.OptionItem();
        } else {
          HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
        }
      }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
      })
  <#else>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      const dataBaseArray = res.data.data;
      const xAxisData = dataBaseArray.map(item => item.${xAxisCols!});
      const legendData = dataBaseArray.map(item => item.${legendCols!});
      ${curPropsData!}.yAxisData = [];
      ${curPropsData!}.xAxisData = [...new Set(xAxisData)];
      ${curPropsData!}.legendData = [...new Set(legendData)];
      ${curPropsData!}.legendData.forEach((lengendData) => {
        const yAxisData = [];
        ${curPropsData!}.xAxisData.forEach((xAxisData) => {
          let num = 0;
          dataBaseArray.forEach((item) => {
            if (lengendData === item.${legendCols!} && xAxisData === item.${xAxisCols!}) {
              yAxisData.push(item.${seriesCols!});
              return;
            }
            num++;
            if (num === dataBaseArray.length) {
              yAxisData.push(null);
            }
          })
        });
        ${curPropsData!}.yAxisData.push(yAxisData);
      });
      self.${instanceKey!}OptionData = {
      yAxisData: self.${instanceKey!}PropsData.yAxisData,
      xAxisData: self.${instanceKey!}PropsData.xAxisData,
      legendData: self.${instanceKey!}PropsData.legendData
      };
      self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.OptionItem();
    } else {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
  }).catch(function() {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  })
  </#if>
<#--    没有设置数据模型时-->
<#elseif isDataSetType??>
  <#-- START +++++++++++++++++++++++++++++++++ 请求数据集数据接口 +++++++++++++++++++++++++++++++ -->
    const modelFields = {
        dataModelId: '${dataModelId!}',
        dim: [
            <#list dims! as item>
                {
                    field: '${item.field!}',
                    fieldAlias: '${item.fieldAlias!}'
                },
            </#list>
        ],
        metrics: [
            <#list metrics! as item>
                {
                    field: '${item.field!}',
                    fieldAlias: '${item.fieldAlias!}',
                    function: '${item.function!}',
                    rename: '${item.rename!}'
                },
            </#list>
        ]
    };
    const dataSetSort = [
    <#list dataSetSort! as item>
        {
        column: '${item.column!}',
        asc: ${item.asc?string("true", "false")}
        }
    </#list>
    ];
    const superQuery = [
    ${DataSetQueryCondition!}
    ];
    const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
    const legendData = modelFields.metrics.map((item) => item.rename || item.field);
    const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
    chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
    if (res && res.code === 10000 && res.data) {
    const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
    const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
    self.${instanceKey!}OptionData.xAxisData = res.data.data.map((item) => item[dimArr[0]]);
    self.${instanceKey!}OptionData.yAxisData = metricsArr.map((metric) => res.data.data.map((item) => item[metric]));
    self.${instanceKey!}OptionData.legendData = legendData.map((item) => <#noparse>`[${item}]`</#noparse>);
    }
    }).catch(function () {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    });
<#else>
<#-- 当配置数据处理时，给optionData重新赋值 -->
    if (self.${instanceKey!}OptionData.yAxisData.length === 0 && self.${instanceKey!}OptionData.xAxisData.length === 0 && self.${instanceKey!}OptionData.legendData.length === 0) {
    <#if isDefaultValue?? && isDefaultValue == false>
        self.${instanceKey!}OptionData.xAxisData = ['[名称1]', '[名称2]', '[名称3]', '[名称4]', '[名称5]', '[名称6]', '[名称7]'];
        self.${instanceKey!}OptionData.yAxisData = [[100, 320, 150, 77, 84, 130, 76], [230, 440, 250, 240, 430, 210, 250], [305, 390, 330, 360, 320, 430, 300]];
        self.${instanceKey!}OptionData.legendData = ['[图例1]', '[图例2]', '[图例3]'];
    </#if>
    }
</#if>