<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
            <#list dims as dim>
                "${dim}"<#if dim_has_next>,</#if>
            </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
        targets:[
            <#list targets as target>
                {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
            </#list>
        ]
        </#if>
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
                ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
    const ${importName!}Obj = {
        <#if orders??>
            ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
            dims:[
                <#list dims as dim>
                    "${dim}"<#if dim_has_next>,</#if>
                </#list>
            ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
                <#list targets as target>
                    {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
                </#list>
            ]
        </#if>
    };
    </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
          const dataBaseArray = res.data.data;
          const dimArr = [
            <#if dims?? && (dims?size>0) >
                <#list dims as dim>
                    "${dim}Dim"<#if dim_has_next>,</#if>
                </#list>
            </#if>
          ];
          const metricsArr = [
            <#if targets?? && (targets?size>0) >
                <#list targets as target>
                    <#if target['agg']??>
                        "${target['asAlias']!}"<#if target_has_next>,</#if>
                    </#if>
                </#list>
            </#if>
          ];
          const legendData = [
            <#if targets?? && (targets?size>0) >
                <#list targets as target>
                    <#if target['agg']??>
                        "${target['legendName']!}"<#if target_has_next>,</#if>
                    </#if>
                </#list>
            </#if>
          ];
          ${optionData!}.yAxisData = dataBaseArray.map((item) => item[dimArr[0]] || item[dimArr[0].toLowerCase()] || item[dimArr[0].toUpperCase()]);
          ${optionData!}.xAxisData = metricsArr.map((metric) => dataBaseArray.map((item) => item[metric] || item[metric.toLowerCase()] || item[metric.toUpperCase()]));;
          ${optionData!}.legendData = legendData.map((item) => `[${'$'}{item}]`);
        } else {
          HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
        }
      }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
      })
    <#else>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
            const dataBaseArray = res.data.data;
            const yAxisData = dataBaseArray.map(item => item.${yAxisCols!});
            const legendData = dataBaseArray.map(item => item.${legendCols!});
            ${optionData!}.xAxisData = [];
            ${optionData!}.yAxisData = [...new Set(yAxisData)];
            ${optionData!}.legendData = [...new Set(legendData)];
            ${optionData!}.color = [];
            ${optionData!}.legendData.forEach((lengendData) => {
                const xAxisData = [];
                ${optionData!}.yAxisData.forEach((yAxisData) => {
                    let num = 0;
                    dataBaseArray.forEach((item) => {
                        if (lengendData === item.${legendCols!} && yAxisData === item.${yAxisCols!}) {
                        xAxisData.push(item.${seriesCols!});
                        return;
                        }
                        num++;
                        if (num === dataBaseArray.length) {
                            xAxisData.push(null);
                        }
                    })
                });
                ${optionData!}.xAxisData.push(xAxisData);
            })
    } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
    }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    })
    </#if>
<#--    没有设置数据模型时-->
<#elseif isDataSetType??>
<#-- START +++++++++++++++++++++++++++++++++ 请求数据集数据接口 +++++++++++++++++++++++++++++++ -->
    const modelFields = {
    dataModelId: '${dataModelId!}',
    dim: [
    <#list dims! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}'
        },
    </#list>
    ],
    metrics: [
    <#list metrics! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}',
        function: '${item.function!}',
        rename: '${item.rename!}'
        },
    </#list>
    ]
    };
    const dataSetSort = [
    <#list dataSetSort! as item>
        {
        column: '${item.column!}',
        asc: ${item.asc?string("true", "false")}
        }
    </#list>
    ];
    const superQuery = [
    ${DataSetQueryCondition!}
    ];
    const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
    const legendData = modelFields.metrics.map((item) => item.rename || item.field);
    const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
    chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
    if (res && res.code === 10000 && res.data) {
    const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
    const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
    self.${instanceKey!}OptionData.yAxisData = res.data.data.map((item) => item[dimArr[0]]);
    self.${instanceKey!}OptionData.xAxisData = metricsArr.map((metric) => res.data.data.map((item) => item[metric]));
    self.${instanceKey!}OptionData.legendData = legendData.map((item) => <#noparse>`[${item}]`</#noparse>);
    }
    }).catch(function () {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    });
<#else>
    <#if isDefaultValue?? && isDefaultValue == false>
        if (${optionData!}.xAxisData.length === 0 && ${optionData!}.yAxisData.length === 0 && ${optionData!}.legendData.length === 0) {
        ${optionData!}.xAxisData = [[2.0, 4.9, 7.0, 23.2, 25.6],[2.6, 5.9, 9.0, 26.4, 28.7]];
        ${optionData!}.yAxisData = ['[名称1]', '[名称2]', '[名称3]', '[名称4]', '[名称5]'],
        ${optionData!}.legendData = ['[图例1]', '[图例2]'];
        }
    </#if>
</#if>