#!/bin/bash

ALL_VARS=$1
CLASS_PATH=$LONG_ARG

REDIS_HOST=$(echo "$ALL_VARS" | cut -d',' -f1)
REDIS_PASSWORD=$(echo "$ALL_VARS" | cut -d',' -f2)
REDIS_PORT=$(echo "$ALL_VARS" | cut -d',' -f3)
PARENT_DIR=$(echo "$ALL_VARS" | cut -d',' -f4)
APPLICATION_DIR=$(echo "$ALL_VARS" | cut -d',' -f5)
APPLICATION_PORT=$(echo "$ALL_VARS" | cut -d',' -f6)
DEV_USER=$(echo "$ALL_VARS" | cut -d',' -f7)
T_CODE=$(echo "$ALL_VARS" | cut -d',' -f8)
SPRING_CONFIG_LOCATION=$(echo "$ALL_VARS" | cut -d',' -f9)
APPLICATION=$(echo "$ALL_VARS" | cut -d',' -f10)
shortCommand=$(echo "$ALL_VARS" | cut -d',' -f11)
nacosAddr=$(echo "$ALL_VARS" | cut -d',' -f12)
namespace=$(echo "$ALL_VARS" | cut -d',' -f13)

echo "REDIS_HOST: $REDIS_HOST"
echo "REDIS_PASSWORD: $REDIS_PASSWORD"
echo "REDIS_PORT: $REDIS_PORT"
echo "PARENT_DIR: $PARENT_DIR"
echo "APPLICATION_DIR: $APPLICATION_DIR"
echo "APPLICATION_PORT: $APPLICATION_PORT"
echo "DEV_USER: $DEV_USER"
echo "T_CODE: $T_CODE"
echo "APPLICATION: $APPLICATION"
echo "CLASS_PATH: $CLASS_PATH"
echo "SPRING_CONFIG_LOCATION: $SPRING_CONFIG_LOCATION"
echo "shortCommand: ${shortCommand}"
echo "nacosAddr: ${nacosAddr}"
echo "namespace: ${namespace}"

#cd $PARENT_DIR
#mvn clean compile
## 检查命令的退出状态
#if [ $? -eq 0 ]; then
#    echo "mvn clean compile  was successful！！！"
#else
#    echo "mvn clean compile  failed！！！"
#    exit 1
#fi

cd $APPLICATION_DIR

export REDIS_HOST=$REDIS_HOST
export REDIS_PASSWORD=$REDIS_PASSWORD
export REDIS_PORT=$REDIS_PORT
export DEV_USER=$DEV_USER
export T_CODE=$T_CODE
export NACOS_HOST=$nacosAddr
export NACOS_NAMESPACE_ID=$namespace
export SPRING_CONFIG_LOCATION="$SPRING_CONFIG_LOCATION"
if [[ $APPLICATION_PORT =~ ^[0-9]+$ && $APPLICATION_PORT -ge 1 && $port -le 65535 ]]; then
  export APPLICATION_PORT=$APPLICATION_PORT
else
  echo "传入的参数不是一个非空或有效的端口号"
fi
echo "开始启动================================================================"
if [ "${shortCommand}" = "do_shorten" ]; then
  "$JAVA_HOME/bin/java" -Dfile.encoding=UTF-8 -classpath "shortenClassPath.jar" $APPLICATION $APPLICATION_DIR
else
  "$JAVA_HOME/bin/java" -Dfile.encoding=UTF-8 -classpath "$CLASS_PATH" $APPLICATION $APPLICATION_DIR
fi
echo "执行完成======================================================="
exit 0