/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.service.impl;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.devtools.invocation.properties.DeployToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.utils.FilePathConvertUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.Ref;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.example.git.service.impl.GitlabServiceImpl")
public class GitlabServiceImpl
implements IGitlabService {
    private static final String KEY_VALUE_FORMAT = "%s=%s";
    private static final String FRONT_PROJECT_SUFFIX = "-front";
    @Resource
    private DeployToolsProperties deployToolsProperties;
    @Resource
    private NacosDiscoveryProperties discoveryProperties;
    @Resource
    private DiscoveryClient discoveryClient;

    public ApiResponse<Boolean> createProject(GitDto gitDto) {
        return GitlabUtil.createProject((GitDto)gitDto);
    }

    public ApiResponse<String> pushToGit(GitDto gitDto) {
        ApiResponse<String> response = this.getCurrentBranch();
        if (response.isSuccess() && !((String)response.getData()).equals(gitDto.getBranch())) {
            gitDto.setBranch((String)response.getData());
        }
        if ("master".equals(gitDto.getBranch()) || "develop".equals(gitDto.getBranch())) {
            return ApiResponse.fail((String)"\u63a8\u9001\u5931\u8d25\uff0c\u8be5\u5206\u652f\u5904\u4e8e\u4fdd\u62a4\u72b6\u6001!");
        }
        String tenantCode = gitDto.getTenantCode();
        SecurityUser user = BaseSecurityUtil.getUser();
        String pathSegments = File.separator + tenantCode + File.separator + user.getId();
        String frontProjectPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + FRONT_PROJECT_SUFFIX, this.deployToolsProperties.getFrontProjectPath()});
        this.removeDevUser(frontProjectPath);
        return GitlabUtil.pushToGit((GitDto)gitDto);
    }

    public ApiResponse<String> pushSpecifiedToGit(GitDto gitDto) {
        return GitlabUtil.pushSpecifiedToGit((GitDto)gitDto);
    }

    public ApiResponse<String> pullToLocal(GitDto gitDto) {
        ApiResponse<String> response = this.getCurrentBranch();
        if (response.isSuccess() && !((String)response.getData()).equals(gitDto.getBranch())) {
            gitDto.setBranch((String)response.getData());
        }
        ApiResponse pullResponse = GitlabUtil.pullToLocal((GitDto)gitDto);
        String tenantCode = gitDto.getTenantCode();
        SecurityUser user = BaseSecurityUtil.getUser();
        String pathSegments = File.separator + tenantCode + File.separator + user.getId();
        String frontProjectPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + FRONT_PROJECT_SUFFIX, this.deployToolsProperties.getFrontProjectPath()});
        this.writeDevUser(frontProjectPath, user.getId().toString());
        return pullResponse;
    }

    public ApiResponse<String> createLocalBranch(GitDto gitDto) {
        return GitlabUtil.createLocalBranch((GitDto)gitDto);
    }

    public ApiResponse<String> createRemoteBranch(GitDto gitDto) {
        return GitlabUtil.createRemoteBranch((GitDto)gitDto);
    }

    public ApiResponse<String> checkoutBranch(GitDto gitDto) {
        return GitlabUtil.checkoutBranch((GitDto)gitDto);
    }

    public ApiResponse<Boolean> branchExist(GitDto gitDto) {
        return GitlabUtil.branchExist((GitDto)gitDto);
    }

    public ApiResponse<Boolean> remoteMerge(GitDto gitDto) {
        return GitlabUtil.remoteMerge((GitDto)gitDto);
    }

    public ApiResponse<Boolean> remoteMergeRequestCheck(GitDto gitDto) {
        return GitlabUtil.remoteMergeRequestCheck((GitDto)gitDto);
    }

    public ApiResponse<Boolean> getGroupOrProjectId(GitDto gitDto) {
        return GitlabUtil.getGroupOrProjectId((GitDto)gitDto);
    }

    public ApiResponse<Boolean> revertOrRemove(List<String> fileToRevert) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String localDir = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        return GitlabUtil.revertOrRemove((File)new File(localDir), fileToRevert);
    }

    public ApiResponse<String> pushVfgCode(String commitMsg, List<String> fileToAdd, String systemDir) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Map extendUserMap = user.getExtendUserMap();
        String localDir = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        ArrayList<String> convertPath = new ArrayList<String>();
        for (String file : fileToAdd) {
            convertPath.add(FilePathConvertUtil.getRealFileByPath(file, systemDir).getAbsolutePath());
        }
        GitDto gitDto = new GitDto.Builder().branch((String)this.getCurrentBranch().getData()).path(localDir).commitMsg(commitMsg).filesToAdd(convertPath).tenantCode(user.getTenantCode()).accessToken((String)extendUserMap.get("gitToken")).gitUri((String)extendUserMap.get("gitUrl")).build();
        HussarThreadPoolConfiguration pool = (HussarThreadPoolConfiguration)SpringContextHolder.getBean(HussarThreadPoolConfiguration.class);
        Executor asyncExecutor = pool.getAsyncExecutor();
        PublishLogUtil.Log pushLog = new PublishLogUtil.Log(null, null, "Git", "\u63a8\u9001\u751f\u6210\u4ee3\u7801\u5230\u8fdc\u7a0b\u4ed3\u5e93\u6210\u529f\uff01", null, "1", BaseSecurityUtil.getUser().getTenantCode(), String.valueOf(BaseSecurityUtil.getUser().getUserId()), (String)this.getCurrentBranch().getData());
        CompletionStage push = CompletableFuture.supplyAsync(() -> {
            GitlabUtil.pushSpecifiedToGitSync((GitDto)gitDto);
            PublishLogUtil.writePushSuccessLog((PublishLogUtil.Log)pushLog);
            return "";
        }, asyncExecutor).exceptionally(e -> {
            e.printStackTrace();
            PublishLogUtil.writePublishErrorLog(null, null, (String)"\u63a8\u9001\u751f\u6210\u4ee3\u7801\u5230\u8fdc\u7a0b\u4ed3\u5e93\u5931\u8d25\uff01");
            throw new RuntimeException((Throwable)e);
        });
        ((CompletableFuture)push).thenApply(result -> result);
        return ApiResponse.success((Object)"\u63a8\u9001\u6210\u529f", (String)"");
    }

    public ApiResponse<String> getCurrentBranch() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String localGitPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        return GitlabUtil.getCurrentBranch((String)localGitPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<List<String>> getAllBranch() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String localGitPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        ArrayList<String> branchList = new ArrayList<String>();
        File gitDir = new File(localGitPath);
        if (!gitDir.exists()) return ApiResponse.fail((String)("\u672c\u5730\u9879\u76ee\u4e0d\u5b58\u5728: " + localGitPath));
        if (!gitDir.isDirectory()) {
            return ApiResponse.fail((String)("\u672c\u5730\u9879\u76ee\u4e0d\u5b58\u5728: " + localGitPath));
        }
        try (Git git = Git.open((File)gitDir);){
            List remoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
            for (Ref branch : remoteBranches) {
                String fullBranchName = branch.getName();
                String branchName = fullBranchName.substring(fullBranchName.lastIndexOf("/") + 1);
                branchList.add(branchName);
            }
            ApiResponse apiResponse = ApiResponse.success(branchList, (String)"");
            return apiResponse;
        }
        catch (Exception e) {
            String errorMsg = "\u83b7\u53d6\u5206\u652f\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage();
            return ApiResponse.fail((String)errorMsg);
        }
    }

    public ApiResponse<String> checkoutBranchAndPull(GitDto gitDto) throws HussarException {
        SecurityUser user = BaseSecurityUtil.getUser();
        String tenantCode = user.getTenantCode();
        Map extendUserMap = user.getExtendUserMap();
        String localGitRep = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), tenantCode, String.valueOf(user.getId())});
        gitDto.setPath(localGitRep);
        gitDto.setTenantCode(tenantCode);
        gitDto.setAccessToken((String)extendUserMap.get("gitToken"));
        gitDto.setGitUri((String)extendUserMap.get("gitUrl"));
        String pathSegments = File.separator + tenantCode + File.separator + user.getId();
        String frontProjectPath = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), pathSegments, tenantCode + FRONT_PROJECT_SUFFIX, this.deployToolsProperties.getFrontProjectPath()});
        this.removeDevUser(frontProjectPath);
        try {
            GitlabUtil.checkoutBranch((GitDto)gitDto);
            GitlabUtil.pullToLocal((GitDto)gitDto);
        }
        catch (Exception e) {
            String msg = e.getCause().getMessage();
            if (msg != null && msg.contains("Checkout conflict with files:")) {
                msg = msg.replace("Checkout conflict with files:", "\u672c\u5730\u6587\u4ef6\u5b58\u5728\u51b2\u7a81\uff1a");
            }
            return ApiResponse.fail((int)10034, (String)msg);
        }
        return ApiResponse.success((Object)"\u5207\u6362\u5206\u652f\u6210\u529f", (String)"");
    }

    public ApiResponse<Boolean> localProjectExist() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String localGitRep = PathUtil.posixPath((String[])new String[]{this.deployToolsProperties.getWorkspace(), user.getTenantCode(), String.valueOf(user.getId())});
        File gitDir = new File(localGitRep, ".git");
        boolean hasProject = gitDir.exists() && gitDir.isDirectory();
        return ApiResponse.success((Object)hasProject);
    }

    public void writeFrontServeStartLog(String tenantCode, String devUser, String type, String message, String branch) {
        PublishLogUtil.Log log = "success".equals(type) ? new PublishLogUtil.Log(null, null, "\u542f\u52a8", "\u524d\u7aef\u670d\u52a1\u542f\u52a8\uff08\u7f16\u8bd1\uff09\u6210\u529f\uff01", null, "2", tenantCode, devUser, branch) : new PublishLogUtil.Log(null, null, "\u7f16\u8bd1", null, "\u524d\u7aef\u670d\u52a1\u7f16\u8bd1\u5931\u8d25\uff01" + message, "2", tenantCode, devUser, branch);
        PublishLogUtil.writeFrontServeStartedLog((PublishLogUtil.Log)log);
    }

    private void writeDevUser(String frontPath, String devUser) {
        try {
            File env = new File(PathUtil.posixPath((String[])new String[]{frontPath, ".env.development"}));
            String originalContent = FileUtils.readFileToString((File)env, (Charset)StandardCharsets.UTF_8);
            SecurityUser loginUser = BaseSecurityUtil.getUser();
            String tenantCode = loginUser.getTenantCode();
            String appDevUser = "VUE_APP_DEV_USER";
            String appTcode = "VUE_APP_TCODE";
            String appBranch = "VUE_APP_BRANCH";
            String appWriteLogUrl = "VUE_APP_WRITE_LOG_URL";
            String vueAppDevUser = String.format(KEY_VALUE_FORMAT, appDevUser, devUser);
            String tCode = String.format(KEY_VALUE_FORMAT, appTcode, tenantCode);
            String branch = (String)this.getCurrentBranch().getData();
            branch = String.format(KEY_VALUE_FORMAT, appBranch, branch);
            String ip = "";
            String gatewayPort = "";
            List services = this.discoveryClient.getServices();
            if (HussarUtils.isNotEmpty((Object)services)) {
                for (String service : services) {
                    if (!"hussar-cloud-gateway".equals(service)) continue;
                    List instances = this.discoveryProperties.namingServiceInstance().getAllInstances(service);
                    if (instances.isEmpty()) break;
                    ip = ((Instance)instances.get(0)).getIp();
                    gatewayPort = String.valueOf(((Instance)instances.get(0)).getPort());
                    break;
                }
            }
            String writeLogUrl = String.format("http://%s:%s/hussar-deploy/userEvn/writeFrontServeStartLog", ip, gatewayPort);
            writeLogUrl = String.format(KEY_VALUE_FORMAT, appWriteLogUrl, writeLogUrl);
            String[] orgContentList = originalContent.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String s : orgContentList) {
                if (s.contains(appDevUser) || s.contains(appTcode) || s.contains(appBranch) || s.contains(appWriteLogUrl)) continue;
                sb.append(s).append("\n");
            }
            sb.append(vueAppDevUser).append("\n").append(tCode).append("\n").append(branch).append("\n").append(writeLogUrl).append("\n");
            FileUtils.writeStringToFile((File)env, (String)sb.toString(), (boolean)false);
        }
        catch (IOException e) {
            throw new HussarException("\u5199\u5165\u524d\u7aefDEV_USER\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeDevUser(String frontPath) {
        try {
            File env = new File(PathUtil.posixPath((String[])new String[]{frontPath, ".env.development"}));
            String originalContent = FileUtils.readFileToString((File)env, (Charset)StandardCharsets.UTF_8);
            String appDevUser = "VUE_APP_DEV_USER";
            String appTcode = "VUE_APP_TCODE";
            String appBranch = "VUE_APP_BRANCH";
            String appWriteLogUrl = "VUE_APP_WRITE_LOG_URL";
            String[] orgContentList = originalContent.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String s : orgContentList) {
                if (s.contains(appDevUser) || s.contains(appTcode) || s.contains(appBranch) || s.contains(appWriteLogUrl)) continue;
                sb.append(s).append("\n");
            }
            FileUtils.writeStringToFile((File)env, (String)sb.toString(), (boolean)false);
        }
        catch (IOException e) {
            throw new HussarException("\u79fb\u9664\u524d\u7aefDEV_USER\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

