/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.file.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.devtools.compile.util.PathUtil;
import com.jxdinfo.hussar.formdesign.devtools.file.service.FileUtilsManager;
import com.jxdinfo.hussar.formdesign.devtools.invocation.properties.DeployToolsProperties;
import com.jxdinfo.hussar.formdesign.devtools.model.ComponentDto;
import com.jxdinfo.hussar.formdesign.devtools.model.FileModel;
import com.jxdinfo.hussar.formdesign.devtools.utils.FilePathConvertUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.devtools.file.service.impl.SimpleFileUtilsManager")
public class SimpleFileUtilsManager
implements FileUtilsManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileUtilsManager.class);
    @Resource
    private DeployToolsProperties properties;

    public String readFileToString(File file, String encoding, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return FileUtils.readFileToString((File)newFile, (String)encoding);
    }

    public String readFileToStringIfExists(File file, String encoding, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return newFile.exists() ? this.readFileToString(newFile, encoding, systemDir) : null;
    }

    public Map<String, String> readFilesToStringIfExists(List<String> filePaths, String encoding, String systemDir) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String path : filePaths) {
            File file = FilePathConvertUtil.getRealFileByPath(path, systemDir);
            map.put(path, this.readFileToStringIfExists(file, encoding, systemDir));
        }
        return map;
    }

    public byte[] readFileToByteArray(File file, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return FileUtils.readFileToByteArray((File)newFile);
    }

    public void writeStringToFile(File file, String data, String encoding, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        FileUtils.writeStringToFile((File)newFile, (String)data, (String)encoding);
    }

    public void writeStringToFile(String path, FileModel data, String encoding, String systemDir) throws IOException {
        FileUtils.writeStringToFile((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), (String)data.getFileData(), (String)encoding);
    }

    public void writeStringToFile(String path, String data, Charset encoding, boolean append, String systemDir) throws IOException {
        FileUtils.writeStringToFile((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), (String)data, (Charset)encoding, (boolean)append);
    }

    public void writeStringToFile(File file, String data, String encoding, boolean append, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        FileUtils.writeStringToFile((File)newFile, (String)data, (String)encoding, (boolean)append);
    }

    public void writeByteArrayToFile(String path, byte[] data, String systemDir) throws IOException {
        FileUtils.writeByteArrayToFile((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), (byte[])data);
    }

    public void forceDelete(File file, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        FileUtils.forceDelete((File)newFile);
    }

    public void deleteDirectory(File directory, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(directory, systemDir);
        FileUtils.forceDelete((File)newFile);
    }

    public boolean deleteQuietly(File file, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return FileUtils.deleteQuietly((File)newFile);
    }

    public Collection<File> listFiles(File directory, String[] extensions, boolean recursive, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(directory, systemDir);
        return FileUtils.listFiles((File)newFile, (String[])extensions, (boolean)recursive);
    }

    public File[] listFiles(File directory, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(directory, systemDir);
        return newFile.listFiles();
    }

    public void touch(File file, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        FileUtils.touch((File)newFile);
    }

    public List<String> readLines(String file, Charset encoding, String systemDir) throws IOException {
        return FileUtils.readLines((File)FilePathConvertUtil.getRealFileByPath(file, systemDir), (Charset)encoding);
    }

    public List<String> readLines(File file, String encoding, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return FileUtils.readLines((File)newFile, (String)encoding);
    }

    public void writeLines(String path, Collection<?> lines, String systemDir) throws IOException {
        FileUtils.writeLines((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), lines);
    }

    public void writeLines(String path, String encoding, Collection<?> lines, String systemDir) throws IOException {
        FileUtils.writeLines((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), (String)encoding, lines);
    }

    public void writeLines(String path, Collection<?> lines, boolean append, String systemDir) throws IOException {
        FileUtils.writeLines((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), lines, (boolean)append);
    }

    public void writeLines(String path, String encoding, Collection<?> lines, String lineEnding, String systemDir) throws IOException {
        FileUtils.writeLines((File)FilePathConvertUtil.getRealFileByPath(path, systemDir), (String)encoding, lines, (String)lineEnding);
    }

    public void forceMkdir(File directory, String systemDir) throws IOException {
        File newFile = FilePathConvertUtil.getRealFileByFile(directory, systemDir);
        FileUtils.forceMkdir((File)newFile);
    }

    public void copyFile(String srcFile, String destFile, boolean preserveFileDate, String systemDir) throws IOException {
        FileUtils.copyFile((File)FilePathConvertUtil.getRealFileByPath(srcFile, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destFile, systemDir), (boolean)preserveFileDate);
    }

    public void moveFile(String srcFile, String destFile, String systemDir) throws IOException {
        FileUtils.moveFile((File)FilePathConvertUtil.getRealFileByPath(srcFile, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destFile, systemDir));
    }

    public void moveDirectory(String srcDir, String destDir, String systemDir) throws IOException {
        FileUtils.moveDirectory((File)FilePathConvertUtil.getRealFileByPath(srcDir, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destDir, systemDir));
    }

    public void moveFileToDirectory(String srcFile, String destDir, boolean createDestDir, String systemDir) throws IOException {
        FileUtils.moveFileToDirectory((File)FilePathConvertUtil.getRealFileByPath(srcFile, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destDir, systemDir), (boolean)createDestDir);
    }

    public void moveDirectoryToDirectory(String src, String destDir, boolean createDestDir, String systemDir) throws IOException {
        FileUtils.moveDirectoryToDirectory((File)FilePathConvertUtil.getRealFileByPath(src, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destDir, systemDir), (boolean)createDestDir);
    }

    public void copyFileToDirectory(String srcFile, String destDir, boolean preserveFileDate, String systemDir) throws IOException {
        FileUtils.copyFileToDirectory((File)FilePathConvertUtil.getRealFileByPath(srcFile, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destDir, systemDir), (boolean)preserveFileDate);
    }

    public void copyDirectoryToDirectory(String srcDir, String destDir, String systemDir) throws IOException {
        FileUtils.copyDirectoryToDirectory((File)FilePathConvertUtil.getRealFileByPath(srcDir, systemDir), (File)FilePathConvertUtil.getRealFileByPath(destDir, systemDir));
    }

    public boolean exists(File file, String systemDir) {
        return FilePathConvertUtil.getRealFileByFile(file, systemDir).exists();
    }

    public boolean isFile(File file, String systemDir) {
        return FilePathConvertUtil.getRealFileByFile(file, systemDir).isFile();
    }

    public boolean isDirectory(File file, String systemDir) {
        return FilePathConvertUtil.getRealFileByFile(file, systemDir).isDirectory();
    }

    public long sizeOf(File file, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return FileUtils.sizeOf((File)newFile);
    }

    public void copyForJar(byte[] jarFile, String toFile, String systemDir) throws IOException {
        ByteArrayInputStream fromFile = new ByteArrayInputStream(jarFile);
        byte[] b = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(FilePathConvertUtil.getRealFileByPath(toFile, systemDir).getPath());){
            int a;
            while ((a = fromFile.read(b)) != -1) {
                fos.write(b, 0, a);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean isHidden(File file, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return newFile.isHidden();
    }

    public boolean delete(File file, String systemDir) {
        File newFile = FilePathConvertUtil.getRealFileByFile(file, systemDir);
        return newFile.delete();
    }

    public void submitDeferredTasks(Map<String, String> fileList, String systemDir) throws IOException {
        for (Map.Entry<String, String> entry : fileList.entrySet()) {
            File docFile;
            String path = entry.getKey();
            if (path.contains("BPM") && !(docFile = new File(path = path.substring(0, path.length() - 3))).getParentFile().exists()) {
                FileUtils.forceMkdir((File)docFile.getParentFile());
            }
            this.writeStringToFile(FilePathConvertUtil.getRealFileByPath(path, systemDir), entry.getValue(), StandardCharsets.UTF_8.name(), systemDir);
        }
    }

    public Map<String, String> iteratorFile(String filePath, String rootFilePath, String systemDir) {
        HashMap<String, String> fileMappingMap = new HashMap<String, String>();
        String replaceFilePath = FilePathConvertUtil.getRealFileByPath(filePath, systemDir).getAbsolutePath();
        String replaceRootFilePath = FilePathConvertUtil.getRealFileByPath(rootFilePath, systemDir).getAbsolutePath();
        this.iterator(replaceFilePath, fileMappingMap, replaceRootFilePath);
        return fileMappingMap;
    }

    public List<JSONObject> iteratorTree(String projectStoreCodePath, String pid, String filters, String systemDir) throws IOException {
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        File file = FilePathConvertUtil.getRealFileByPath(projectStoreCodePath, systemDir);
        if (!file.exists()) {
            return jsonObjects;
        }
        String[] filterArr = new String[]{};
        if (ObjectUtils.isNotEmpty((Object)filters)) {
            filterArr = filters.split(",");
        }
        this.iteratorTree(jsonObjects, file, pid, filterArr);
        return jsonObjects;
    }

    public List<Map<String, Object>> getAllImages(String imgPath, String splitPath, String systemDir) throws Exception {
        File[] files = this.listFiles(new File(PathUtil.pathFormatterByOs((String)imgPath)), systemDir);
        ArrayList<Map<String, Object>> imgList = new ArrayList<Map<String, Object>>();
        this.getAllRemoteImages(files, imgList, splitPath, systemDir);
        return imgList;
    }

    public void uploadImage(MultipartFile file, String imgPath, String systemDir) throws IOException {
        File fileSave = FilePathConvertUtil.getRealFileByPath(imgPath, systemDir);
        if (!fileSave.exists()) {
            FileUtils.forceMkdir((File)fileSave);
        }
        String nameOld = file.getOriginalFilename();
        File fileFinal = new File(fileSave.getPath(), nameOld);
        file.transferTo(fileFinal);
    }

    private void iteratorTree(List<JSONObject> jsonObjects, File file, String pId, String[] filters) throws IOException {
        File[] files;
        if (file.isDirectory() && ToolUtil.isNotEmpty((Object)(files = file.listFiles()))) {
            for (File childFile : files) {
                JSONObject jsonObject;
                File mataFile = new File(childFile.getAbsolutePath() + ".meta");
                if (!mataFile.exists() || (jsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)mataFile, (Charset)StandardCharsets.UTF_8))) == null) continue;
                jsonObject.put("parentId", (Object)pId);
                jsonObjects.add(jsonObject);
                String type = jsonObject.getString("type");
                if (ToolUtil.isNotEmpty((Object)type) && SimpleFileUtilsManager.anyMatch(type, filters)) {
                    JSONObject dataJsonObject = JSON.parseObject((String)FileUtils.readFileToString((File)childFile, (Charset)StandardCharsets.UTF_8));
                    jsonObject.put("data", (Object)dataJsonObject);
                }
                if (!childFile.isDirectory()) continue;
                this.iteratorTree(jsonObjects, childFile, jsonObject.getString("id"), filters);
            }
        }
    }

    public ComponentDto componentExport(ComponentDto componentDto) throws Exception {
        List fileNames = componentDto.getFileNames();
        String rootPath = componentDto.getRootPath();
        String backendFileName = componentDto.getBackendFileName();
        String id = componentDto.getId();
        Map outFileNames = componentDto.getOutFileNames();
        for (int i = 0; i < fileNames.size(); ++i) {
            String absolutePath = rootPath + File.separator + (String)fileNames.get(i);
            if (((String)fileNames.get(i)).equals(backendFileName)) {
                String fileName = (String)fileNames.get(i);
                String outBackendFileName = fileName.substring(id.length());
                outFileNames.put(absolutePath, outBackendFileName);
            } else {
                outFileNames.put(absolutePath, fileNames.get(i));
            }
            fileNames.set(i, absolutePath);
        }
        componentDto.setFileNames(fileNames);
        componentDto.setOutFileNames(outFileNames);
        return componentDto;
    }

    public void componentInducts(MultipartFile file, String id, String backendFileName, String rootPath, List<String> fileNames) throws Exception {
    }

    public byte[] install(String path) throws IOException {
        File file = FilePathConvertUtil.getRealFileByPath(path, "");
        return SimpleFileUtilsManager.fileToMultipartFile(file).getBytes();
    }

    public String getJsString(String frontFile, String frontJsPath, String systemDir) throws FileNotFoundException {
        File file = FilePathConvertUtil.getRealFileByPath(frontJsPath, systemDir);
        try (FileInputStream frontIs = new FileInputStream(file);){
            frontFile = IOUtils.toString((InputStream)frontIs, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6js\u5931\u8d25", (Throwable)e);
        }
        return frontFile;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = SimpleFileUtilsManager.creatFileItem(file);
        return new CommonsMultipartFile(fileItem);
    }

    public static FileItem creatFileItem(File file) {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory(16, null);
        FileItem fileItem = diskFileItemFactory.createItem(file.getName(), "application/zip", true, file.getName());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int bytesRead;
            OutputStream outputStream = fileItem.getOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = fileInputStream.read(buffer, 0, 8192)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            Files.copy(file.toPath(), outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> iterator(String filePath, Map<String, String> fileMappingMap, String rootFilePath) {
        File file = new File(filePath);
        File rootFile = new File(rootFilePath);
        if (!file.exists()) return fileMappingMap;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) return fileMappingMap;
            for (File childFile : files) {
                this.iterator(childFile.getAbsolutePath(), fileMappingMap, rootFile.getAbsolutePath());
            }
            return fileMappingMap;
        } else {
            if (!file.getName().endsWith(".meta")) return fileMappingMap;
            try {
                JSONObject baseFile = JSON.parseObject((String)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
                String id = String.valueOf(baseFile.get((Object)"id"));
                if (!ToolUtil.isNotEmpty((Object)id)) return fileMappingMap;
                String relativePath = "common_model".equalsIgnoreCase(String.valueOf(baseFile.get((Object)"parentId"))) ? PathUtil.posixPath((String[])new String[]{"common_model", file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "")}) : file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                if (ToolUtil.isNotEmpty((Object)fileMappingMap.get(id))) {
                    throw new RuntimeException("\u6587\u4ef6id\u91cd\u590d\uff1a" + fileMappingMap.get(id) + "\n" + relativePath);
                }
                fileMappingMap.put(id, PathUtil.posixPath((String[])new String[]{relativePath}));
                return fileMappingMap;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    private String ImageToBase64(String imgFile) {
        byte[] data = null;
        try (FileInputStream in = new FileInputStream(imgFile);){
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] temp = new byte[4096];
            while ((bytesRead = ((InputStream)in).read(temp)) != -1) {
                buffer.write(temp, 0, bytesRead);
            }
            data = buffer.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public void getAllRemoteImages(File[] files, List<Map<String, Object>> imgList, String splitPath, String systemDir) throws Exception {
        if (null != files && files.length > 0) {
            for (File f : files) {
                if (f.isFile()) {
                    HashMap<String, String> imgMap = new HashMap<String, String>();
                    imgMap.put("name", f.getName());
                    imgMap.put("path", this.ImageToBase64(FilePathConvertUtil.getRealFileByPath(f.getPath(), systemDir).getAbsolutePath()));
                    imgMap.put("relativePath", f.getAbsolutePath().substring(FilePathConvertUtil.getRealFileByPath(splitPath, systemDir).getPath().length()).replaceAll("\\\\", "/"));
                    imgMap.put("absolutePath", URLEncoder.encode(f.getAbsolutePath().substring(this.properties.getWorkspace().length()), "utf-8"));
                    imgList.add(imgMap);
                    continue;
                }
                File[] fileList = this.listFiles(f, systemDir);
                this.getAllRemoteImages(fileList, imgList, splitPath, systemDir);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] getFile(String path, String systemDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> getFilePath(String filepath, String type, String systemDir) throws IOException {
        String workSpace = PathUtil.pathFormatterByOs((String)this.properties.getWorkspace());
        ArrayList<String> fileList = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)type)) {
            if (this.isDirectory(new File(filepath), systemDir)) {
                try (Stream<Path> paths = Files.walk(Paths.get(FilePathConvertUtil.getRealFileByPath(filepath, systemDir).getPath(), new String[0]), new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> fileList.add(PathUtil.removePrefix((String)File.separator, (String)PathUtil.pathFormatterByOs((String)file.toString()).replace(workSpace, ""))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.isDirectory(new File(filepath), systemDir)) {
            try (Stream<Path> paths = Files.walk(Paths.get(FilePathConvertUtil.getRealFileByPath(filepath, systemDir).getPath(), new String[0]), new FileVisitOption[0]);){
                paths.map(Path::toString).filter(f -> f.endsWith(type)).map(f -> PathUtil.removePrefix((String)File.separator, (String)PathUtil.pathFormatterByOs((String)f).replace(workSpace, ""))).forEach(fileList::add);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileList;
    }

    /*
     * Exception decompiling
     */
    public String getJsContent(String filePath, String systemDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean writeFile(List<String> writeFileUrlList, List<JSONObject> jsonObjectList, String systemDir) {
        int i = 0;
        if (ToolUtil.isNotEmpty(writeFileUrlList)) {
            for (String url : writeFileUrlList) {
                url = FilePathConvertUtil.getRealFileByPath(url, systemDir).getPath();
                try {
                    FileOutputStream outFile = new FileOutputStream(url);
                    Throwable throwable = null;
                    try {
                        String data = String.valueOf(jsonObjectList.get(i));
                        if (StringUtils.isNotEmpty((CharSequence)data)) {
                            if ("null".equals(data)) {
                                ((OutputStream)outFile).write("".getBytes());
                            } else {
                                ((OutputStream)outFile).write(data.getBytes());
                            }
                            outFile.flush();
                        }
                        ++i;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outFile == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)outFile).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)outFile).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean createNewFile(File file, String systemDir) throws IOException {
        return FilePathConvertUtil.getRealFileByFile(file, systemDir).createNewFile();
    }

    public boolean fixName(String oldFile, String newFile, String systemDir) {
        return FilePathConvertUtil.getRealFileByPath(oldFile, systemDir).renameTo(FilePathConvertUtil.getRealFileByPath(newFile, systemDir));
    }
}

