@echo off
chcp 65001 > nul

REM 获取服务器名称
for /f "delims=" %%a in ('hostname') do set "server_name=%%a"

REM 获取IP地址
for /f "tokens=2 delims=:" %%a in ('ipconfig ^| findstr IPv4') do set "ip_address=%%a"

REM 获取操作系统信息
for /f "tokens=2,* delims=:" %%a in ('systeminfo ^| findstr /C:"OS Name"') do set "os_info=%%a:%%b"

REM 获取CPU使用率
for /f "tokens=2 delims==," %%a in ('wmic cpu get loadpercentage /value ^| findstr "="') do set "cpu_usage=%%a"

REM 获取内存使用情况
for /f "tokens=2 delims==," %%a in ('wmic OS get TotalVisibleMemorySize /value ^| findstr "="') do set "total_mem=%%a"
for /f "tokens=2 delims==," %%a in ('wmic OS get FreePhysicalMemory /value ^| findstr "="') do set "free_mem=%%a"
set /a used_mem=total_mem - free_mem


REM 获取磁盘使用情况
for /f "tokens=1-3 delims== " %%a in ('wmic logicaldisk where "DeviceID='C:'" get FreeSpace^,Size^,VolumeName /format:value') do (
    if "%%a"=="FreeSpace" set "FreeSpace=%%b"
    if "%%a"=="Size" set "TotalSpace=%%b"
    if "%%a"=="VolumeName" set "VolumeName=%%b"
)

REM 计算已用空间
set /a UsedSpace=TotalSpace - FreeSpaceGB



REM 显示磁盘使用情况
echo
REM Display all information
echo Server Name: %server_name%
echo IP Address: %ip_address%
echo Operating System: %os_info%
echo CPU Usage: %cpu_usage%%%
echo Memory Usage: Total Memory: %total_mem% KB, Used Memory: %used_mem% KB, Free Memory: %free_mem% KB
echo Disk Usage (C Drive): Total Space: %TotalSpace% KB, Used Space: %UsedSpace% KB, Free Space: %FreeSpace% KB
pause