#!/bin/bash

ALL_VARS=$1
APPLICATION_DIR=$(echo "$ALL_VARS" | cut -d',' -f1)
APPLICATION_PORT=$(echo "$ALL_VARS" | cut -d',' -f2)
NPM_REGISTRY=$(echo "$ALL_VARS" | cut -d',' -f3)
#去除前后引号
APPLICATION_DIR=${APPLICATION_DIR#\"}
NPM_REGISTRY=${NPM_REGISTRY%\"}

cd $APPLICATION_DIR

# 切换源
pnpm config set registry $NPM_REGISTRY
# 执行 pnpm install
pnpm install

# 检查上一个命令的执行结果，如果成功，则执行 pnpm run serve
if [ $? -eq 0 ]; then
  if [[ $APPLICATION_PORT =~ ^[0-9]+$ && $APPLICATION_PORT -ge 1 && $port -le 65535 ]]; then
     pnpm serve --port $APPLICATION_PORT
    exit 0
  else
    echo "未获取到端口，启动失败！."
    exit 1
  fi
else
    echo "pnpm install 失败，无法继续执行 pnpm serve."
    exit 1
fi