@echo off
setlocal enabledelayedexpansion

REM 检查参数数量是否正确
if "%~1"=="" (
    echo Usage: %0 ^<port^>
    exit /b 1
)

REM 获取端口号参数
set port=%~1

REM 在 netstat 输出中查找指定端口的监听情况，并提取对应的 PID
for /f "tokens=5" %%a in ('netstat -aon ^| findstr LISTENING ^| findstr /r "\<%port%\>"') do (
    set "pid=%%a"
    REM 仅在 PID 后面是冒号时才移除
    if "!pid:~-1!"=="^:" set "pid=!pid:~0,-1!"
)
REM 检查是否找到了对应的 PID
if "%pid%"=="" (
    echo No service is running on port %port%
    exit /b 1
)
echo process id occupying the port: %pid%
REM 停止进程
taskkill /pid %pid% /f >nul 2>nul
echo Service running on port %port% has been stopped
exit /b 0