#!/bin/bash

ALL_VARS=$1

REDIS_HOST=$(echo "$ALL_VARS" | cut -d',' -f1)
REDIS_PASSWORD=$(echo "$ALL_VARS" | cut -d',' -f2)
REDIS_PORT=$(echo "$ALL_VARS" | cut -d',' -f3)
PARENT_DIR=$(echo "$ALL_VARS" | cut -d',' -f4)
APPLICATION_DIR=$(echo "$ALL_VARS" | cut -d',' -f5)
APPLICATION_PORT=$(echo "$ALL_VARS" | cut -d',' -f6)
DEV_USER=$(echo "$ALL_VARS" | cut -d',' -f7)
T_CODE=$(echo "$ALL_VARS" | cut -d',' -f8)

echo "REDIS_HOST: $REDIS_HOST"
echo "REDIS_PASSWORD: $REDIS_PASSWORD"
echo "REDIS_PORT: $REDIS_PORT"
echo "PARENT_DIR: $PARENT_DIR"
echo "APPLICATION_DIR: $APPLICATION_DIR"
echo "APPLICATION_PORT: $APPLICATION_PORT"
echo "DEV_USER: $DEV_USER"
echo "T_CODE: $T_CODE"
cd $PARENT_DIR
mvn clean install
cd $APPLICATION_DIR

export REDIS_HOST=$REDIS_HOST
export REDIS_PASSWORD=$REDIS_PASSWORD
export REDIS_PORT=$REDIS_PORT
export DEV_USER=$DEV_USER
export T_CODE=$T_CODE
if [[ $APPLICATION_PORT =~ ^[0-9]+$ && $APPLICATION_PORT -ge 1 && $port -le 65535 ]]; then
  export APPLICATION_PORT=$APPLICATION_PORT
else
  echo "传入的参数不是一个非空或有效的端口号"
fi
echo "开始启动================================================================"
 mvn spring-boot:run
echo "执行完成======================================================="
exit 0