/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.invocation.tool;

import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellScriptExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellScriptExecutor.class);

    public static CallBack call(String scriptPath, String ... args) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            String line;
            Object[] cmd = new String[]{scriptPath};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
            ProcessBuilder pb = new ProcessBuilder((String[])cmd);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                res.add(line);
            }
            int exitCode = process.waitFor();
            return new CallBack(res, exitCode);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a{}", (Object)scriptPath);
            throw new HussarException((Throwable)e);
        }
    }

    public static void asyncRunLongArg(String scriptPath, String longArg, String ... args) {
        try {
            Object[] cmd = new String[]{scriptPath};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
            ProcessBuilder pb = new ProcessBuilder((String[])cmd);
            pb.redirectErrorStream(true);
            Map<String, String> env = pb.environment();
            env.put("LONG_ARG", longArg);
            Process process = pb.start();
            ShellScriptExecutor.info(process.getInputStream());
            int exitCode = process.waitFor();
            LOGGER.info("\u6279\u5904\u7406\u811a\u672c\u6267\u884c\u5b8c\u6bd5\uff0c\u9000\u51fa\u7801\uff1a" + exitCode);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a{}", (Object)scriptPath);
            throw new HussarException("\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a" + scriptPath, (Throwable)e);
        }
    }

    public static void asyncRun(String scriptPath, String ... args) {
        try {
            Object[] cmd = new String[]{scriptPath};
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])args);
            ProcessBuilder pb = new ProcessBuilder((String[])cmd);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            ShellScriptExecutor.info(process.getInputStream());
            int exitCode = process.waitFor();
            LOGGER.info("\u6279\u5904\u7406\u811a\u672c\u6267\u884c\u5b8c\u6bd5\uff0c\u9000\u51fa\u7801\uff1a" + exitCode);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u811a\u672c\u5931\u8d25\uff1a{}", (Object)scriptPath);
            throw new HussarException((Throwable)e);
        }
    }

    private static void info(InputStream inputStream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                LOGGER.info(line);
            }
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u8f93\u51fa\u5931\u8d25");
        }
    }

    private static void error(InputStream inputStream) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                LOGGER.error(line);
            }
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u8f93\u51fa\u5931\u8d25");
        }
    }

    public static String pathAapt(String path) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            path = String.format("%s.bat", path);
        } else if (os.contains("nix") || os.contains("nux") || os.contains("aix") || os.contains("mac")) {
            path = String.format("%s.sh", path);
        }
        return path;
    }

    public static boolean notExist(String ... path) {
        for (String s : path) {
            if (new File(s).exists()) continue;
            return true;
        }
        return false;
    }

    public static class CallBack {
        private List<String> res;
        private int exitCode;

        public CallBack(List<String> res, int exitCode) {
            this.res = res;
            this.exitCode = exitCode;
        }

        public List<String> getRes() {
            return this.res;
        }

        public void setRes(List<String> res) {
            this.res = res;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public void setExitCode(int exitCode) {
            this.exitCode = exitCode;
        }
    }
}

