/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.database.tool.mysql.filter;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.dao.FormDesignBaseMapper;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.filter.SqlExecuteHandler;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlPublicMethodUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="datasource.mysql")
public class MySqlFilter
implements SqlExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(MySqlFilter.class);
    private static final String HOST_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})";
    private static final String PORT_REG = "(:\\d+)";
    private static final String DB_NAME_REG = "(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final String URL_REG = "(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern DB_NAME_PATTERN = Pattern.compile("(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    private static final Pattern URL_PATTERN = Pattern.compile("(localhost|((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)|([0-9a-z-]{1,}\\.)?[0-9a-z-]{2,}\\.([0-9a-z-]{2,}\\.)?[a-z]{2,})(:\\d+)?(:|\\/)[a-zA-Z0-9-_\\\\.]+");
    @Resource
    private FormDesignBaseMapper formDesignBaseMapper;

    public List<TableInfo> selectBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        List<Map<String, Object>> indexList = null;
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, indexInfo);
    }

    public Optional<TableInfo> selectOne(DataSourceConfig dataSourceConfig, String type, String tableName) throws LcdpException {
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return Optional.empty();
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSql = querySqlModel.getSingleTableTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        String fieldSql = querySqlModel.getSingleFiledTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        String indexSql = querySqlModel.getSingleIndexSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", tableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.execute(tableSql);
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        List<Map<String, Object>> indexList = null;
        if (ToolUtil.isEmpty((Object)tableList)) {
            return Optional.empty();
        }
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return Optional.ofNullable(SqlPublicMethodUtil.combined((TableInfo)((TableInfo)tableInfoList.get(0)), fieldInfo, indexInfo));
    }

    public List<TableInfo> selectTableBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.size() <= 0) {
            return tableInfoList;
        }
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        return tableInfoList;
    }

    public List<TableInfo> selectTableInfoBatch(DataSourceConfig dataSourceConfig, String type, List<String> tableNames) {
        List tableList;
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        if (null == querySqlModel) {
            return tableInfoList;
        }
        dataSourceConfig.setUsername(dataSourceConfig.getUsername().toUpperCase());
        StringBuilder inTableName = new StringBuilder();
        if (HussarUtils.isEmpty(tableNames)) {
            return tableInfoList;
        }
        inTableName.append("'").append(tableNames.get(0)).append("'");
        for (int i = 1; i < tableNames.size(); ++i) {
            inTableName.append(",'").append(tableNames.get(i)).append("'");
        }
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSql = querySqlModel.getTableBatchSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", inTableName);
        String fieldSql = querySqlModel.getFieldBatchSqlTemplate().replace("${dbName}", dbName).replace("${tableName}", inTableName);
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)(tableList = this.formDesignBaseMapper.execute(tableSql)))) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.execute(fieldSql);
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, null);
    }

    public List<TableInfo> getTableInfoWithoutFiled(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList fieldInfo = new ArrayList();
        ArrayList indexInfo = new ArrayList();
        logger.info("\u6279\u91cf\u67e5\u8be2{}\u4fe1\u606f\uff1a\u6570\u636e\u6e90\u4fe1\u606f\uff1a{}", (Object)type, (Object)JSON.toJSONString((Object)dataSourceConfig));
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        Object fieldSql = null;
        Object indexSql = null;
        String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
        }
        if (querySqlModel != null) {
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type)) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("failed to match table type");
                }
            }
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        Object indexList = null;
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        return tableInfoList;
    }

    public List<TableInfo> selectTableInfoWithFieldInfoBatch(DataSourceConfig dataSourceConfig, String type) throws LcdpException {
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        ArrayList<TableField> fieldInfo = new ArrayList<TableField>();
        ArrayList<TableIndex> indexInfo = new ArrayList<TableIndex>();
        QuerySqlModel querySqlModel = SqlPublicMethodUtil.getQuerySqlObject((DataSourceConfig)dataSourceConfig);
        String tableSql = null;
        String fieldSql = null;
        String indexSql = null;
        String tableSqlWithTask = null;
        if (querySqlModel != null) {
            String dbName = this.getDataBaseName(dataSourceConfig.getUrl());
            tableSql = querySqlModel.getTableSqlTemplate().replace("${dbName}", dbName);
            fieldSql = querySqlModel.getFieldSqlTemplate().replace("${dbName}", dbName);
            indexSql = querySqlModel.getIndexSqlTemplate().replace("${dbName}", dbName);
            tableSqlWithTask = querySqlModel.getTableSqlWithTaskTemplate().replace("${dbName}", dbName);
        }
        if (ToolUtil.isNotEmpty((Object)type) && tableSql != null) {
            switch (type) {
                case "VIEW": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "VIEW");
                    break;
                }
                case "BASE TABLE": {
                    tableSql = tableSql.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "ALL": {
                    tableSql = tableSql.replace("${tableType}", "VIEW").replace("${tableType1}", "BASE TABLE");
                    break;
                }
                case "BASE TABLE TASK": {
                    if (tableSqlWithTask == null) break;
                    tableSql = tableSqlWithTask.replace("${tableType}", "BASE TABLE").replace("${tableType1}", "BASE TABLE");
                }
            }
        }
        if (ToolUtil.isEmpty((Object)querySqlModel)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_SUPPORT_DATA_BASE, dataSourceConfig.getUrl());
        }
        List tableList = this.formDesignBaseMapper.selectList(tableSql);
        if (tableList.isEmpty()) {
            return tableInfoList;
        }
        List fieldList = this.formDesignBaseMapper.selectList(fieldSql);
        List indexList = this.formDesignBaseMapper.selectList(indexSql);
        MySqlFilter.dealTableResultMap(tableInfoList, tableList);
        this.dealFieldResultMap(fieldInfo, fieldList);
        this.dealIndexResultMap(indexInfo, indexList);
        return SqlPublicMethodUtil.combinedBatch(tableInfoList, fieldInfo, indexInfo);
    }

    public static void dealTableResultMap(List<TableInfo> tableInfoList, List<Map<String, Object>> tableResultSet) {
        tableResultSet.forEach(stringObjectMap -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)stringObjectMap.get("name"));
            tableInfo.setComment((String)stringObjectMap.get("comment"));
            String type = (String)stringObjectMap.get("type");
            tableInfo.setType(type);
            tableInfo.setView(!"BASE TABLE".equalsIgnoreCase(type));
            tableInfoList.add(tableInfo);
        });
    }

    private void dealFieldResultMap(List<TableField> fieldInfo, List<Map<String, Object>> fieldList) {
        Map map = (Map)JSON.parseObject((String)this.getOperationDesc(), Map.class);
        fieldList.forEach(stringObjectMap -> {
            TableField tableField = new TableField();
            tableField.setTableName(Optional.ofNullable((String)stringObjectMap.get("tablename")).orElse(""));
            tableField.setName(Optional.ofNullable((String)stringObjectMap.get("name")).orElse(""));
            tableField.setComment(Optional.ofNullable((String)stringObjectMap.get("comment")).orElse(""));
            tableField.setType(Optional.ofNullable((String)stringObjectMap.get("type2")).orElse(""));
            tableField.setPrimarys(Optional.ofNullable((String)stringObjectMap.get("primarys")).orElse(""));
            try {
                Number dataLength;
                Object objectLength = stringObjectMap.get(this.getColumnLengthKeyByType(tableField.getType(), map));
                int dataLengthValue = 0;
                if (objectLength instanceof BigInteger) {
                    dataLength = (BigInteger)objectLength;
                    dataLengthValue = ((BigInteger)dataLength).intValue();
                } else if (objectLength instanceof Long) {
                    dataLength = (Long)objectLength;
                    dataLengthValue = ((Long)dataLength).intValue();
                }
                tableField.setDataLength(dataLengthValue);
                BigInteger dataDot = Optional.ofNullable((BigInteger)stringObjectMap.get("dataDot")).orElse(BigInteger.valueOf(0L));
                tableField.setDataDot(Integer.parseInt(dataDot.toString()));
            }
            catch (Exception e) {
                logger.error("inputParams:{} and errorMessage:{}", new Object[]{tableField.toString(), e.getMessage(), e});
            }
            tableField.setDataDefaultValue(Optional.ofNullable((String)stringObjectMap.get("dataDefaultValue")).orElse(""));
            tableField.setDataIsEmpty(!"YES".equalsIgnoreCase(Optional.ofNullable((String)stringObjectMap.get("dataIsEmpty")).orElse("")));
            fieldInfo.add(tableField);
        });
    }

    private void dealIndexResultMap(List<TableIndex> indexInfo, List<Map<String, Object>> indexList) {
        if (HussarUtils.isEmpty(indexList)) {
            return;
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (Integer.valueOf(indexList.get(i).get("isPrimaryIndex").toString()) == 1) continue;
            TableIndex tableIndex = new TableIndex();
            tableIndex.setIndexName((String)indexList.get(i).get("indexName"));
            tableIndex.setIndexType((String)indexList.get(i).get("indexType"));
            tableIndex.setTableName((String)indexList.get(i).get("tableName"));
            tableIndex.setTableSchema((String)indexList.get(i).get("tableSchema"));
            tableIndex.setColumnName((String)indexList.get(i).get("columnName"));
            tableIndex.setIsNonUnique(Integer.parseInt(indexList.get(i).get("isNonUnique").toString()));
            indexInfo.add(tableIndex);
        }
    }

    private String getColumnLengthKeyByType(String type, Map<String, List<String>> map) {
        if (ToolUtil.isNotEmpty((Object)type)) {
            String columnName = "dataLength";
            String fieldType = "";
            for (Map.Entry<String, List<String>> stringListEntry : map.entrySet()) {
                List<String> value = stringListEntry.getValue();
                if (!ToolUtil.isNotEmpty(value) || !value.contains(type.toUpperCase())) continue;
                fieldType = stringListEntry.getKey();
                break;
            }
            switch (fieldType) {
                case "CharacterType": {
                    columnName = "dataLength";
                    break;
                }
                case "NumericType": {
                    columnName = "intLength";
                    break;
                }
                case "DateTimeType": {
                    columnName = "dateLength";
                    break;
                }
                case "LargeCharacterType": {
                    if ("TEXT".equals(type.toUpperCase()) || "LONGTEXT".equalsIgnoreCase(type)) {
                        columnName = null;
                        break;
                    }
                    columnName = "dataLength";
                    break;
                }
                case "DateType": {
                    columnName = null;
                    break;
                }
            }
            return columnName;
        }
        return "dataLength";
    }

    private String getOperationDesc() {
        InputStream inputStream = this.getClass().getResourceAsStream("/mysqlFieldMappingTablecolumn.json");
        assert (inputStream != null);
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDataBaseName(String url) {
        if (url.indexOf(63) > -1) {
            url = url.substring(0, url.indexOf(63));
        }
        String dbName = "";
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            String urlName = urlMatcher.group(0);
            Matcher dbNameMatcher = DB_NAME_PATTERN.matcher(urlName);
            ArrayList<String> dbNameList = new ArrayList<String>();
            while (dbNameMatcher.find()) {
                dbNameList.add(dbNameMatcher.group());
            }
            if (ToolUtil.isNotEmpty(dbNameList)) {
                dbName = ((String)dbNameList.get(dbNameList.size() - 1)).substring(1);
            }
        }
        return dbName;
    }
}

