/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.Lists;

public class JsDataStrUtil {
    public static final Map<Character, Character> DATA_KEY_MAP = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('{'), Character.valueOf('}'));
            this.put(Character.valueOf('['), Character.valueOf(']'));
        }
    };
    public static final String DATA_KEY_SPIT = ":";
    public static final String DATA_KEY_REX = "([a-zA-Z0-9-_.']+):";

    public static List<String> getDataKeys(String dataStr) {
        ArrayList dataKeys = Lists.newArrayList();
        if (dataStr.indexOf(DATA_KEY_SPIT) > 0) {
            String outStr = JsDataStrUtil.getOutSideStr(dataStr.replace(" ", ""));
            Pattern pattern = Pattern.compile(DATA_KEY_REX);
            Matcher matcher = pattern.matcher(outStr);
            while (matcher.find()) {
                dataKeys.add(matcher.group(1));
            }
        }
        return dataKeys;
    }

    private static String getOutSideStr(String dataStr) {
        int keyCount = 0;
        char startChar = ' ';
        char endChar = ' ';
        StringBuilder res = new StringBuilder();
        for (char aByte : dataStr.toCharArray()) {
            if (startChar == aByte) {
                ++keyCount;
            }
            if (keyCount == 0 && DATA_KEY_MAP.containsKey(Character.valueOf(aByte))) {
                ++keyCount;
                startChar = aByte;
                endChar = DATA_KEY_MAP.get(Character.valueOf(aByte)).charValue();
            }
            if (keyCount == 0) {
                res.append(aByte);
            }
            if (aByte != endChar) continue;
            --keyCount;
        }
        return res.toString();
    }
}

