/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import java.util.regex.Pattern;

public class StyleGenerateUtil {
    private static final String VAR_PREFIX = "${prefix}";
    private static final String VAR_VALUE = "${val}";
    private static final String VAR_BACKGROUND = "background:";
    private static final String DEEP_SELECTOR = " /deep/ ";
    private static final Pattern REGEXP_TRIM_LEFT = Pattern.compile("\\s+$", 8);
    private static final Pattern REGEXP_TRIM_RIGHT = Pattern.compile("^\\s+", 8);
    private static final Pattern REGEXP_DEEP_NOT_REQUIRED = Pattern.compile("^\\s*(,|\\{|~|\\+|$).*", 8);
    private static final Pattern REGEXP_PREFIX_SPLIT = Pattern.compile(Pattern.quote("${prefix}"), 8);
    private static final Pattern REGEXP_COMBINATOR_DEEP_SELECTOR = Pattern.compile("\\s*(/deep/|>>>)\\s*", 8);
    private static final Pattern REGEXP_PSEUDO_DEEP_SELECTOR = Pattern.compile("::v-deep", 8);
    private static final Pattern REGEXP_BACKGROUND = Pattern.compile("background(-color):\\s*", 8);

    public static String vueInnerStyleRender(String template, boolean noDeep, String prefix, String value) {
        template = StyleGenerateUtil.backgroundReplace(template);
        if (noDeep) {
            return template.replace(VAR_PREFIX, prefix).replace(VAR_VALUE, value);
        }
        CharSequence[] segments = REGEXP_PREFIX_SPLIT.split(template, -1);
        for (int i = 1; i < segments.length; ++i) {
            segments[i] = StyleGenerateUtil.insertDeepSelector((String)segments[i]);
        }
        return String.join((CharSequence)prefix, segments).replace(VAR_VALUE, value);
    }

    public static String backgroundReplace(String template) {
        return REGEXP_BACKGROUND.matcher(template).replaceAll(VAR_BACKGROUND);
    }

    public static String insertDeepSelector(String suffix) {
        int point = StyleGenerateUtil.findDeepSelectorInsertPoint(suffix);
        if (point < 0) {
            return suffix;
        }
        String left = REGEXP_TRIM_LEFT.matcher(suffix.substring(0, point)).replaceAll("");
        String right = REGEXP_TRIM_RIGHT.matcher(suffix.substring(point)).replaceAll("");
        return left + DEEP_SELECTOR + right;
    }

    private static int findDeepSelectorInsertPoint(String suffix) {
        char quoted = '\u0000';
        boolean escape = false;
        int parens = 0;
        int point = -1;
        for (int i = 0; i < suffix.length(); ++i) {
            char c = suffix.charAt(i);
            if (quoted > '\u0000') {
                if (escape) {
                    escape = false;
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c != quoted) continue;
                quoted = '\u0000';
                escape = false;
                continue;
            }
            if (c == '\"' || c == '\'') {
                quoted = c;
                escape = false;
                continue;
            }
            if (c == '[' || c == '(') {
                ++parens;
                continue;
            }
            if (c == ']' || c == ')') {
                --parens;
                continue;
            }
            if ((Character.isWhitespace(c) || c == '>' || c == '+' || c == '~' || c == ',') && parens <= 0) {
                point = i;
                break;
            }
            if (c != '{') continue;
            point = i;
            break;
        }
        if (point >= 0 && !REGEXP_DEEP_NOT_REQUIRED.matcher(suffix.substring(point)).matches()) {
            return point;
        }
        return -1;
    }

    public static String removeDeepSelectors(String template) {
        if (template == null) {
            return null;
        }
        template = REGEXP_COMBINATOR_DEEP_SELECTOR.matcher(template).replaceAll(" ");
        template = REGEXP_PSEUDO_DEEP_SELECTOR.matcher(template).replaceAll("");
        return template;
    }
}

