/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class ResourcesUtil {
    private static final Pattern REGEXP_JAR_LEVEL = Pattern.compile("\\.(jar|war|zip)!", 2);

    public static List<ResolvedResource> resolve(String root, String extension) throws IOException {
        return ResourcesUtil.resolve(root, extension, Options.build());
    }

    public static List<ResolvedResource> resolve(String root, String extension, DeduplicationBehaviour deduplicationBehaviour) throws IOException {
        Options options = Options.build().deduplication(true).deduplicationBehaviour(deduplicationBehaviour != null ? deduplicationBehaviour : DeduplicationBehaviour.KEEP_FIRST);
        return ResourcesUtil.resolve(root, extension, options);
    }

    public static List<ResolvedResource> resolve(String root, String extension, Options options) throws IOException {
        if (StringUtils.isEmpty((CharSequence)root)) {
            throw new NullPointerException();
        }
        if (options == null) {
            options = Options.build();
        }
        String[] stringArray = new String[4];
        stringArray[0] = "classpath*:/";
        stringArray[1] = root;
        String string = stringArray[2] = options.isRecursive() ? "**" : null;
        stringArray[3] = extension == null ? "*" : (extension.startsWith(".") ? "*" + extension : "*." + extension);
        String pattern = FileUtil.posixPath(stringArray);
        Resource[] resources = new PathMatchingResourcePatternResolver().getResources(pattern);
        ArrayList<ResolvedResource> resolved = new ArrayList<ResolvedResource>();
        for (Resource resource : resources) {
            boolean directory;
            String path;
            URL url = resource.getURL();
            if (ResourceUtils.isJarURL((URL)url)) {
                String[] nested = REGEXP_JAR_LEVEL.split(url.getPath(), -1);
                String inner = nested.length > 0 ? nested[nested.length - 1] : "";
                path = URLDecoder.decode(inner, StandardCharsets.UTF_8.name());
                directory = StringUtils.endsWith((CharSequence)path, (CharSequence)"/");
            } else if (ResourceUtils.isFileURL((URL)url)) {
                String file = FilenameUtils.normalize((String)resource.getFile().getPath());
                path = ResourcesUtil.fileToPath(root, file);
                directory = FileUtils.isDirectory(resource.getFile());
            } else {
                throw new UnsupportedOperationException();
            }
            if (directory && !options.isIncludeDirs()) continue;
            resolved.add(new ResolvedResource(directory, path, resource));
        }
        if (options.isDeduplication()) {
            LinkedHashMap<String, ResolvedResource> deduplicated = new LinkedHashMap<String, ResolvedResource>();
            switch (options.getDeduplicationBehaviour()) {
                case NO_DUPLICATION: {
                    for (ResolvedResource resource : resolved) {
                        if (deduplicated.containsKey(resource.getPath())) {
                            throw new FileAlreadyExistsException("duplicated resource: " + resource + " and " + deduplicated.get(resource.getPath()));
                        }
                        deduplicated.put(resource.getPath(), resource);
                    }
                    resolved = new ArrayList(deduplicated.values());
                    break;
                }
                case KEEP_FIRST: {
                    for (ResolvedResource resource : resolved) {
                        deduplicated.putIfAbsent(resource.getPath(), resource);
                    }
                    resolved = new ArrayList(deduplicated.values());
                    break;
                }
                case KEEP_LAST: {
                    Collections.reverse(resolved);
                    for (ResolvedResource resource : resolved) {
                        deduplicated.putIfAbsent(resource.getPath(), resource);
                    }
                    resolved = new ArrayList(deduplicated.values());
                    Collections.reverse(resolved);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (options.isSorted()) {
            resolved.sort(Comparator.comparing(ResolvedResource::getPath));
        }
        return resolved;
    }

    private static String fileToPath(String root, String file) throws IOException {
        String removal = FileUtil.systemPath("/", "classes");
        String affix = FileUtil.systemPath(removal, root, "/");
        int index = file.lastIndexOf(affix);
        if (index >= 0) {
            return FileUtil.posixPath(file.substring(index + removal.length()));
        }
        affix = FileUtil.systemPath("/", root, "/");
        if (affix.length() < 2) {
            throw new IOException("cannot translate resource path: " + file);
        }
        index = file.lastIndexOf(affix);
        if (index >= 0) {
            return FileUtil.posixPath(file.substring(index));
        }
        throw new IOException("illegal resource path: " + file);
    }

    public static class ResolvedResource {
        private final boolean directory;
        private final String path;
        private final Resource resource;

        public ResolvedResource(boolean directory, String path, Resource resource) {
            this.directory = directory;
            this.path = path;
            this.resource = resource;
        }

        public long contentLength() throws IOException {
            if (this.resource == null) {
                throw new FileNotFoundException("resource: " + this.path);
            }
            return this.resource.contentLength();
        }

        public byte[] contentBytes() throws IOException {
            InputStream input = this.getInputStream();
            if (input == null) {
                return null;
            }
            return IOUtils.toByteArray((InputStream)input);
        }

        public String contentString() throws IOException {
            return this.contentString(StandardCharsets.UTF_8);
        }

        public String contentString(Charset charset) throws IOException {
            InputStream input = this.getInputStream();
            if (input == null) {
                return null;
            }
            return IOUtils.toString((InputStream)input, (Charset)charset);
        }

        public InputStream getInputStream() throws IOException {
            if (this.resource == null) {
                throw new FileNotFoundException("resource: " + this.path);
            }
            return this.resource.getInputStream();
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public String getPath() {
            return this.path;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String toString() {
            return "ResolvedResource [" + this.path + " => " + this.resource + "]";
        }
    }

    public static enum DeduplicationBehaviour {
        NO_DUPLICATION,
        KEEP_FIRST,
        KEEP_LAST;

    }

    public static class Options {
        private boolean recursive = true;
        private boolean includeDirs = false;
        private boolean deduplication = false;
        private boolean sorted = false;
        private DeduplicationBehaviour deduplicationBehaviour = DeduplicationBehaviour.KEEP_FIRST;

        private Options() {
        }

        public static Options build() {
            return new Options();
        }

        public Options recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Options includeDirs(boolean includeDirs) {
            this.includeDirs = includeDirs;
            return this;
        }

        public Options deduplication(boolean deduplication) {
            this.deduplication = deduplication;
            return this;
        }

        public Options sorted(boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        public Options deduplicationBehaviour(DeduplicationBehaviour deduplicationBehaviour) {
            if (deduplicationBehaviour == null) {
                throw new NullPointerException();
            }
            this.deduplicationBehaviour = deduplicationBehaviour;
            return this;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean isIncludeDirs() {
            return this.includeDirs;
        }

        public boolean isDeduplication() {
            return this.deduplication;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        public DeduplicationBehaviour getDeduplicationBehaviour() {
            return this.deduplicationBehaviour;
        }
    }
}

