/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.common.constant.FileConstant;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileUtil
extends FileConstant {
    private static final boolean IS_WINDOWS = "\\".equals(File.separator);

    private FileUtil() {
    }

    public static String posixPath(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    public static String posixPathByOldWay(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        StringBuilder sb = new StringBuilder();
        for (String segment : segments) {
            String[] parts;
            if (segment == null || segment.isEmpty()) continue;
            for (String part : parts = segment.split("[/\\\\]", -1)) {
                if (part.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(part);
            }
        }
        String path = sb.toString();
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    public static String systemPath(String ... segments) {
        boolean leadingSlash;
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingUnc = IS_WINDOWS && segments[0].startsWith("\\\\");
        boolean bl = leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        String prefix = leadingUnc ? "\\\\" : (leadingSlash ? File.separator : "");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String suffix = trailingSlash ? File.separator : "";
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining(File.separator));
        if (path.isEmpty() && !prefix.isEmpty() && !suffix.isEmpty()) {
            return prefix;
        }
        return prefix + path + suffix;
    }

    public static String systemPathByOldWay(String ... segments) {
        boolean leadingSlash;
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingUnc = IS_WINDOWS && segments[0].startsWith("\\\\");
        boolean bl = leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        String prefix = leadingUnc ? "\\\\" : (leadingSlash ? File.separator : "");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String suffix = trailingSlash ? File.separator : "";
        StringBuilder sb = new StringBuilder();
        for (String segment : segments) {
            String[] parts;
            if (segment == null || segment.isEmpty()) continue;
            for (String part : parts = segment.split("[/\\\\]", -1)) {
                if (part.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(File.separator);
                }
                sb.append(part);
            }
        }
        String path = sb.toString();
        if (path.isEmpty() && !prefix.isEmpty() && !suffix.isEmpty()) {
            return prefix;
        }
        return prefix + path + suffix;
    }

    public static String packagePath(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        return Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[./\\\\]", -1))).filter(segment -> !segment.isEmpty()).map(String::toLowerCase).collect(Collectors.joining("."));
    }

    private static String[] preprocessPathSegments(String[] segments) {
        if (segments == null) {
            return new String[0];
        }
        ArrayList<String> filteredSegments = new ArrayList<String>();
        for (String segment : segments) {
            if (segment == null || segment.isEmpty()) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments.toArray(new String[0]);
    }

    public static String removePathPrefix(String prefix, String path) {
        try {
            if (ToolUtil.isEmpty(path)) {
                return path;
            }
            prefix = FileUtil.systemPathByOldWay(prefix);
            String relative = FileUtil.getRelativePath(path = FileUtil.systemPathByOldWay(path), prefix, File.separator);
            if (relative.startsWith(".." + File.separator)) {
                throw new IllegalArgumentException("not prefix: '" + prefix + "' to '" + path + "'");
            }
            return StringUtils.removeStart((String)relative, (String)("." + File.separator));
        }
        catch (Exception e) {
            System.err.println("removePathPrefix: prefix=" + prefix + ", path = " + path);
            e.printStackTrace();
            throw e;
        }
    }

    public static String removePathPrefixAndConvertPosix(String prefix, String path) {
        if (ToolUtil.isEmpty(path)) {
            return path;
        }
        return FileUtil.posixPath(FileUtil.removePathPrefix(prefix, path));
    }

    public static String getRelativeModule(String targetPath, String basePath, String pathSeparator) {
        String relativePath = FileUtil.getRelativePath(targetPath, basePath, pathSeparator);
        if (relativePath.lastIndexOf("/") == -1) {
            return relativePath;
        }
        return relativePath.substring(0, relativePath.lastIndexOf("/"));
    }

    private static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex]).append(pathSeparator);
        }
        if (commonIndex == 0) {
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append("..").append(pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    public static String addSuffix(String str) {
        if (ToolUtil.isNotEmpty(str)) {
            String suffix = str.substring(str.length() - 1);
            if (suffix.equals("/") || suffix.equals("\\")) {
                return str;
            }
            return str + File.separator;
        }
        return "";
    }

    public static String removePrefix(String prefix, String path) {
        prefix = FilenameUtils.normalize((String)prefix);
        path = FilenameUtils.normalize((String)path);
        if (ToolUtil.isNotEmpty(prefix) && prefix.equals(path.substring(0, prefix.length()))) {
            path = path.substring(prefix.length());
        }
        return path;
    }

    public static String complementFilePath(String path) {
        boolean isModulePathEndWithSeparator = path.endsWith(File.separator);
        if (!isModulePathEndWithSeparator) {
            path = path + File.separator;
        }
        return path;
    }

    public static String modularizationPath(String path, String prefix) {
        String[] str;
        for (String s : str = path.split(",")) {
            String[] configPath = s.split(":");
            if (ToolUtil.isEmpty(configPath) || configPath.length <= 1 || !HussarUtils.equals((Object)configPath[0], (Object)prefix)) continue;
            return configPath[1];
        }
        return "";
    }

    public static String readFileToString(String filePath) {
        try {
            if (!new File(filePath).exists()) {
                return null;
            }
            return FileUtils.readFileToString((File)new File(filePath), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
    }

    public static JSONObject dealCopyTemplate(JSONObject jsonObject) {
        try {
            Rules rule = new Rules();
            rule.setReplacement("");
            rule.setKeyPattern("^(slots\\.default\\[(\\d+)\\]\\.)+events\\[(\\d+)\\]\\.children\\[(\\d+)\\]\\.paramValues\\.templatePrintAction$");
            rule.setValuePattern("");
            rule.setReplaceType("FULL");
            HashMap<Pattern, ReplaceConfig> replaceRules = new HashMap<Pattern, ReplaceConfig>();
            replaceRules.put(Pattern.compile(rule.getKeyPattern()), new ReplaceConfig(rule.getReplaceType(), rule.getValuePattern(), rule.getReplacement()));
            FileUtil.traverseJSONObject(jsonObject, "", replaceRules);
            return jsonObject;
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }

    private static void traverseJSONObject(JSONObject obj, String currentPath, Map<Pattern, ReplaceConfig> replaceRules) {
        for (String key : obj.keySet()) {
            Object value = obj.get((Object)key);
            String newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
            for (Map.Entry<Pattern, ReplaceConfig> entry : replaceRules.entrySet()) {
                if (!entry.getKey().matcher(newPath).matches()) continue;
                ReplaceConfig config = entry.getValue();
                if (config.getType() == ReplaceType.FULL) {
                    obj.put(key, (Object)config.getReplacement());
                    break;
                }
                if (config.getType() != ReplaceType.PARTIAL || !(value instanceof String)) break;
                String newValue = ((String)value).replaceAll(config.getValuePattern(), config.getReplacement());
                obj.put(key, (Object)newValue);
                break;
            }
            if (value instanceof JSONObject) {
                FileUtil.traverseJSONObject((JSONObject)value, newPath, replaceRules);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            FileUtil.traverseJSONArray((JSONArray)value, newPath, replaceRules);
        }
    }

    private static void traverseJSONArray(JSONArray array, String currentPath, Map<Pattern, ReplaceConfig> replaceRules) {
        block0: for (int i = 0; i < array.size(); ++i) {
            Object element = array.get(i);
            String newPath = currentPath + "[" + i + "]";
            if (element instanceof String) {
                for (Map.Entry<Pattern, ReplaceConfig> entry : replaceRules.entrySet()) {
                    if (!entry.getKey().matcher(newPath).matches()) continue;
                    ReplaceConfig config = entry.getValue();
                    if (config.getType() == ReplaceType.PARTIAL) {
                        String newValue = ((String)element).replaceAll(config.getValuePattern(), config.getReplacement());
                        array.set(i, (Object)newValue);
                        continue block0;
                    }
                    array.set(i, (Object)config.getReplacement());
                    continue block0;
                }
                continue;
            }
            if (element instanceof JSONObject) {
                FileUtil.traverseJSONObject((JSONObject)element, newPath, replaceRules);
                continue;
            }
            if (!(element instanceof JSONArray)) continue;
            FileUtil.traverseJSONArray((JSONArray)element, newPath, replaceRules);
        }
    }

    static enum ReplaceType {
        FULL,
        PARTIAL;

    }

    static class ReplaceConfig
    extends Rules {
        private ReplaceType type;

        public ReplaceConfig(String replaceType, String valuePattern, String replacement) {
            this.type = "FULL".equalsIgnoreCase(replaceType) ? ReplaceType.FULL : ReplaceType.PARTIAL;
            ((Rules)this).valuePattern = valuePattern;
            ((Rules)this).replacement = replacement;
        }

        public ReplaceType getType() {
            return this.type;
        }

        public void setType(ReplaceType type) {
            this.type = type;
        }
    }

    static class Rules {
        private String replaceType;
        private String valuePattern;
        private String replacement;
        private String keyPattern;

        Rules() {
        }

        public String getReplaceType() {
            return this.replaceType;
        }

        public void setReplaceType(String replaceType) {
            this.replaceType = replaceType;
        }

        public String getValuePattern() {
            return this.valuePattern;
        }

        public void setValuePattern(String valuePattern) {
            this.valuePattern = valuePattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public String getKeyPattern() {
            return this.keyPattern;
        }

        public void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }
    }
}

