/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.dao.ISysMidFileInfoMapper;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMidFileInfoServiceImpl
extends HussarServiceImpl<ISysMidFileInfoMapper, SysMidFileInfo>
implements ISysMidFileInfoService {
    @Resource
    private PrefixEntry prefixEntry;

    private LambdaQueryWrapper<SysMidFileInfo> lambdaQueryWrapper() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SysMidFileInfo.class);
        if (VfgModeTool.isModularization()) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysMidFileInfo::getAppId, (Object)this.prefixEntry.getPrefix())).eq(SysMidFileInfo::getTenantCode, (Object)BaseSecurityUtil.getUser().getTenantCode());
        }
        return lambdaQueryWrapper;
    }

    private LambdaUpdateWrapper<SysMidFileInfo> lambdaUpdateWrapper() {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate(SysMidFileInfo.class);
        if (VfgModeTool.isModularization()) {
            ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(SysMidFileInfo::getAppId, (Object)this.prefixEntry.getPrefix())).eq(SysMidFileInfo::getTenantCode, (Object)BaseSecurityUtil.getUser().getTenantCode());
        }
        return lambdaUpdateWrapper;
    }

    @Override
    public SysMidFileInfo getByPath(String path) {
        return (SysMidFileInfo)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getMidFileInfoPath, (Object)path)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })));
    }

    @Override
    public boolean checkExist(String absolutePath) {
        long count = this.count((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getMidFileInfoPath, (Object)absolutePath)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
        return count != 0L;
    }

    @Override
    public void update(String path, String fileContent) {
        this.update((Wrapper)((LambdaUpdateWrapper)this.lambdaUpdateWrapper().eq(SysMidFileInfo::getMidFileInfoPath, (Object)path)).set(SysMidFileInfo::getMidFileInfoData, (Object)fileContent));
    }

    @Override
    public void removeByPath(String path) {
        List sysMidFileInfos = this.list((Wrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getMidFileInfoPath, (Object)path));
        if (HussarUtils.isNotEmpty((Object)sysMidFileInfos)) {
            for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
                sysMidFileInfo.setDelFlag("1");
            }
            this.updateBatchById(sysMidFileInfos);
        }
    }

    @Override
    public void saveMore(SysMidFileInfo sysMidFileInfo) {
        if (VfgModeTool.isModularization()) {
            String appId = this.prefixEntry.getPrefix();
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            sysMidFileInfo.setAppId(appId);
            sysMidFileInfo.setTenantCode(tenantCode);
        }
        this.save((BaseEntity)sysMidFileInfo);
    }

    @Override
    public List<SysMidFileInfo> listByPageType(String pageType) {
        return this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getPageType, (Object)pageType)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    @Override
    public List<SysMidFileInfo> listLikePath(String path) {
        return this.list((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().like(SysMidFileInfo::getMidFileInfoPath, (Object)path)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        }));
    }

    @Override
    public void removeInPaths(List<String> paths) {
        List sysMidFileInfos = this.list((Wrapper)this.lambdaQueryWrapper().in(SysMidFileInfo::getMidFileInfoPath, paths));
        if (HussarUtils.isNotEmpty((Object)sysMidFileInfos)) {
            for (SysMidFileInfo sysMidFileInfo : sysMidFileInfos) {
                sysMidFileInfo.setDelFlag("1");
            }
            this.updateBatchById(sysMidFileInfos);
        }
    }

    @Override
    public void saveOrUpdateMore(SysMidFileInfo sysMidFileInfo, String filePath) {
        if (VfgModeTool.isModularization()) {
            String appId = this.prefixEntry.getPrefix();
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            sysMidFileInfo.setAppId(appId);
            sysMidFileInfo.setTenantCode(tenantCode);
        }
        this.saveOrUpdate((Object)sysMidFileInfo, (Wrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getMidFileInfoPath, (Object)filePath));
    }

    @Override
    public SysMidFileInfo getByFileId(Long fileId) {
        return (SysMidFileInfo)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)this.lambdaQueryWrapper().eq(SysMidFileInfo::getMidFileId, (Object)fileId)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(HussarDelflagEntity::getDelFlag)).or()).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        })));
    }

    @Override
    public void saveOrUpdateMore(SysMidFileInfo sysMidFileInfo) {
        if (VfgModeTool.isModularization()) {
            String appId = this.prefixEntry.getPrefix();
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            sysMidFileInfo.setAppId(appId);
            sysMidFileInfo.setTenantCode(tenantCode);
        }
        this.saveOrUpdate((BaseEntity)sysMidFileInfo);
    }

    @Override
    public List<SysMidFileInfo> listInPaths(List<String> paths) {
        return this.list((Wrapper)this.lambdaQueryWrapper().in(SysMidFileInfo::getMidFileInfoPath, paths));
    }
}

