/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.project.scenes;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.common.constant.path.PathEnum;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class MicroService
implements PrefixEntry {
    @Resource
    private ISysApplicationBoService iSysApplicationBoService;
    private static final String SERVER_NAME = "serviceName";
    private static final String MICRO_CODE = "microCode";

    @Override
    public String getPrefix() {
        HttpServletRequest request = AppContextUtil.getRequest();
        if (HussarUtils.isEmpty((Object)request)) {
            return "";
        }
        Object attribute = request.getAttribute(SERVER_NAME);
        if (attribute instanceof String) {
            return (String)attribute;
        }
        return Optional.ofNullable(request.getHeader(SERVER_NAME)).filter(serverName -> !serverName.isEmpty() && !"null".equals(serverName) && !"undefined".equals(serverName)).orElse("");
    }

    @Override
    public String scene() {
        String prefix = this.getPrefix();
        if (ToolUtil.isNotEmpty(AppContextUtil.getDeploymentMode())) {
            if (PathEnum.FRONT_SINGLE_BACK_SINGLE.getScene().equals(AppContextUtil.getDeploymentMode())) {
                return PathEnum.FRONT_SINGLE_BACK_SINGLE.getScene();
            }
            if (PathEnum.FRONT_SINGLE_BACK_MICRO.getScene().equals(AppContextUtil.getDeploymentMode())) {
                return PathEnum.FRONT_SINGLE_BACK_MICRO.getScene();
            }
            if (PathEnum.FRONT_MICRO_BACK_MICRO.getScene().equals(AppContextUtil.getDeploymentMode())) {
                return PathEnum.FRONT_MICRO_BACK_MICRO.getScene();
            }
            if (PathEnum.MODULARIZATION.getScene().equals(AppContextUtil.getDeploymentMode())) {
                return PathEnum.MODULARIZATION.getScene();
            }
            return AppContextUtil.getDeploymentMode();
        }
        if (ObjectUtils.isEmpty((Object)prefix) && ObjectUtils.isEmpty((Object)AppContextUtil.getAppId())) {
            return PathEnum.FRONT_SINGLE_BACK_SINGLE.getScene();
        }
        if (ObjectUtils.isNotEmpty((Object)AppContextUtil.getAppId()) && VfgModeTool.isRemote()) {
            SysApplicationVo data;
            if (ObjectUtils.isEmpty((Object)this.getPrefix()) && "20".equals((data = this.iSysApplicationBoService.getAppDetail(Long.valueOf(AppContextUtil.getAppId()))).getAppType())) {
                AppContextUtil.setPrefix(SERVER_NAME, data.getAppCode());
                return PathEnum.MODULARIZATION.getScene();
            }
            return PathEnum.MODULARIZATION.getScene();
        }
        if (ToolUtil.isNotEmpty(this.getMicroPrefix())) {
            return PathEnum.FRONT_MICRO_BACK_MICRO.getScene();
        }
        if (ToolUtil.isNotEmpty(this.getPrefix()) && ToolUtil.isEmpty(this.getMicroPrefix())) {
            return PathEnum.FRONT_SINGLE_BACK_MICRO.getScene();
        }
        return PathEnum.FRONT_SINGLE_BACK_SINGLE.getScene();
    }

    @Override
    public SysApplicationVo getAppByCode() {
        List manageAppList = this.iSysApplicationBoService.getManageAppList(null, null, null);
        SysApplicationVo sysApplicationVo = new SysApplicationVo();
        String prefix = this.getPrefix();
        for (SysAppGroupVo sysAppGroupVo : manageAppList) {
            if (!sysAppGroupVo.getSysApplicationList().stream().anyMatch(app -> app.getAppCode().equals(prefix))) continue;
            sysApplicationVo = sysAppGroupVo.getSysApplicationList().stream().filter(app -> app.getAppCode().equals(prefix)).findFirst().orElse(null);
            break;
        }
        return sysApplicationVo;
    }

    @Override
    public String getMicroPrefix() {
        HttpServletRequest request = AppContextUtil.getRequest();
        if (HussarUtils.isEmpty((Object)request)) {
            return "";
        }
        Object attribute = request.getAttribute(MICRO_CODE);
        if (attribute instanceof String) {
            return (String)attribute;
        }
        return Optional.ofNullable(request.getHeader(MICRO_CODE)).filter(microCode -> !microCode.isEmpty() && !"null".equals(microCode) && !"undefined".equals(microCode)).orElse("");
    }
}

