/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.model.vuecode;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.Pair;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class CommentDirective {
    public static final String VERB_PREFIX = "@";
    private static final Pattern REGEXP_COMMENT_START = Pattern.compile("\\s*#\\s*");
    private static final Pattern REGEXP_FLAG_FIELD = Pattern.compile("--?(?<name>[^=]*)(=(?<value>.*))?");
    private static final char[] ASCII_WHITESPACE_CHARACTERS = new char[]{' ', '\t', '\f', '\r', '\n', '\u000b'};
    private int line = 0;
    private String verb;
    private final Map<String, String> flags;
    private final List<String> arguments;
    private String comment;

    public CommentDirective(String verb) {
        this.verb = verb;
        this.flags = new LinkedHashMap<String, String>();
        this.arguments = new ArrayList<String>();
        this.comment = "";
    }

    private CommentDirective(String verb, Map<String, String> flags, List<String> arguments) {
        this.verb = verb;
        this.flags = flags != null ? flags : new LinkedHashMap();
        this.arguments = arguments != null ? arguments : new ArrayList();
        this.comment = "";
    }

    public static CommentDirective parse(String literal) {
        literal = (literal = literal.trim()).startsWith(VERB_PREFIX) ? literal.substring(VERB_PREFIX.length()) : literal;
        Pair<String> commentPair = CodeSplitUtil.destruct(REGEXP_COMMENT_START, literal);
        literal = commentPair.getLeft();
        String comment = commentPair.getRight();
        List<String> directiveFields = CodeSplitUtil.fieldsOf(literal, 1);
        String verb = directiveFields.get(0);
        LinkedHashMap<String, String> flags = new LinkedHashMap<String, String>();
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 1; i < directiveFields.size(); ++i) {
            String field = directiveFields.get(i);
            Matcher matcher = REGEXP_FLAG_FIELD.matcher(field);
            if (!matcher.matches()) {
                arguments.add(field);
                continue;
            }
            String name = StringUtils.defaultString((String)matcher.group("name"));
            String value = StringUtils.defaultString((String)matcher.group("value"));
            if (name.isEmpty() && value.isEmpty()) {
                arguments.add(field);
                continue;
            }
            flags.put(name, value);
        }
        CommentDirective directive = new CommentDirective(verb, flags, arguments);
        directive.setComment(comment);
        return directive;
    }

    public String represent() {
        if (this.verb == null || CommentDirective.containsWhitespaceOr(this.verb, '#')) {
            throw new IllegalStateException("\u6307\u4ee4\u540d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5305\u542b\u7a7a\u767d\u7b49\u975e\u6cd5\u5b57\u7b26");
        }
        if (this.flags.entrySet().stream().anyMatch(item -> CommentDirective.containsWhitespaceOr((String)item.getKey(), '#', '=') || CommentDirective.containsWhitespaceOr((String)item.getValue(), '#'))) {
            throw new IllegalStateException("\u6307\u4ee4\u9009\u9879\u5305\u542b\u7a7a\u767d\u7b49\u975e\u6cd5\u5b57\u7b26");
        }
        if (this.arguments.stream().anyMatch(item -> CommentDirective.containsWhitespaceOr(item, '#'))) {
            throw new IllegalStateException("\u6307\u4ee4\u53c2\u6570\u5305\u542b\u7a7a\u767d\u7b49\u975e\u6cd5\u5b57\u7b26");
        }
        Stream<String> stream = Stream.concat(Stream.of(VERB_PREFIX + StringUtils.defaultString((String)this.verb)), Stream.concat(this.flags.entrySet().stream().map(item -> (((String)item.getKey()).length() > 1 ? "--" + (String)item.getKey() : "-" + (String)item.getKey()) + (((String)item.getValue()).isEmpty() ? "" : "=" + (String)item.getValue())), this.arguments.stream()));
        if (this.comment != null && !this.comment.isEmpty()) {
            stream = Stream.concat(stream, Stream.of("# " + this.comment));
        }
        return stream.collect(Collectors.joining(" "));
    }

    private static boolean containsWhitespaceOr(String text, char ... chars) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            for (char whitespace : ASCII_WHITESPACE_CHARACTERS) {
                if (ch != whitespace) continue;
                return true;
            }
            for (char item : chars) {
                if (ch != item) continue;
                return true;
            }
        }
        return false;
    }

    public int getFlagCount() {
        return this.flags.size();
    }

    public Set<String> getFlagNames() {
        return this.flags.keySet();
    }

    public String getFlag(String name) {
        return this.flags.get(name);
    }

    public void putFlag(String name, String value) {
        if (name == null) {
            return;
        }
        if (value != null) {
            this.flags.put(name, value);
        } else {
            this.flags.remove(name);
        }
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    public String getArgument(int index) {
        if (index < 0 || index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(index);
    }

    public void putArgument(String value) {
        if (value == null) {
            return;
        }
        this.arguments.add(value);
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

