/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.resource;

import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.file.impl.resource.ResourcePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.stereotype.Service;

@Service(value="ModularizationResourcePath")
public class ModularizationResourcePath
extends ResourcePathServiceImpl {
    private static final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private String modularizationBackPath = formDesignProperties.getModularizationBackPath();

    @Override
    String getBackProjectPath() {
        this.getPrefix();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String userId = BaseSecurityUtil.getUser().getUserId().toString();
        String prefixServer = ToolUtil.isNotEmpty(this.prefix) ? this.prefix + "-server" : "";
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(VfgModeTool.isRemote() ? "" : this.workspace, tenantCode, userId, tenantCode + "-web", this.prefix, prefixServer));
    }

    @Override
    String getWebProjectSetting() {
        this.getPrefix();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.workspace, tenantCode));
    }

    @Override
    public String getNoCodeStoreFullPath() {
        return FileUtil.systemPath(this.getBackProjectPath(), this.prefix, this.noCodeStore);
    }

    @Override
    public ResourcePath projectStore(String ... pathSegments) {
        String localPrefix = this.localProjectStore();
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, "");
    }

    @Override
    public ResourcePath projectStoreCode(String ... pathSegments) {
        String localPrefix = super.getProjectAndCodePath();
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, "");
    }

    @Override
    public SysApplicationVo projectAppName() {
        return null;
    }

    @Override
    public String getProjectAndCodePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.getLocalPath("", this.localProjectStore()), this.projectCodePath));
    }

    @Override
    public String getLocalPath(String pathSegments, String localPrefix) {
        this.getPrefix();
        return FileUtil.systemPath(FileUtil.systemPath(localPrefix, pathSegments).replace(".project-store", FileUtil.posixPath(this.prefix, ".project-store")));
    }

    @Override
    public String getProjectAndComponentsPath() {
        this.getPrefix();
        if (HussarUtils.isNotBlank((CharSequence)this.serverResourcesPath)) {
            return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.serverResourcesPath, this.projectComponentsPath));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectComponentsPath)).replace(".project-store", FileUtil.posixPath(this.prefix, ".project-store"));
    }

    @Override
    public String getComponentIOPath() {
        return FileUtil.posixPath(formDesignProperties.getComponentIOPath(), "component");
    }

    @Override
    public String getWebProjectSettingPath() {
        String webProjectSettingPath = "/setting/webProSetInfo.json";
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.webProjectSetting(), webProjectSettingPath));
    }

    @Override
    public String getProjectAndCustomComponentCoverPath() {
        return VfgModeTool.isRemote() ? ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.projectStore(new String[0]).getLocalPath(), this.projectCustomComponentsPath, this.projectCoverPath)) : super.getProjectAndCustomComponentCoverPath();
    }

    @Override
    public String getProjectAndPageTemplateCoverPath() {
        return VfgModeTool.isRemote() ? ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.projectStore(new String[0]).getLocalPath(), this.projectPageTemplatePath, this.projectCoverPath)) : super.getProjectAndPageTemplateCoverPath();
    }
}

