/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.FileConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCodeDto;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
public class DataFileDataBaseServiceImpl
implements DataFileService {
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;

    @Override
    public Map<String, String> getFileMapping() throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.metaMap("#", map, "#");
        this.metaMap("common_model", map, "common_model");
        return map;
    }

    public void metaMap(String parentId, Map<String, String> map, String parentPath) {
        List<SysMidFileCode> list = this.sysMidFileCodeService.getByPId(parentId);
        ArrayList<SysMidFileCodeDto> sysMidFileCodeDtos = new ArrayList<SysMidFileCodeDto>(list.size());
        for (SysMidFileCode sysMidFileCode : list) {
            SysMidFileCodeDto sysMidFileCodeDto = (SysMidFileCodeDto)((Object)BeanUtil.copyProperties((Object)((Object)sysMidFileCode), SysMidFileCodeDto.class));
            sysMidFileCodeDtos.add(sysMidFileCodeDto);
        }
        for (SysMidFileCodeDto sysMidFileCodeDto : sysMidFileCodeDtos) {
            String path = parentPath + File.separator + sysMidFileCodeDto.getName();
            sysMidFileCodeDto.setPath(path);
            if (HussarUtils.equals((Object)sysMidFileCodeDto.getMetaFlag(), (Object)"1")) {
                String data = sysMidFileCodeDto.getData();
                BaseFile baseFile = (BaseFile)JSONObject.parseObject((String)data, BaseFile.class);
                String id = baseFile.getId();
                String transFileSuffix = FileConstant.transFileSuffix(sysMidFileCodeDto.getType());
                String pathAll = sysMidFileCodeDto.getPath() + transFileSuffix + ".meta";
                if (pathAll.contains("#")) {
                    pathAll = pathAll.replace("#", "");
                }
                if (pathAll.contains("common_model")) {
                    pathAll = File.separator + pathAll;
                }
                map.put(id, pathAll);
            }
            if (!HussarUtils.equals((Object)sysMidFileCodeDto.getType(), (Object)"Module")) continue;
            this.metaMap(sysMidFileCodeDto.getFileId(), map, sysMidFileCodeDto.getPath());
        }
    }

    @Override
    public void fileMappingEvict() {
    }

    @Override
    public Map<String, Map<String, List<String>>> getFileReferMapping() throws LcdpException {
        return null;
    }

    @Override
    public void iteratorFile(File file, Map<String, String> fileMappingMap, File rootFile) throws LcdpException {
        if (FileUtils.exists(file)) {
            if (FileUtils.isDirectory(file)) {
                File[] files = FileUtils.listFiles(file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, fileMappingMap, rootFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                BaseFile baseFile;
                String id = "";
                try {
                    baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString(file, "UTF-8"), BaseFile.class);
                    id = baseFile.getId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
                }
                if (ToolUtil.isNotEmpty(id)) {
                    String relativePath = "common_model".equalsIgnoreCase(baseFile.getParentId()) ? "/common_model" + file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "") : file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                    if (ToolUtil.isNotEmpty(fileMappingMap.get(id))) {
                        throw new LcdpException(LcdpExceptionEnum.SAME_FILE_ID, fileMappingMap.get(id) + "\n" + relativePath);
                    }
                    fileMappingMap.put(id, FileUtil.posixPath(relativePath));
                }
            }
        }
    }
}

