/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.factory;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StyleFactory {
    private static Map<String, String> clazzMap = new HashMap<String, String>(1024);
    private static final Map<String, Map<String, String>> styleExchangeToInnerStyle = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> InnerStyleExchangeToStyle = new HashMap<String, Map<String, String>>();
    private static Map<String, Map<String, Set<String>>> styleRemove = new HashMap<String, Map<String, Set<String>>>(1024);

    private StyleFactory() {
    }

    public static void addComponentClassName(String name, String className) {
        clazzMap.forEach((componentName, clazz) -> {
            if (!HussarUtils.equals((Object)name, (Object)componentName) && HussarUtils.equals((Object)clazz, (Object)className)) {
                System.err.println("\u7ec4\u4ef6:\u3010" + name + "\u3011\u4e0e\u7ec4\u4ef6\u3010" + componentName + "\u3011\u7684\u9ed8\u8ba4className [" + clazz + "] \u91cd\u590d");
            }
        });
        clazzMap.put(name, className);
    }

    public static String get(String name) {
        return clazzMap.get(name);
    }

    public static void addStyleExchangeToInnerStyle(String componentName, String style, String innerStyle) {
        Map<String, String> currentComponentStyleExchangeToInnerStyle = styleExchangeToInnerStyle.get(componentName);
        if (null == currentComponentStyleExchangeToInnerStyle) {
            currentComponentStyleExchangeToInnerStyle = new HashMap<String, String>();
        }
        currentComponentStyleExchangeToInnerStyle.put(style, innerStyle);
        styleExchangeToInnerStyle.put(componentName, currentComponentStyleExchangeToInnerStyle);
    }

    public static Map<String, Map<String, String>> getStyleExchangeToInnerStyle() {
        return styleExchangeToInnerStyle;
    }

    public static void addInnerStyleExchangeToStyle(String componentName, String innerStyle, String style) {
        Map<String, String> currentComponentInnerStyleExchangeToStyle = InnerStyleExchangeToStyle.get(componentName);
        if (null == currentComponentInnerStyleExchangeToStyle) {
            currentComponentInnerStyleExchangeToStyle = new HashMap<String, String>();
        }
        currentComponentInnerStyleExchangeToStyle.put(innerStyle, style);
        InnerStyleExchangeToStyle.put(componentName, currentComponentInnerStyleExchangeToStyle);
    }

    public static Map<String, Map<String, String>> getInnerStyleToStyle() {
        return InnerStyleExchangeToStyle;
    }

    public static void addStyleRemove(String componentName, String styleType, String style) {
        Map<String, Set<String>> currentComponentRemove = styleRemove.get(componentName);
        if (null == currentComponentRemove) {
            currentComponentRemove = new HashMap<String, Set<String>>();
            StyleFactory.dealRemoveSet(styleType, style, currentComponentRemove);
        } else {
            StyleFactory.dealRemoveSet(styleType, style, currentComponentRemove);
        }
        styleRemove.put(componentName, currentComponentRemove);
    }

    private static void dealRemoveSet(String styleType, String style, Map<String, Set<String>> currentComponentRemove) {
        Set<String> removeSet = currentComponentRemove.get(styleType);
        if (null == removeSet) {
            removeSet = new HashSet<String>();
        }
        removeSet.add(style);
        currentComponentRemove.put(styleType, removeSet);
    }

    public static Map<String, Map<String, Set<String>>> getStyleRemove() {
        return styleRemove;
    }
}

