/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.application.service.IHussarApplicationService;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.formdesign.common.constant.VfgModelType;
import com.jxdinfo.hussar.formdesign.common.constant.path.PathEnum;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.AppIdHandler;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfgModeTool {
    private static final Logger logger = LoggerFactory.getLogger(VfgModeTool.class);
    private static final String DEFAULT_APP_ID = "1646777064113700865";

    public static void setAppId(String formId) {
        if (VfgModeTool.checkVfgModel().booleanValue()) {
            AppContextUtil.setAppId(VfgModeTool.appId(formId));
        }
    }

    public static String appId(String formId) {
        String appId = AppContextUtil.getAppId();
        if (ToolUtil.isEmpty(appId)) {
            appId = VfgModeTool.getAppIdByFormId(formId);
        }
        return ToolUtil.isNotEmpty(appId) ? appId : DEFAULT_APP_ID;
    }

    public static String appId() {
        return ToolUtil.isEmpty(AppContextUtil.getAppId()) ? DEFAULT_APP_ID : AppContextUtil.getAppId();
    }

    private static String getAppIdByFormId(String formId) {
        try {
            if (HussarUtils.isNotEmpty((Object)formId)) {
                AppIdHandler appIdHandler = (AppIdHandler)SpringContextHolder.getBean(AppIdHandler.class);
                return appIdHandler.getAppIdByFormId(formId);
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u52a8\u6001\u6a21\u578b\u8868\u67e5\u8be2\u4e0d\u5230appId");
        }
        return null;
    }

    public static Boolean checkVfgModel() {
        FormDesignProperties formDesignProperties = SpringUtil.getBean(FormDesignProperties.class);
        return VfgModelType.NO_PLUS_LOW.name().equals(formDesignProperties.getVfgModel());
    }

    public static boolean isModularization() {
        String sceneType = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).scene();
        return sceneType.equals(PathEnum.MODULARIZATION.getScene());
    }

    public static boolean isRemote() {
        String fileManipulationPatterns = ((FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class)).getFileManipulationPatterns();
        return fileManipulationPatterns.equals("REMOTE");
    }

    public static void pushToRemote(String commitMsg, List<String> filesToAdd) {
        if (VfgModeTool.isRemote()) {
            // empty if block
        }
    }

    public static void pushToRemoteImmediately(String commitMsg, List<String> filesToAdd) {
        if (VfgModeTool.isRemote()) {
            IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
            gitlabService.pushVfgCode(commitMsg, filesToAdd, System.getProperty("user.dir"));
        }
    }

    public static ApiResponse<Boolean> isActive() {
        String mobilePort;
        if (!VfgModeTool.isRemote()) {
            return ApiResponse.success((Object)true);
        }
        IUserEnvPortService userEnvPortService = (IUserEnvPortService)SpringContextHolder.getBean(IUserEnvPortService.class);
        Map userEnvPort = userEnvPortService.getUserEnvPortByUserId(BaseSecurityUtil.getUser().getUserId());
        if (ObjectUtils.isEmpty((Object)userEnvPort)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u7aef\u53e3\u5931\u8d25");
        }
        String backPort = ObjectUtils.isEmpty(userEnvPort.get("backPort")) ? "" : String.valueOf(userEnvPort.get("backPort"));
        String frontPort = ObjectUtils.isEmpty(userEnvPort.get("frontPort")) ? "" : String.valueOf(userEnvPort.get("frontPort"));
        String string = mobilePort = ObjectUtils.isEmpty(userEnvPort.get("mobilePort")) ? "" : String.valueOf(userEnvPort.get("mobilePort"));
        if (ObjectUtils.isEmpty((Object)backPort) || ObjectUtils.isEmpty((Object)frontPort) || ObjectUtils.isEmpty((Object)mobilePort)) {
            return ApiResponse.fail((String)"\u83b7\u53d6\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u7aef\u53e3\u5931\u8d25");
        }
        ToolUtil.getLogger(VfgModeTool.class).info("\u540e\u7aef\u7aef\u53e3\uff1a{}\uff0c\u524d\u7aef\u7aef\u53e3\uff1a{}, \u79fb\u52a8\u7aef\u7aef\u53e3: {}", new Object[]{backPort, frontPort, mobilePort});
        IHussarDeployService hussarDeployService = (IHussarDeployService)SpringContextHolder.getBean(IHussarDeployService.class);
        return hussarDeployService.getEnvStatus(Integer.valueOf(frontPort), Integer.valueOf(backPort), Integer.valueOf(mobilePort));
    }

    public static Port envPort() {
        Map userEnvPort = ((IUserEnvPortService)SpringContextHolder.getBean(IUserEnvPortService.class)).getUserEnvPortByUserId(BaseSecurityUtil.getUser().getUserId());
        if (ObjectUtils.isEmpty((Object)userEnvPort)) {
            return new Port("", "", "");
        }
        String backPort = ObjectUtils.isEmpty(userEnvPort.get("backPort")) ? "" : String.valueOf(userEnvPort.get("backPort"));
        String frontPort = ObjectUtils.isEmpty(userEnvPort.get("frontPort")) ? "" : String.valueOf(userEnvPort.get("frontPort"));
        String mobilePort = ObjectUtils.isEmpty(userEnvPort.get("mobilePort")) ? "" : String.valueOf(userEnvPort.get("mobilePort"));
        return new Port(backPort, frontPort, mobilePort);
    }

    public static boolean start(boolean startAuto, String sourceId, String stage, String process, String errorMsg, String status) {
        boolean isStartAuto = false;
        if (VfgModeTool.isModularization() && HussarUtils.isNotEmpty((Object)startAuto)) {
            Boolean isActive = (Boolean)VfgModeTool.isActive().getData();
            if (!startAuto && !isActive.booleanValue()) {
                startAuto = true;
                String appCode = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
                PublishLogUtil.Log log = new PublishLogUtil.Log(sourceId, appCode, stage, process, errorMsg, status, "", "", "");
                PublishLogUtil.writePublishLog((PublishLogUtil.Log)log);
                IHussarDeployService hussarDeployService = (IHussarDeployService)SpringContextHolder.getBean(IHussarDeployService.class);
                IHussarApplicationService hussarApplicationService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
                SecurityUser user = BaseSecurityUtil.getUser();
                Port port = VfgModeTool.envPort();
                hussarDeployService.start(user.getTenantCode(), user.getUserId(), port.getBackPort(), port.getFrontPort(), port.getMobilePort(), hussarApplicationService.getAppCodes(user.getUserId()));
            }
        }
        return isStartAuto;
    }

    public static boolean startAutoNotActive(boolean startAuto, String sourceId, String stage, String process, String errorMsg, String status) {
        boolean startAutoNotActive = false;
        if (VfgModeTool.isModularization() && HussarUtils.isNotEmpty((Object)startAuto)) {
            Boolean isActive = (Boolean)VfgModeTool.isActive().getData();
            boolean bl = startAutoNotActive = startAuto && isActive == false;
            if (startAutoNotActive) {
                String appCode = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
                PublishLogUtil.Log log = new PublishLogUtil.Log(sourceId, appCode, stage, process, errorMsg, status, "", "", "");
                PublishLogUtil.writePublishLog((PublishLogUtil.Log)log);
            }
        }
        return startAutoNotActive;
    }

    public static class Port {
        private String backPort;
        private String frontPort;
        private String mobilePort;

        public Port(String backPort, String frontPort, String mobilePort) {
            this.backPort = backPort;
            this.frontPort = frontPort;
            this.mobilePort = mobilePort;
        }

        public String getBackPort() {
            return this.backPort;
        }

        public void setBackPort(String backPort) {
            this.backPort = backPort;
        }

        public String getFrontPort() {
            return this.frontPort;
        }

        public void setFrontPort(String frontPort) {
            this.frontPort = frontPort;
        }

        public String getMobilePort() {
            return this.mobilePort;
        }

        public void setMobilePort(String mobilePort) {
            this.mobilePort = mobilePort;
        }
    }
}

