/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.runner;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.runner.ConfigureCenterEnum;
import com.jxdinfo.hussar.formdesign.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.hussar.formdesign.common.runner.validation.JavaValidationType;
import com.jxdinfo.hussar.formdesign.common.runner.validation.JsValidationType;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/configure/center"})
public class ConfigureCenter {
    @Resource
    private IHussarThemeConfigService themeConfigService;

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public FormDesignResponse<Map<String, Object>> getAllConfigureInfo() {
        FormDesignResponse<Map<String, Object>> formDesignResponse = new FormDesignResponse<Map<String, Object>>();
        HashMap<String, Object> allInfoMap = new HashMap<String, Object>(10);
        allInfoMap.put(ConfigureCenterEnum.FORM_CHECK.getType(), FormCheckInfo.formCheck);
        allInfoMap.put(ConfigureCenterEnum.JAVA_VALIDATION.getType(), JavaValidationType.javaValidation);
        allInfoMap.put(ConfigureCenterEnum.JS_VALIDATION.getType(), JsValidationType.jsValidation);
        allInfoMap.put(ConfigureCenterEnum.THEME_CONFIG_ROLE.getType(), this.themeConfigService.getThemeConfigRole().getData());
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
        String storageType = formDesignProperties.getScenes().isDataBase() ? "DATABASE" : "PROJECTSTORE";
        allInfoMap.put(ConfigureCenterEnum.STORAGE_TYPE.getType(), storageType);
        formDesignResponse.setData(allInfoMap);
        return formDesignResponse;
    }
}

