/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.constant;

public enum SpecialCharactersEnum {
    LEFT_PARENTHESIS("(", "\\("),
    RIGHT_PARENTHEIS(")", "\\)"),
    LEFT_BRACKET("[", "\\["),
    RIGHT_BRACKET("]", "\\]"),
    LEFT_CURLY_BRACKET("{", "\\{"),
    RIGHT_CURLY_PBRACKET("}", "\\}"),
    PLUS_SIGN("+", "\\+"),
    MINUS_SIGN("-", "\\-"),
    MULTIPLICATION_SIGN("*", "\\*"),
    DIVISION_SIGN("/", "\\/"),
    POWER_SIGN("^", "\\^"),
    FACTORIAL_SIGN("\u00a6", "\\\u00a6"),
    FULL_STOP(".", "\\."),
    QUESTION_MARK("?", "\\?"),
    DOLLAR("$", "\\$");

    private final String unEscapedStr;
    private final String escapedStr;

    private SpecialCharactersEnum(String unEscapedStr, String escapedStr) {
        this.unEscapedStr = unEscapedStr;
        this.escapedStr = escapedStr;
    }

    public String getUnEscapedStr() {
        return this.unEscapedStr;
    }

    public String getEscapedStr() {
        return this.escapedStr;
    }

    public static String escapeAll(String string) {
        for (SpecialCharactersEnum specialCharactersEnum : SpecialCharactersEnum.values()) {
            string = string.replace(specialCharactersEnum.getUnEscapedStr(), specialCharactersEnum.getEscapedStr());
        }
        return string;
    }
}

