/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CodeSplitUtil {
    private static final Pattern REGEXP_LINE_SEPARATOR = Pattern.compile("\\n|\\r\\n?", 8);
    private static final Pattern REGEXP_WHITESPACES = Pattern.compile("\\s+");
    public static final int DEFAULT_TAB_LENGTH = 4;

    public static List<String> linesOf(String source) {
        if (source == null || source.isEmpty()) {
            return new ArrayList<String>();
        }
        int last = 0;
        ArrayList<String> lines = new ArrayList<String>();
        Matcher matcher = REGEXP_LINE_SEPARATOR.matcher(source);
        while (matcher.find()) {
            lines.add(source.substring(last, matcher.end()));
            last = matcher.end();
        }
        if (last != source.length()) {
            lines.add(source.substring(last));
        }
        return lines;
    }

    public static List<String> fieldsOf(String line) {
        return CodeSplitUtil.fieldsOf(line, 0);
    }

    public static List<String> fieldsOf(String line, int min) {
        ArrayList<String> result;
        ArrayList<String> arrayList = result = min > 0 ? new ArrayList<String>(min) : new ArrayList();
        if (line == null) {
            if (min > 0) {
                for (int i = 0; i < min; ++i) {
                    result.add("");
                }
            }
            return result;
        }
        String[] fields = REGEXP_WHITESPACES.split(line);
        result.addAll(Arrays.asList(fields));
        if (min > 0) {
            for (int i = fields.length; i < min; ++i) {
                result.add("");
            }
        }
        return result;
    }

    public static Pair<String> fieldsDestruct(String line) {
        return CodeSplitUtil.destruct(REGEXP_WHITESPACES, line);
    }

    public static Pair<String> destruct(Pattern separator, String literal) {
        if (literal == null) {
            return Pair.of("", "");
        }
        String[] fields = separator.split(literal, 2);
        if (fields.length > 1) {
            return Pair.of(fields[0], fields[1]);
        }
        if (fields.length > 0) {
            return Pair.of(fields[0], "");
        }
        return Pair.of("", "");
    }

    public static String indentOf(String source) {
        return CodeSplitUtil.indentOf(source, 4);
    }

    public static String indentOf(String source, Predicate<String> ignoreLine) {
        return CodeSplitUtil.indentOf(source, 4, ignoreLine);
    }

    public static String indentOf(String source, int tabLength) {
        return CodeSplitUtil.indentOf(source, tabLength, null);
    }

    public static String indentOf(String source, int tabLength, Predicate<String> ignoreLine) {
        if (source == null) {
            source = "";
        }
        Predicate<String> ignorePredicate = ignoreLine != null ? ignoreLine : StringUtils::isBlank;
        int level = CodeSplitUtil.linesOf(source).stream().filter(line -> !ignorePredicate.test((String)line)).mapToInt(line -> CodeSplitUtil.calculateLineIndentLevel(line, tabLength)).min().orElse(0);
        return StringUtils.repeat((char)' ', (int)level);
    }

    private static int calculateLineIndentLevel(String line, int tabLength) {
        int length = 0;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == ' ') {
                ++length;
                continue;
            }
            if (ch == '\t') {
                length += tabLength;
                continue;
            }
            return length;
        }
        return 0;
    }

    public static String stripIndent(String line) {
        int i;
        if (line == null || line.isEmpty()) {
            return line;
        }
        for (i = 0; i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t'); ++i) {
        }
        return line.substring(i);
    }

    public static String removeEmptyLines(String source) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        return CodeSplitUtil.linesOf(source).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining());
    }

    public static String setEndOnlyLine(String source) {
        if (source.endsWith("\r\n")) {
            String content = CodeSplitUtil.setEndOnlyLine(source.substring(0, source.length() - 2));
            return content.replaceAll("\\r\\n?|\\n", System.lineSeparator());
        }
        if (source.endsWith("\n")) {
            String content = CodeSplitUtil.setEndOnlyLine(source.substring(0, source.length() - 1));
            return content.replaceAll("\\r\\n?|\\n", System.lineSeparator());
        }
        String content = source + System.lineSeparator();
        return content.replaceAll("\\r\\n?|\\n", System.lineSeparator());
    }
}

