/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.helger.css.ECSSVersion;
import com.helger.css.ICSSWriteable;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VueCssSorterUtil {
    public static final List<String> TOP_CSS_KEY = Arrays.asList(".lcdp_axe_main", ".el-tooltip__popper");
    public static final List<String> END_CSS_KEY = Arrays.asList(".twinkle", "@-webkit-keyframes twinkle", "@keyframes twinkle");
    public static final String STYLE_REGEX = "<style[^>]*>(.*?)</style>";
    public static final String COMMENT_BLOCK_REGEX = "(<!--\\s*@begin\\s+.*?-->.*?<!--\\s*@end\\s+.*?-->)";

    public static String sortVueCss(String content) {
        ArrayList<String> styles = new ArrayList<String>();
        ArrayList<String> styleBlocks = new ArrayList<String>();
        ArrayList<String> modifiedStyles = new ArrayList<String>();
        ArrayList<Boolean> skipSort = new ArrayList<Boolean>();
        VueCssSorterUtil.initStyleList(content, styles, modifiedStyles, styleBlocks, skipSort);
        if (HussarUtils.isNotEmpty(styles)) {
            for (int i = 0; i < styles.size(); ++i) {
                if (Boolean.TRUE.equals(skipSort.get(i))) {
                    modifiedStyles.set(i, (String)styles.get(i));
                    continue;
                }
                String sortedInner = VueCssSorterUtil.sortCssBlock((String)modifiedStyles.get(i));
                modifiedStyles.set(i, ((String)styles.get(i)).replace((CharSequence)modifiedStyles.get(i), sortedInner));
            }
        }
        return VueCssSorterUtil.buildContent(styles, modifiedStyles, styleBlocks);
    }

    private static String buildContent(List<String> styles, List<String> modifiedStyles, List<String> styleBlocks) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < styleBlocks.size(); ++i) {
            result.append(styleBlocks.get(i));
            if (i < modifiedStyles.size()) {
                result.append(modifiedStyles.get(i));
                continue;
            }
            if (i >= styles.size()) continue;
            result.append(styles.get(i));
        }
        return result.toString();
    }

    private static void initStyleList(String content, List<String> styles, List<String> modifiedStyles, List<String> styleBlocks, List<Boolean> skipSort) {
        Pattern commentPattern = Pattern.compile(COMMENT_BLOCK_REGEX, 32);
        Matcher commentMatcher = commentPattern.matcher(content);
        ArrayList<int[]> preservedRanges = new ArrayList<int[]>();
        while (commentMatcher.find()) {
            preservedRanges.add(new int[]{commentMatcher.start(1), commentMatcher.end(1)});
        }
        Pattern stylePattern = Pattern.compile(STYLE_REGEX, 32);
        Matcher styleMatcher = stylePattern.matcher(content);
        int lastEnd = 0;
        while (styleMatcher.find()) {
            styleBlocks.add(content.substring(lastEnd, styleMatcher.start()));
            styles.add(styleMatcher.group(0));
            modifiedStyles.add(styleMatcher.group(1));
            boolean insidePreserved = false;
            for (int[] range : preservedRanges) {
                if (styleMatcher.start() < range[0] || styleMatcher.end() > range[1]) continue;
                insidePreserved = true;
                break;
            }
            skipSort.add(insidePreserved);
            lastEnd = styleMatcher.end();
        }
        styleBlocks.add(content.substring(lastEnd));
    }

    private static String sortCssBlock(String cssContent) {
        CascadingStyleSheet styleSheet = CSSReader.readFromString((String)(cssContent = cssContent.replace("/deep/", "v-deep-placeholder")), (ECSSVersion)ECSSVersion.LATEST);
        if (HussarUtils.isEmpty((Object)styleSheet)) {
            return cssContent.replace("v-deep-placeholder", "/deep/");
        }
        ArrayList<CSSStyleRule> sortableRules = new ArrayList<CSSStyleRule>();
        ArrayList<CSSStyleRule> topLevelTop = new ArrayList<CSSStyleRule>();
        ArrayList<Object> topLevelEnd = new ArrayList<Object>();
        ArrayList<ICSSTopLevelRule> topLevelOthers = new ArrayList<ICSSTopLevelRule>();
        HashMap<String, Integer> selectorOrderMap = new HashMap<String, Integer>();
        int orderIndex = 0;
        CSSWriter writer = new CSSWriter();
        for (ICSSTopLevelRule rule : styleSheet.getAllRules()) {
            if (rule instanceof CSSStyleRule) {
                CSSStyleRule styleRule = (CSSStyleRule)rule;
                String selector = VueCssSorterUtil.getSelectorString(styleRule);
                String trimmed = selector.trim();
                if (TOP_CSS_KEY.contains(trimmed)) {
                    topLevelTop.add(styleRule);
                    continue;
                }
                if (END_CSS_KEY.contains(trimmed)) {
                    topLevelEnd.add(styleRule);
                    continue;
                }
                if (!selectorOrderMap.containsKey(selector)) {
                    selectorOrderMap.put(selector, orderIndex++);
                }
                sortableRules.add(styleRule);
                continue;
            }
            String s = writer.getCSSAsString((ICSSWriteable)rule);
            boolean isEnd = false;
            for (String k : END_CSS_KEY) {
                if (!s.startsWith(k)) continue;
                isEnd = true;
                break;
            }
            if (isEnd) {
                topLevelEnd.add(rule);
                continue;
            }
            topLevelOthers.add(rule);
        }
        VueCssSorterUtil.sortRules(sortableRules, selectorOrderMap);
        ArrayList<Object> combined = new ArrayList<Object>();
        combined.addAll(topLevelTop);
        combined.addAll(sortableRules);
        combined.addAll(topLevelOthers);
        combined.addAll(topLevelEnd);
        return VueCssSorterUtil.generatorCss(combined);
    }

    private static String generatorCss(List<? extends ICSSTopLevelRule> rules) {
        CSSWriter writer = new CSSWriter();
        StringBuilder sortedCss = new StringBuilder();
        if (HussarUtils.isNotEmpty(rules)) {
            for (ICSSTopLevelRule iCSSTopLevelRule : rules) {
                sortedCss.append(writer.getCSSAsString((ICSSWriteable)iCSSTopLevelRule)).append("\n");
            }
        }
        return sortedCss.toString().trim().replace("v-deep-placeholder", "/deep/");
    }

    private static void sortRules(List<CSSStyleRule> rules, Map<String, Integer> selectorOrderMap) {
        rules.sort((r1, r2) -> {
            String selector2;
            String selector1 = VueCssSorterUtil.getSelectorString(r1);
            int cmp = selector1.compareToIgnoreCase(selector2 = VueCssSorterUtil.getSelectorString(r2));
            return cmp != 0 ? cmp : Integer.compare((Integer)selectorOrderMap.get(selector1), (Integer)selectorOrderMap.get(selector2));
        });
    }

    private static String getSelectorString(CSSStyleRule rule) {
        if (HussarUtils.isEmpty((Object)rule) || HussarUtils.isEmpty((Object)rule.getAllSelectors())) {
            return "";
        }
        return rule.getAllSelectors().stream().map(ICSSWriteable::getAsCSSString).collect(Collectors.joining(" "));
    }
}

