/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.properties;

import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar-formdesign")
public class FormDesignProperties {
    public static final String PREFIX = "hussar-formdesign";
    public static final String views = "views";
    public static final String pages = "pages";
    private boolean newMergeOpen = true;
    private boolean checkedCode = false;
    private boolean localCodeFormatter = true;
    private boolean localCodeFormatCss = true;
    private boolean upgradeConfig = true;
    private boolean methodLine = false;
    private String api = "api";
    private FormDesignScenes scenes = FormDesignScenes.OFFLINE;
    private FormDesignScenes noCodeScenes = FormDesignScenes.NO_CODE_OFFLINE;
    private boolean lockEnabled = true;
    private boolean format = true;
    private boolean syncMenu = true;
    private boolean multiSource = false;
    private String deploymentMode = "";
    private String projectRootPath = "/.project-store";
    private String noCodeStore = "/.noCode-store";
    private String backProjectPath = "hussar-web";
    private String javaCodePath = "/src/main/java";
    private String modularizationBackPath = "";
    private String modularizationFrontPath = "";
    private String frontProjectPath = "hussar-front";
    private String mobileFrontProjectPath = "hussar-mobile";
    private String pageSuffix = ".vue";
    private String jsSuffix = ".js";
    private String vueCodePath = "/src/pages/index";
    private String mobileExtendScriptPath = "/src";
    private String extendScriptPath = "/extend";
    private String extendJavaScriptPath = "/javascript";
    private String extendVuePath = "/vue";
    private String extendCssScriptPath = "/css";
    private String mobileVueCodePath = "/src/views";
    private String mobileVueJsCodePath = "/src/pages";
    private String mobileVueRouterPath = "/src/router";
    private String commonStylePath = "/src/assets/css";
    private String defaultStyleFileName = "/default_value.css";
    private String cssCodePath = "/src/assets/css";
    private String projectCodePath = "/code";
    private String projectCustomComponentsPath = "/customComponents";
    private String serverResourcesPath = "";
    private String projectComponentsPath = "/components";
    private String projectCoverPath = "/cover";
    private String projectPageTemplatePath = "/PageTemplate";
    private String printTemplatePath = "/PrintTemplate";
    private String datasourceStorePath = "/datasource/db.json";
    private String datasourceTypeStorePath = "/datasource/dataSourceType.json";
    private String javaPath = "/com/jxdinfo/hussar/example";
    private String staticPath = "/static/speedcode";
    private String frontApiPath = "/src/pages/index";
    private String mobileFrontApiPath = "/src/api";
    private String workflowListenerPath = "/bpm/listener";
    private String workflowPath = "/bpm/workflow";
    private String styleSchemeSpace = "/style-scheme";
    private String webUrl = "http://localhost:8081";
    private String mobileUrl = "http://localhost:8380";
    private String mobileIp = "http://localhost";
    private String frontCompilePath = "c:/tmp/hussar-compile";
    private String frontCompileHtmlPath = "/src/pages/index/index.html";
    private String mobileCompilePath = "c:/tmp/hussar-compile";
    private String mobileCompileServer = "http://localhost:8989/buildEntry";
    private String codeFormatAddress = "http://localhost:8820/codeFormat";
    private String mobileCompileHtmlPath = "/public/index.html";
    private String frontCompileServer = "http://localhost:8989/buildEntry";
    private String workspace = "c:/";
    private Long expiryDate;
    private boolean sortImport = true;
    private boolean developerMode = false;
    private boolean localUnReset = false;
    private boolean localUnResetNoCompile = false;
    private boolean offlineLr = false;
    private String modules = "modules";
    private String vfgModel = "NO_CODE";
    private String eaiPlatFromUrl = "";
    private String eaiPlatFromClientId = "";
    private String eaiPlatFromClientSecret = "";
    private boolean enableSwaggerRender = false;
    private String fileManipulationPatterns = "LOCAL";
    private String componentIOPath = "";
    private String javaCompile = "";
    private String envServeName = "hussar-tlExample";
    private List<String> mode = new ArrayList<String>(Arrays.asList("web", "mobile"));
    private String restart = "false";

    public String getViews() {
        return views;
    }

    public String getPages() {
        return pages;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public boolean isLockEnabled() {
        return this.lockEnabled;
    }

    public void setLockEnabled(boolean lockEnabled) {
        this.lockEnabled = lockEnabled;
    }

    public void setVfgModel(String vfgModel) {
        this.vfgModel = vfgModel;
    }

    public String getVfgModel() {
        return this.vfgModel;
    }

    public boolean isEnableSwaggerRender() {
        return this.enableSwaggerRender;
    }

    public void setEnableSwaggerRender(boolean enableSwaggerRender) {
        this.enableSwaggerRender = enableSwaggerRender;
    }

    public String getComponentIOPath() {
        return this.componentIOPath;
    }

    public void setComponentIOPath(String componentIOPath) {
        this.componentIOPath = componentIOPath;
    }

    public String getMobileVueJsCodePath() {
        return this.mobileVueJsCodePath;
    }

    public void setMobileVueJsCodePath(String mobileVueJsCodePath) {
        this.mobileVueJsCodePath = mobileVueJsCodePath;
    }

    public String getMobileVueRouterPath() {
        return this.mobileVueRouterPath;
    }

    public void setMobileVueRouterPath(String mobileVueRouterPath) {
        this.mobileVueRouterPath = mobileVueRouterPath;
    }

    public String getServerResourcesPath() {
        return this.serverResourcesPath;
    }

    public void setServerResourcesPath(String serverResourcesPath) {
        this.serverResourcesPath = serverResourcesPath;
    }

    public String getProjectComponentsPath() {
        return this.projectComponentsPath;
    }

    public void setProjectComponentsPath(String projectComponentsPath) {
        this.projectComponentsPath = projectComponentsPath;
    }

    public String getProjectPageTemplatePath() {
        return this.projectPageTemplatePath;
    }

    public void setProjectPageTemplatePath(String projectPageTemplatePath) {
        this.projectPageTemplatePath = projectPageTemplatePath;
    }

    public String getPrintTemplatePath() {
        return this.printTemplatePath;
    }

    public void setPrintTemplatePath(String printTemplatePath) {
        this.printTemplatePath = printTemplatePath;
    }

    public String getProjectCoverPath() {
        return this.projectCoverPath;
    }

    public void setProjectCoverPath(String projectCoverPath) {
        this.projectCoverPath = projectCoverPath;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getModularizationBackPath() {
        return this.modularizationBackPath;
    }

    public void setModularizationBackPath(String modularizationBackPath) {
        this.modularizationBackPath = modularizationBackPath;
    }

    public String getModularizationFrontPath() {
        return this.modularizationFrontPath;
    }

    public void setModularizationFrontPath(String modularizationFrontPath) {
        this.modularizationFrontPath = modularizationFrontPath;
    }

    public boolean isOfflineLr() {
        return this.offlineLr;
    }

    public void setOfflineLr(boolean offlineLr) {
        this.offlineLr = offlineLr;
    }

    public boolean isSortImport() {
        return this.sortImport;
    }

    public void setSortImport(boolean sortImport) {
        this.sortImport = sortImport;
    }

    public boolean isLocalUnReset() {
        return this.localUnReset;
    }

    public void setLocalUnReset(boolean localUnReset) {
        this.localUnReset = localUnReset;
    }

    public String getExtendJavaScriptPath() {
        return this.extendJavaScriptPath;
    }

    public void setExtendJavaScriptPath(String extendJavaScriptPath) {
        this.extendJavaScriptPath = extendJavaScriptPath;
    }

    public String getExtendVuePath() {
        return this.extendVuePath;
    }

    public void setExtendVuePath(String extendVuePath) {
        this.extendVuePath = extendVuePath;
    }

    public String getExtendCssScriptPath() {
        return this.extendCssScriptPath;
    }

    public void setExtendCssScriptPath(String extendCssScriptPath) {
        this.extendCssScriptPath = extendCssScriptPath;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        if (!workspace.isEmpty() && workspace.length() > 0 && !workspace.endsWith(File.separator)) {
            workspace = workspace + File.separator;
        }
        if (HussarUtils.equals((Object)this.fileManipulationPatterns, (Object)"LOCAL") && !new File(workspace).exists() && HussarUtils.isNotEmpty((Object)workspace)) {
            workspace = System.getProperty("user.dir") + File.separator;
        }
        this.workspace = workspace;
    }

    public FormDesignScenes getScenes() {
        return this.scenes;
    }

    public Long getExpiryDate() {
        if (HussarUtils.isEmpty((Object)this.expiryDate)) {
            return 60L;
        }
        return this.expiryDate;
    }

    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = HussarUtils.isEmpty((Object)expiryDate) ? Long.valueOf(60L) : (expiryDate <= 30L ? Long.valueOf(30L) : (expiryDate > 600L ? Long.valueOf(600L) : expiryDate));
    }

    public void setScenes(String scenes) {
        try {
            if (ToolUtil.isNotEmpty(scenes)) {
                this.scenes = FormDesignScenes.valueOf(scenes.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println("\u573a\u666f\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u9ed8\u8ba4\u4f7f\u7528 OFFLINE \u573a\u666f\uff1a" + scenes);
        }
    }

    public FormDesignScenes getNoCodeScenes() {
        return this.noCodeScenes;
    }

    public void setNoCodeScenes(String noCodeScenes) {
        try {
            if (ToolUtil.isNotEmpty(noCodeScenes)) {
                this.noCodeScenes = FormDesignScenes.valueOf(noCodeScenes.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println("\u573a\u666f\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u9ed8\u8ba4\u4f7f\u7528 OFFLINE \u573a\u666f\uff1a" + noCodeScenes);
        }
    }

    public String getRestart() {
        return this.restart;
    }

    public void setRestart(String restart) {
        this.restart = restart;
    }

    public String getProjectPath() {
        return this.getBackProjectPath();
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public void setProjectRootPath(String projectRootPath) {
        this.projectRootPath = projectRootPath;
    }

    public void setNoCodeStore(String noCodeStore) {
        this.noCodeStore = noCodeStore;
    }

    public String getBackProjectPath() {
        return this.backProjectPath;
    }

    public void setBackProjectPath(String backProjectPath) {
        this.backProjectPath = backProjectPath;
    }

    public String getFrontProjectPath() {
        return this.frontProjectPath;
    }

    public void setFrontProjectPath(String frontProjectPath) {
        this.frontProjectPath = frontProjectPath;
    }

    public String getMobProjectPath() {
        return this.mobileFrontProjectPath;
    }

    public String getMobileFrontProjectPath() {
        return this.mobileFrontProjectPath;
    }

    public void setMobileFrontProjectPath(String mobileFrontProjectPath) {
        this.mobileFrontProjectPath = mobileFrontProjectPath;
    }

    public String getDefaultStyleFileName() {
        return this.defaultStyleFileName;
    }

    public void setDefaultStyleFileName(String defaultStyleFileName) {
        this.defaultStyleFileName = defaultStyleFileName;
    }

    public String getStaticPath() {
        return this.staticPath;
    }

    public void setStaticPath(String staticPath) {
        this.staticPath = staticPath;
    }

    public String getJavaCodePath() {
        return ToolUtil.pathFomatterByOS(this.javaCodePath);
    }

    public void setJavaCodePath(String javaCodePath) {
        this.javaCodePath = javaCodePath;
    }

    public String getVueCodePath() {
        return this.vueCodePath;
    }

    public void setVueCodePath(String vueCodePath) {
        this.vueCodePath = vueCodePath;
    }

    public String getExtendScriptPath() {
        return ToolUtil.pathFomatterByOS(this.extendScriptPath);
    }

    public String getMobileExtendScriptPath() {
        return ToolUtil.pathFomatterByOS(this.mobileExtendScriptPath);
    }

    public void setExtendScriptPath(String extendScriptPath) {
        this.extendScriptPath = extendScriptPath;
    }

    public String getMobileVueCodePath() {
        return this.mobileVueCodePath;
    }

    public String getMobileVueCodePath(Integer strategy) {
        if (null != strategy) {
            return ToolUtil.pathFomatterByOS(FileUtil.systemPath("src", AppContextUtil.posixFilePathPrefix(), pages));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath("src", AppContextUtil.posixFilePathPrefix(), views));
    }

    public void setMobileVueCodePath(String mobileVueCodePath) {
        this.mobileVueCodePath = mobileVueCodePath;
    }

    public String getCssCodePath() {
        return ToolUtil.pathFomatterByOS(this.cssCodePath);
    }

    public void setCssCodePath(String cssCodePath) {
        this.cssCodePath = cssCodePath;
    }

    public String getProjectCodePath() {
        return ToolUtil.pathFomatterByOS(this.projectCodePath);
    }

    public void setProjectCodePath(String projectCodePath) {
        this.projectCodePath = projectCodePath;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getFrontApiPath() {
        return this.frontApiPath;
    }

    public void setFrontApiPath(String frontApiPath) {
        this.frontApiPath = frontApiPath;
    }

    public String getMobileFrontApiPath() {
        return this.mobileFrontApiPath;
    }

    public void setMobileFrontApiPath(String mobileFrontApiPath) {
        this.mobileFrontApiPath = mobileFrontApiPath;
    }

    public String getPageSuffix() {
        return this.pageSuffix;
    }

    public void setPageSuffix(String pageSuffix) {
        this.pageSuffix = pageSuffix;
    }

    public String getJsSuffix() {
        return this.jsSuffix;
    }

    public void setJsSuffix(String jsSuffix) {
        this.jsSuffix = jsSuffix;
    }

    public String getWorkflowListenerPath() {
        return ToolUtil.pathFomatterByOS(this.workflowListenerPath);
    }

    public void setWorkflowListenerPath(String workflowListenerPath) {
        this.workflowListenerPath = workflowListenerPath;
    }

    public String getWorkflowPath() {
        return ToolUtil.pathFomatterByOS(this.workflowPath);
    }

    public void setWorkflowPath(String workflowPath) {
        this.workflowPath = workflowPath;
    }

    public String getNoCodeStore() {
        return this.noCodeStore;
    }

    public String getProjectAndCustomComponentsPath() {
        return this.projectCustomComponentsPath;
    }

    public String getDatasourceStorePath() {
        return this.datasourceStorePath;
    }

    public void setDatasourceStorePath(String datasourceStorePath) {
        this.datasourceStorePath = datasourceStorePath;
    }

    public String getDatasourceTypeStorePath() {
        return this.datasourceTypeStorePath;
    }

    public void setDatasourceTypeStorePath(String datasourceTypeStorePath) {
        this.datasourceTypeStorePath = datasourceTypeStorePath;
    }

    public String getCommonStylePath() {
        return ToolUtil.pathFomatterByOS(this.commonStylePath);
    }

    public void setCommonStylePath(String commonStylePath) {
        this.commonStylePath = commonStylePath;
    }

    public void setStyleSchemeSpace(String styleSchemeSpace) {
        this.styleSchemeSpace = styleSchemeSpace;
    }

    public String getStyleSchemeSpace() {
        return this.styleSchemeSpace;
    }

    public List<String> getMode() {
        return this.mode;
    }

    public void setMode(List<String> mode) {
        this.mode = mode;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webIPPort) {
        this.webUrl = webIPPort;
    }

    public String getMobileUrl() {
        return this.mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getMobileIp() {
        return this.mobileIp;
    }

    public void setMobileIp(String mobileIp) {
        this.mobileIp = mobileIp;
    }

    public boolean isCertainMode(String modeStr) {
        if (ToolUtil.isNotEmpty(this.mode)) {
            for (String mode : this.mode) {
                if (!mode.equals(modeStr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public boolean isMultiSource() {
        return this.multiSource;
    }

    public void setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public boolean isSyncMenu() {
        return this.syncMenu;
    }

    public void setSyncMenu(boolean syncMenu) {
        this.syncMenu = syncMenu;
    }

    public String getFrontCompilePath() {
        return this.frontCompilePath;
    }

    public void setFrontCompilePath(String frontCompilePath) {
        this.frontCompilePath = frontCompilePath;
    }

    public String getFrontCompileHtmlPath() {
        return this.frontCompileHtmlPath;
    }

    public void setFrontCompileHtmlPath(String frontCompileHtmlPath) {
        this.frontCompileHtmlPath = frontCompileHtmlPath;
    }

    public String getFrontCompileServer() {
        return this.frontCompileServer;
    }

    public void setFrontCompileServer(String frontCompileServer) {
        this.frontCompileServer = frontCompileServer;
    }

    public String getMobileCompileHtmlPath() {
        return this.mobileCompileHtmlPath;
    }

    public void setMobileCompileHtmlPath(String mobileCompileHtmlPath) {
        this.mobileCompileHtmlPath = mobileCompileHtmlPath;
    }

    public String getMobileCompilePath() {
        return this.mobileCompilePath;
    }

    public void setMobileCompilePath(String mobileCompilePath) {
        this.mobileCompilePath = mobileCompilePath;
    }

    public String getMobileCompileServer() {
        return this.mobileCompileServer;
    }

    public void setMobileCompileServer(String mobileCompileServer) {
        this.mobileCompileServer = mobileCompileServer;
    }

    public boolean backUnReset() {
        return this.localUnReset || this.offlineLr;
    }

    public boolean isLocalUnResetNoCompile() {
        return this.localUnResetNoCompile;
    }

    public void setLocalUnResetNoCompile(boolean localUnResetNoCompile) {
        this.localUnResetNoCompile = localUnResetNoCompile;
    }

    public String getCodeFormatAddress() {
        return this.codeFormatAddress;
    }

    public void setCodeFormatAddress(String codeFormatAddress) {
        this.codeFormatAddress = codeFormatAddress;
    }

    public boolean isCheckedCode() {
        return this.checkedCode;
    }

    public void setCheckedCode(boolean checkedCode) {
        this.checkedCode = checkedCode;
    }

    public boolean isLocalCodeFormatter() {
        return this.localCodeFormatter;
    }

    public void setLocalCodeFormatter(boolean localCodeFormatter) {
        this.localCodeFormatter = localCodeFormatter;
    }

    public boolean isLocalCodeFormatCss() {
        return this.localCodeFormatCss;
    }

    public void setLocalCodeFormatCss(boolean localCodeFormatCss) {
        this.localCodeFormatCss = localCodeFormatCss;
    }

    public String getEaiPlatFromUrl() {
        return this.eaiPlatFromUrl;
    }

    public void setEaiPlatFromUrl(String eaiPlatFromUrl) {
        this.eaiPlatFromUrl = eaiPlatFromUrl;
    }

    public String getEaiPlatFromClientId() {
        return this.eaiPlatFromClientId;
    }

    public void setEaiPlatFromClientId(String eaiPlatFromClientId) {
        this.eaiPlatFromClientId = eaiPlatFromClientId;
    }

    public boolean isNewMergeOpen() {
        return this.newMergeOpen;
    }

    public void setNewMergeOpen(boolean newMergeOpen) {
        this.newMergeOpen = newMergeOpen;
    }

    public String getEaiPlatFromClientSecret() {
        return this.eaiPlatFromClientSecret;
    }

    public void setEaiPlatFromClientSecret(String eaiPlatFromClientSecret) {
        this.eaiPlatFromClientSecret = eaiPlatFromClientSecret;
    }

    public String getFileManipulationPatterns() {
        return this.fileManipulationPatterns;
    }

    public void setFileManipulationPatterns(String fileManipulationPatterns) {
        this.fileManipulationPatterns = fileManipulationPatterns;
    }

    public String getJavaCompile() {
        return this.javaCompile;
    }

    public void setJavaCompile(String javaCompile) {
        this.javaCompile = javaCompile;
    }

    public String getEnvServeName() {
        return this.envServeName;
    }

    public void setEnvServeName(String envServeName) {
        this.envServeName = envServeName;
    }

    public boolean isUpgradeConfig() {
        return this.upgradeConfig;
    }

    public void setUpgradeConfig(boolean upgradeConfig) {
        this.upgradeConfig = upgradeConfig;
    }

    public boolean isMethodLine() {
        return this.methodLine;
    }

    public void setMethodLine(boolean methodLine) {
        this.methodLine = methodLine;
    }
}

