/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.runner.log;

import com.jxdinfo.hussar.platform.core.utils.date.LocalDateTimeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class RuntimeLogEvent {
    private Long timestamp;
    private String time;
    private String runType;
    private String logMessage;
    private String status;

    public RuntimeLogEvent() {
    }

    public RuntimeLogEvent(String runType, String status, String logMessage) {
        long epochMilli = Instant.now().toEpochMilli();
        this.timestamp = epochMilli;
        this.time = RuntimeLogEvent.time(epochMilli);
        this.runType = runType;
        this.logMessage = logMessage;
        this.status = status;
    }

    private static String time(long epochMilli) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return LocalDateTimeUtil.format((LocalDateTime)localDateTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getRunType() {
        return this.runType;
    }

    public void setRunType(String runType) {
        this.runType = runType;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return "RuntimeLogEvent{timestamp=" + this.timestamp + ", time='" + this.time + '\'' + ", runType='" + this.runType + '\'' + ", logMessage='" + this.logMessage + '\'' + ", status='" + this.status + '\'' + '}';
    }
}

