/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.java;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.common.file.impl.java.JavaPathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ModularizationJavaPath")
public class ModularizationJavaPath
extends JavaPathServiceImpl {
    private static final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final String modularizationBackPath = formDesignProperties.getModularizationBackPath();
    @Autowired
    private SysDataSourceService sysDataSourceService;

    @Override
    public String getBackProjectPath() {
        this.getPrefix();
        SecurityUser user = BaseSecurityUtil.getUser();
        String tenantCode = user.getTenantCode();
        String userId = user.getUserId().toString();
        String prefixServer = ToolUtil.isNotEmpty(this.prefix) ? this.prefix + "-server" : "";
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(VfgModeTool.isRemote() ? "" : this.workspace, tenantCode, userId, tenantCode + "-web", this.prefix, prefixServer));
    }

    @Override
    public String getJavaGeneratePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.getBackProjectPath(), this.javaCodePath, this.javaPath));
    }

    @Override
    public String getBpmListenerPath() {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.getBackProjectPath(), this.javaCodePath, this.javaPath, this.prefix, this.workflowListenerPath));
    }

    @Override
    public String getJavaPath() {
        this.getPrefix();
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.javaPath, this.prefix));
    }

    @Override
    public String getCloudProjectPath() {
        this.getPrefix();
        return String.format("%s_%s", this.prefix, BaseSecurityUtil.getUser().getId());
    }

    @Override
    public ResourcePath backProjectJava(String ... pathSegments) {
        this.getPrefix();
        String localPrefix = this.getJavaGeneratePath();
        return ResourcePath.of(FileUtil.posixPath(this.prefix.replace("-", "").toLowerCase(), FileUtil.posixPath(pathSegments)), localPrefix, "");
    }

    @Override
    public String getConcatServiceID(String prefix, String ... suffix) {
        this.getPrefix();
        return FileUtil.posixPath(prefix, this.prefix, FileUtil.posixPath(suffix));
    }

    @Override
    public List<SysDataSource> getDatasource(String appId) {
        return this.sysDataSourceService.list();
    }
}

