/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.config.condition;

import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ConditionNotSharedStorage
implements ConfigurationCondition {
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
    }

    public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata metadata) {
        FormDesignScenes scenes = this.getFormDesignScenes(ctx);
        return !scenes.isSharedStorage();
    }

    public FormDesignScenes getFormDesignScenes(ConditionContext ctx) {
        FormDesignScenes scenes;
        String property = ctx.getEnvironment().getProperty("hussar-formdesign.scenes");
        try {
            scenes = FormDesignScenes.valueOf(property != null ? property.toUpperCase() : "OFFLINE");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            scenes = FormDesignScenes.OFFLINE;
        }
        return scenes;
    }
}

