/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.resource;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public abstract class ResourcePathServiceImpl
implements ResourcePathService {
    public static final String MERGE_BASE = ".merge-base";
    public static final String REMOTE_NOT_USED = "not-used";
    public static final String REMOTE_PREVIEW = "preview";
    private static final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    public final String projectCodePath = formDesignProperties.getProjectCodePath();
    public final String projectCustomComponentsPath = formDesignProperties.getProjectAndCustomComponentsPath();
    public final String projectCoverPath = formDesignProperties.getProjectCoverPath();
    public final String serverResourcesPath = formDesignProperties.getServerResourcesPath();
    public final String projectComponentsPath = formDesignProperties.getProjectComponentsPath();
    public final String projectPageTemplatePath = formDesignProperties.getProjectPageTemplatePath();
    public final String printTemplatePath = formDesignProperties.getPrintTemplatePath();
    public final String datasourceStorePath = formDesignProperties.getDatasourceStorePath();
    public final String datasourceTypeStorePath = formDesignProperties.getDatasourceTypeStorePath();
    public final String styleSchemeSpace = formDesignProperties.getStyleSchemeSpace();
    public final String projectRootPath = formDesignProperties.getProjectRootPath();
    public final String noCodeStore = formDesignProperties.getNoCodeStore();
    public final String workspace = formDesignProperties.getWorkspace();
    public final String backProjectPath = formDesignProperties.getBackProjectPath();
    public String prefix;

    void getPrefix() {
        this.prefix = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix();
    }

    String getBackProjectPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.workspace, this.backProjectPath));
    }

    public String localProjectStore() {
        return FileUtil.systemPath(this.getBackProjectPath(), this.projectRootPath);
    }

    String webProjectSetting() {
        return FileUtil.systemPath(this.getWebProjectSetting(), this.projectRootPath);
    }

    String getWebProjectSetting() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.workspace, this.backProjectPath));
    }

    public String convertToRemoteProjectStore(String localProjectStore) {
        return FileUtil.removePathPrefixAndConvertPosix(this.getBackProjectPath(), localProjectStore);
    }

    @Override
    public ResourcePath projectStoreDatasourceFile() {
        String datasourceStorePath = FileUtil.removePathPrefixAndConvertPosix(this.localProjectStore(), this.getDatasourceStorePath());
        return this.projectStore(datasourceStorePath);
    }

    @Override
    public ResourcePath projectStoreDatasourceTypeFile() {
        String datasourceTypeStorePath = FileUtil.removePathPrefixAndConvertPosix(this.localProjectStore(), this.getDatasourceTypeStorePath());
        return this.projectStore(datasourceTypeStorePath);
    }

    @Override
    public ResourcePath projectStoreSettingFile() {
        String webProjectSettingPath = "/setting/webProSetInfo.json";
        return this.projectStore(webProjectSettingPath);
    }

    @Override
    public ResourcePath projectStorePageTemplate(String ... pathSegments) {
        String localPrefix = ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectPageTemplatePath));
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStorePrintTemplate(String ... pathSegments) {
        String localPrefix = ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.printTemplatePath));
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStorePageTemplateCover(String ... pathSegments) {
        String localPrefix = this.getProjectAndPageTemplateCoverPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCustomComponents(String ... pathSegments) {
        String localPrefix = this.getProjectAndCustomComponentsPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCustomComponentsCover(String ... pathSegments) {
        String localPrefix = this.getProjectAndCustomComponentCoverPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreStyleScheme(String ... pathSegments) {
        String localPrefix = ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.styleSchemeSpace));
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath mergeBaseStore(String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.getBackProjectPath(), MERGE_BASE);
        String remotePrefix = FileUtil.posixPath(REMOTE_NOT_USED, MERGE_BASE);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath publishCodeTempPath(String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(formDesignProperties.getWorkspace(), ".publish_cache");
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, "");
    }

    @Override
    public String getProjectAndCodePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectCodePath));
    }

    @Override
    public String getProjectAndCustomComponentsPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectCustomComponentsPath));
    }

    @Override
    public String getProjectAndCustomComponentCoverPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectCustomComponentsPath, this.projectCoverPath));
    }

    @Override
    public String getProjectAndComponentsPath() {
        if (HussarUtils.isNotBlank((CharSequence)this.serverResourcesPath)) {
            return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.serverResourcesPath, this.projectComponentsPath));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectComponentsPath));
    }

    @Override
    public String getComponentIOPath() {
        if (HussarUtils.isNotBlank((CharSequence)this.serverResourcesPath)) {
            return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.serverResourcesPath, this.projectComponentsPath));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectComponentsPath));
    }

    @Override
    public String getNoCodeStoreFullPath() {
        return FileUtil.systemPath(this.getBackProjectPath(), this.noCodeStore);
    }

    @Override
    public String getProjectAndPageTemplateCoverPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.projectPageTemplatePath, this.projectCoverPath));
    }

    @Override
    public String getDatasourceStorePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.datasourceStorePath));
    }

    @Override
    public String getWebProjectSettingPath() {
        String webProjectSettingPath = "/setting/webProSetInfo.json";
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.webProjectSetting(), webProjectSettingPath));
    }

    @Override
    public String getDatasourceTypeStorePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.posixPath(this.localProjectStore(), this.datasourceTypeStorePath));
    }
}

