/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DynDataUtil {
    private static final List<Class<?>> BASIC_TYPES = Arrays.asList(Integer.class, String.class, Double.class, Boolean.class, BigDecimal.class, BigInteger.class, Long.class, Short.class, Float.class, Byte.class);
    private static final List<Class<?>> NUMERIC_TYPES = Arrays.asList(Integer.class, Double.class, BigDecimal.class, BigInteger.class, Long.class, Short.class, Float.class, Byte.class);
    private static final List<Class<?>> INTEGRAL_TYPES = Arrays.asList(Integer.class, BigInteger.class, Long.class, Short.class, Byte.class);
    private static final List<Class<?>> REAL_NUMBER_TYPES = Arrays.asList(Double.class, BigDecimal.class, Float.class);

    public static boolean isBasicType(Object data) {
        if (data == null) {
            return true;
        }
        return BASIC_TYPES.stream().anyMatch(clazz -> clazz.isInstance(data));
    }

    public static boolean isNumericType(Object data) {
        return NUMERIC_TYPES.stream().anyMatch(clazz -> clazz.isInstance(data));
    }

    public static boolean isIntegralType(Object data) {
        return INTEGRAL_TYPES.stream().anyMatch(clazz -> clazz.isInstance(data));
    }

    public static boolean isRealNumberType(Object data) {
        return REAL_NUMBER_TYPES.stream().anyMatch(clazz -> clazz.isInstance(data));
    }

    public static boolean isCompoundType(Object data) {
        return data instanceof Map || data instanceof List;
    }

    public static boolean isBooleanType(Object data) {
        return data instanceof Boolean;
    }

    public static boolean isStringType(Object data) {
        return data instanceof String;
    }

    public static boolean isObjectType(Object data) {
        return data instanceof Map;
    }

    public static boolean isArrayType(Object data) {
        return data instanceof List;
    }

    public static Optional<Boolean> asBoolean(Object data) {
        if (data == null) {
            return Optional.empty();
        }
        if (data instanceof Integer) {
            return Optional.of((Integer)data != 0);
        }
        if (data instanceof String) {
            return Optional.of(!((String)data).isEmpty());
        }
        if (data instanceof Double) {
            return Optional.of((Double)data != 0.0 && !Double.isNaN((Double)data));
        }
        if (data instanceof Boolean) {
            return Optional.of((Boolean)data);
        }
        if (data instanceof BigDecimal) {
            return Optional.of(!data.equals(BigDecimal.ZERO));
        }
        if (data instanceof BigInteger) {
            return Optional.of(!data.equals(BigInteger.ZERO));
        }
        if (data instanceof Long) {
            return Optional.of((Long)data != 0L);
        }
        if (data instanceof Short) {
            return Optional.of((Short)data != 0);
        }
        if (data instanceof Float) {
            return Optional.of(((Float)data).floatValue() != 0.0f && !Float.isNaN(((Float)data).floatValue()));
        }
        if (data instanceof Byte) {
            return Optional.of((Byte)data != 0);
        }
        if (data instanceof Map) {
            return Optional.empty();
        }
        if (data instanceof List) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Integer> asInteger(Object data) {
        if (data == null) {
            return Optional.empty();
        }
        if (data instanceof Integer) {
            return Optional.of((Integer)data);
        }
        if (data instanceof String) {
            try {
                return Optional.of(Integer.parseInt((String)data));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        if (data instanceof Double) {
            double num = (Double)data;
            return Double.isNaN(num) ? Optional.empty() : Optional.of((int)num);
        }
        if (data instanceof Boolean) {
            return Optional.of(data.equals(true) ? 1 : 0);
        }
        if (data instanceof BigDecimal) {
            return Optional.of(((BigDecimal)data).intValue());
        }
        if (data instanceof BigInteger) {
            return Optional.of(((BigInteger)data).intValue());
        }
        if (data instanceof Long) {
            return Optional.of((int)((Long)data).longValue());
        }
        if (data instanceof Short) {
            return Optional.of(Integer.valueOf(((Short)data).shortValue()));
        }
        if (data instanceof Float) {
            float num = ((Float)data).floatValue();
            return Float.isNaN(num) ? Optional.empty() : Optional.of((int)num);
        }
        if (data instanceof Byte) {
            return Optional.of(Integer.valueOf(((Byte)data).byteValue()));
        }
        return Optional.empty();
    }

    public static Optional<Double> asDouble(Object data) {
        if (data == null) {
            return Optional.empty();
        }
        if (data instanceof Integer) {
            return Optional.of(Double.valueOf(((Integer)data).intValue()));
        }
        if (data instanceof String) {
            try {
                return Optional.of(Double.parseDouble((String)data));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        if (data instanceof Double) {
            return Optional.of((Double)data);
        }
        if (data instanceof Boolean) {
            return Optional.of(data.equals(true) ? 1.0 : 0.0);
        }
        if (data instanceof BigDecimal) {
            return Optional.of(((BigDecimal)data).doubleValue());
        }
        if (data instanceof BigInteger) {
            return Optional.of(((BigInteger)data).doubleValue());
        }
        if (data instanceof Long) {
            return Optional.of(Double.valueOf(((Long)data).longValue()));
        }
        if (data instanceof Short) {
            return Optional.of(Double.valueOf(((Short)data).shortValue()));
        }
        if (data instanceof Float) {
            return Optional.of(Double.valueOf(((Float)data).floatValue()));
        }
        if (data instanceof Byte) {
            return Optional.of(Double.valueOf(((Byte)data).byteValue()));
        }
        return Optional.empty();
    }

    public static Optional<String> asString(Object data) {
        if (data == null) {
            return Optional.empty();
        }
        if (DynDataUtil.isBasicType(data)) {
            return Optional.of(String.valueOf(data));
        }
        try {
            return Optional.of(JSON.toJSONString((Object)data));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<Map<Object, Object>> asObject(Object data) {
        if (data instanceof Map) {
            return Optional.of((Map)data);
        }
        return Optional.empty();
    }

    public static Optional<List<Object>> asArray(Object data) {
        if (data instanceof List) {
            return Optional.of((List)data);
        }
        return Optional.empty();
    }

    public static Optional<Object> subscript(Object data, String property) {
        return DynDataUtil.asObject(data).flatMap(object -> Optional.ofNullable(object.get(property)));
    }

    public static Optional<Object> subscript(Object data, int index) {
        Optional<List<Object>> maybeList = DynDataUtil.asArray(data);
        if (!maybeList.isPresent()) {
            return Optional.empty();
        }
        List<Object> list = maybeList.get();
        if (index >= 0 && index < list.size()) {
            return Optional.ofNullable(list.get(index));
        }
        return Optional.empty();
    }

    public static Optional<Object> subscript(Object data, Object ... chain) {
        Optional<Object> result = Optional.ofNullable(data);
        for (Object subscript : chain) {
            if (subscript == null) {
                return Optional.empty();
            }
            if (subscript instanceof String) {
                String property = (String)subscript;
                result = result.flatMap(object -> DynDataUtil.subscript(object, property));
            } else {
                Optional<Integer> maybeIndex = DynDataUtil.asInteger(subscript);
                if (!maybeIndex.isPresent()) {
                    return Optional.empty();
                }
                int index = maybeIndex.get();
                result = result.flatMap(object -> DynDataUtil.subscript(object, index));
            }
            if (result.isPresent()) continue;
            return Optional.empty();
        }
        return result;
    }

    public static Optional<Object> map(Object data, BiFunction<Object, Object, Object> mapper) {
        Optional<Map<Object, Object>> maybeObject = DynDataUtil.asObject(data);
        if (maybeObject.isPresent()) {
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : maybeObject.get().entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                result.put(key, mapper.apply(key, value));
            }
            return Optional.of(result);
        }
        Optional<List<Object>> maybeArray = DynDataUtil.asArray(data);
        if (maybeArray.isPresent()) {
            int i = 0;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : maybeArray.get()) {
                Object value = mapper.apply(i, item);
                result.add(value);
                ++i;
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static Optional<Object> map(Object data, Function<Object, Object> mapper) {
        return DynDataUtil.map(data, (Object key, Object value) -> mapper.apply(value));
    }

    public static Function<Object, Optional<Object>> mapper(BiFunction<Object, Object, Object> mapper) {
        return data -> DynDataUtil.map(data, mapper);
    }

    public static Function<Object, Optional<Object>> mapper(Function<Object, Object> mapper) {
        return data -> DynDataUtil.map(data, mapper);
    }

    public static void forEach(Object data, BiConsumer<Object, Object> action) {
        Optional<Map<Object, Object>> maybeObject = DynDataUtil.asObject(data);
        if (maybeObject.isPresent()) {
            for (Map.Entry<Object, Object> entry : maybeObject.get().entrySet()) {
                action.accept(entry.getKey(), entry.getValue());
            }
            return;
        }
        Optional<List<Object>> maybeArray = DynDataUtil.asArray(data);
        if (maybeArray.isPresent()) {
            int i = 0;
            for (Object item : maybeArray.get()) {
                action.accept(i, item);
                ++i;
            }
        }
    }

    public static void forEach(Object data, Consumer<Object> action) {
        DynDataUtil.forEach(data, (Object key, Object value) -> action.accept(value));
    }
}

