/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.model.vuecode;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassAdapter {
    private ClassAdapter() {
    }

    public static <T> T jsonObjectToBean(JSONObject jsonObject, String className) {
        Class<?> tClass = null;
        try {
            tClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return (T)jsonObject.toJavaObject(tClass);
    }

    public static Map<String, Object> getObjectToMap(Object obj, List<String> ignoreKeys) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassAdapter.addSuperClassFields(clazz, fields);
        Field[] clazzFields = clazz.getDeclaredFields();
        fields.addAll(Arrays.asList(clazzFields));
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (ignoreKeys.contains(fieldName)) continue;
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value == null) {
                value = "";
            }
            map.put(fieldName, value);
        }
        return map;
    }

    private static void addSuperClassFields(Class<?> clazz, List<Field> fields) {
        Class<?> parentClazz = clazz.getSuperclass();
        Field[] superClazzFields = parentClazz.getDeclaredFields();
        fields.addAll(Arrays.asList(superClazzFields));
        if (!HussarUtils.equals(parentClazz, Object.class)) {
            ClassAdapter.addSuperClassFields(parentClazz, fields);
        }
    }
}

