/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.ctx;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.ApiResourceDTO;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishCtx<T extends CodeResult> {
    private static final Logger logger = LoggerFactory.getLogger(PublishCtx.class);
    private BaseFile baseFile;
    private String strategy;
    private List<T> genCodeResults;
    private Map<String, Object> params;
    private PublishDTO publishDTO;
    private Map<String, Object> results;

    public List<T> getGenCodeResults() {
        return this.genCodeResults;
    }

    public void addCodeResults(List<T> genCodeResults) {
        if (ToolUtil.isEmpty(this.genCodeResults)) {
            this.genCodeResults = new ArrayList<T>();
        }
        this.genCodeResults.addAll(genCodeResults);
    }

    public void addCodeResult(T codeResult) {
        if (ToolUtil.isEmpty(this.genCodeResults)) {
            this.genCodeResults = new ArrayList<T>();
        }
        this.genCodeResults.add(codeResult);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void addParams(Map<String, Object> params) {
        if (ToolUtil.isEmpty(this.params)) {
            this.params = new HashMap<String, Object>();
        }
        this.params.putAll(params);
    }

    public void addParam(String key, Object value) {
        if (ToolUtil.isEmpty(this.params)) {
            this.params = new HashMap<String, Object>();
        }
        if (this.params.keySet().stream().anyMatch(alreadyKey -> alreadyKey.equals(key))) {
            logger.info("\u91cd\u590dkey\u503c({})", (Object)key);
        }
        this.params.put(key, value);
    }

    public <P> P getParam(String key, Class<P> clazz) {
        if (ToolUtil.isEmpty(this.params)) {
            return null;
        }
        return (P)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.params.get(key)), clazz);
    }

    public Object getParam(String key) {
        if (ToolUtil.isEmpty(this.params)) {
            return null;
        }
        return this.params.get(key);
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public BaseFile getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(BaseFile baseFile) {
        this.baseFile = baseFile;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    public void addApiResources(ApiResourceDTO apiResource) {
        if (ToolUtil.isEmpty(this.publishDTO)) {
            this.publishDTO = new PublishDTO();
        }
        if (ToolUtil.isEmpty(this.publishDTO.getApis())) {
            ArrayList<ApiResourceDTO> apiResources = new ArrayList<ApiResourceDTO>();
            apiResources.add(apiResource);
            this.publishDTO.setApis(apiResources);
            return;
        }
        this.publishDTO.getApis().add(apiResource);
    }

    public PublishDTO getPublishDTO() {
        return this.publishDTO;
    }

    public void setPublishDTO(PublishDTO publishDTO) {
        this.publishDTO = publishDTO;
    }
}

