/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.ctx;

import com.jxdinfo.hussar.formdesign.common.constant.TriggerType;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.model.ComponentResource;
import com.jxdinfo.hussar.formdesign.common.model.DictInfo;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfigInfo;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Method;
import com.jxdinfo.hussar.formdesign.common.util.InternationalUtil;
import com.jxdinfo.hussar.formdesign.common.util.SortComparatorUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Ctx {
    private String parentConditionId;
    private Action parentAction;
    private Map<String, Object> relatedPrintTemplate = new HashMap<String, Object>();
    private Map<String, String> returnValueIndex = new HashMap<String, String>();
    private Map<String, Method> methods = new TreeMap<String, Method>(new SortComparatorUtil());
    private Map<String, Method> filter = new TreeMap<String, Method>(new SortComparatorUtil());
    private Map<String, Method> computeds = new TreeMap<String, Method>(new SortComparatorUtil());
    private Map<String, Method> computedWithGetSets = new TreeMap<String, Method>(new SortComparatorUtil());
    private Map<String, Method> datas = new TreeMap<String, Method>(new SortComparatorUtil());
    private Map<String, Method> watches = new TreeMap<String, Method>(new SortComparatorUtil());
    private List<String> mounteds = new ArrayList<String>();
    private List<String> mountedAfterOnloads = new ArrayList<String>();
    private List<String> createds = new ArrayList<String>();
    private List<String> destroyeds = new ArrayList<String>();
    private List<String> activateds = new ArrayList<String>();
    private List<String> deactivateds = new ArrayList<String>();
    private final Set<String> components = new HashSet<String>();
    private List<String> componentsList = new ArrayList<String>();
    private List<String> styles = new ArrayList<String>();
    private List<String> nonScopedStyles = new ArrayList<String>();
    private Set<String> imports = new TreeSet<String>();
    private List<String> importsList = new ArrayList<String>();
    private List<String> extendScopedStyles = new ArrayList<String>();
    private LcdpComponent currentLcdpComponent;
    private LcdpComponent rootLcdpComponent;
    private Map<String, Object> params;
    private EventConfig eventConfig;
    private final Map<String, LcdpComponent> componentMap = new HashMap<String, LcdpComponent>();
    private Map<String, String> annotation = new HashMap<String, String>();
    private List<String> annotationComponent = new ArrayList<String>();
    private final Map<String, Action> actionMap = new HashMap<String, Action>();
    private String pageName;
    private PageInfo pageInfo;
    private DictInfo dictInfo = new DictInfo();
    private List<String> asyncMethods = new ArrayList<String>();
    private List<ComponentResource> elementResourceDTOList = new ArrayList<ComponentResource>();
    private Set<String> customMountedStr = new HashSet<String>();
    private boolean isEnableTransDisposition = InternationalUtil.isEnableTransDisposition();
    private Integer strategy;
    private CodeFormatResult codeFormatResult;
    private UpgradeConfigInfo upgradeConfigInfo;

    public List<String> getAsyncMethods() {
        return this.asyncMethods;
    }

    public List<ComponentResource> getElementResourceDTOList() {
        return this.elementResourceDTOList;
    }

    public void setElementResourceDTOList(List<ComponentResource> elementResourceDTOList) {
        this.elementResourceDTOList = elementResourceDTOList;
    }

    public boolean isEnableTransDisposition() {
        return this.isEnableTransDisposition;
    }

    public void setEnableTransDisposition(boolean enableTransDisposition) {
        this.isEnableTransDisposition = enableTransDisposition;
    }

    public UpgradeConfigInfo getUpgradeConfigInfo() {
        return this.upgradeConfigInfo;
    }

    public void setUpgradeConfigInfo(UpgradeConfigInfo upgradeConfigInfo) {
        this.upgradeConfigInfo = upgradeConfigInfo;
    }

    public void addAllUpgradeConfigs(List<UpgradeConfig> upgradeConfigs) {
        if (this.upgradeConfigInfo == null) {
            this.upgradeConfigInfo = new UpgradeConfigInfo();
        }
        this.upgradeConfigInfo.addAllUpgradeConfigs(upgradeConfigs);
    }

    public void addUpgradeConfigRef(String ref, List<String> upgradeIds) {
        if (this.upgradeConfigInfo == null) {
            this.upgradeConfigInfo = new UpgradeConfigInfo();
        }
        this.upgradeConfigInfo.addRef(ref, upgradeIds);
    }

    public CodeFormatResult getCodeFormatResult() {
        return this.codeFormatResult;
    }

    public void setCodeFormatResult(CodeFormatResult codeFormatResult) {
        this.codeFormatResult = codeFormatResult;
    }

    public Integer getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Integer strategy) {
        this.strategy = strategy;
    }

    public Map<String, String> getReturnValueIndex() {
        return this.returnValueIndex;
    }

    public void addReturnValue(String actionId, String returnValue) {
        this.returnValueIndex.putIfAbsent(actionId, returnValue);
    }

    public Map<String, Object> getRelatedPrintTemplate() {
        return this.relatedPrintTemplate;
    }

    public void addRelatedPrintTemplate(String templateId, Object template) {
        this.relatedPrintTemplate.putIfAbsent(templateId, template);
    }

    public Set<String> getCustomMountedStr() {
        return this.customMountedStr;
    }

    public void addCustomMountedStr(String customStr) {
        this.customMountedStr.add(customStr);
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public Map<String, Method> getComputeds() {
        return this.computeds;
    }

    public Map<String, Method> getComputedWithGetSets() {
        return this.computedWithGetSets;
    }

    public Map<String, Method> getDatas() {
        return this.datas;
    }

    public List<String> getMountedAfterOnloads() {
        return this.mountedAfterOnloads;
    }

    public void setMountedAfterOnloads(List<String> mountedAfterOnloads) {
        this.mountedAfterOnloads = mountedAfterOnloads;
    }

    @Deprecated
    public void addData(String data) {
        if (data.endsWith(",")) {
            data = data.substring(0, data.length() - 1);
        }
        Method method = new Method();
        this.datas.put(data.trim(), method);
    }

    public void addData(String data, String comments) {
        if (data.endsWith(",")) {
            data = data.substring(0, data.length() - 1);
        }
        Method method = new Method();
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            list.add(comments);
        }
        method.setComments(list);
        this.datas.put(data.trim(), method);
    }

    public LcdpComponent getCurrentLcdpComponent() {
        return this.currentLcdpComponent;
    }

    public void setCurrentLcdpComponent(LcdpComponent currentLcdpComponent) {
        this.currentLcdpComponent = currentLcdpComponent;
    }

    public LcdpComponent getRootLcdpComponent() {
        return this.rootLcdpComponent;
    }

    public void setRootLcdpComponent(LcdpComponent rootLcdpComponent) {
        this.rootLcdpComponent = rootLcdpComponent;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public List<String> getMounteds() {
        return this.mounteds;
    }

    public List<String> getCreateds() {
        return this.createds;
    }

    public EventConfig getEventConfig() {
        return this.eventConfig;
    }

    public void setEventConfig(EventConfig eventConfig) {
        this.eventConfig = eventConfig;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void addImports(String imp) {
        if (this.importsList.contains(imp)) {
            return;
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("imports");
            String end = this.getAnnotationEnd("imports");
            if (this.importsList.contains(end)) {
                int index = this.importsList.indexOf(end);
                this.importsList.add(index, imp);
                this.imports.add(imp);
            } else {
                this.importsList.add(begin);
                this.importsList.add(imp);
                this.importsList.add(end);
                this.imports.add(begin);
                this.imports.add(imp);
                this.imports.add(end);
            }
        } else {
            this.importsList.add(imp);
            this.imports.add(imp);
        }
    }

    public List<String> getExtendScopedStyles() {
        return this.extendScopedStyles;
    }

    public void addExtendScopedStyles(String extendScopedStyle) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("extendScopedStyles");
            String end = this.getAnnotationEnd("extendScopedStyles");
            if (this.extendScopedStyles.contains(end)) {
                int index = this.extendScopedStyles.indexOf(end);
                this.extendScopedStyles.add(index, extendScopedStyle);
            } else {
                this.extendScopedStyles.add(begin);
                this.extendScopedStyles.add(extendScopedStyle);
                this.extendScopedStyles.add(end);
            }
        } else {
            this.extendScopedStyles.add(extendScopedStyle);
        }
    }

    public void addImports(String importContent, String importPackage) {
        String importStatement;
        importContent = importContent.trim();
        importPackage = importPackage.trim();
        boolean alreadyImported = false;
        String fromSeparator = " from ";
        for (String oldImp : this.imports) {
            if (!oldImp.contains("{") || !oldImp.contains("}")) continue;
            String oldPackageName = oldImp.substring(oldImp.indexOf(fromSeparator) + fromSeparator.length());
            if (!(oldPackageName = oldPackageName.replace("'", "").replace(";", "")).equals(importPackage)) continue;
            String oldContentName = oldImp.substring(oldImp.indexOf("{") + 2, oldImp.indexOf("}") - 1);
            if (Arrays.asList(oldContentName.split(", ")).contains(importContent)) {
                return;
            }
            importStatement = "import { " + oldContentName + ", " + importContent + " } from '" + importPackage + "';";
            this.imports.remove(oldImp);
            this.importsList.remove(oldImp);
            this.addImports(importStatement);
            alreadyImported = true;
            break;
        }
        if (!alreadyImported) {
            importStatement = "import { " + importContent + " } from '" + importPackage + "';";
            this.addImports(importStatement);
        }
    }

    public void addImports(String importContent, String asVariable, String importPackage) {
        importContent = importContent.trim();
        asVariable = asVariable.trim();
        importPackage = importPackage.trim();
        String importStatement = "import " + importContent + " as " + asVariable + " from '" + importPackage + "';";
        this.addImports(importStatement);
    }

    public Map<String, LcdpComponent> getComponentMap() {
        return this.componentMap;
    }

    public List<String> getCycleInputParameter() {
        if (ToolUtil.isNotEmpty(this.currentLcdpComponent) && ToolUtil.isNotEmpty(this.currentLcdpComponent.getListParentKeyChain())) {
            ArrayList<String> cycleInputParameter = new ArrayList<String>();
            List<String> listParentKeyChain = this.currentLcdpComponent.getListParentKeyChain();
            for (String insKey : listParentKeyChain) {
                cycleInputParameter.add(insKey + "Item");
                cycleInputParameter.add(insKey + "Index");
            }
            return cycleInputParameter;
        }
        return new ArrayList<String>();
    }

    public List<String> getArgsByListParentKeyChain() {
        if (ToolUtil.isNotEmpty(this.currentLcdpComponent) && ToolUtil.isNotEmpty(this.currentLcdpComponent.getListParentKeyChain())) {
            return this.currentLcdpComponent.getListParentKeyChain().stream().map(item -> item + "Item").collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<String> getArgsByListParentKeyChainIndex() {
        if (ToolUtil.isNotEmpty(this.currentLcdpComponent) && ToolUtil.isNotEmpty(this.currentLcdpComponent.getListParentKeyChain())) {
            return this.currentLcdpComponent.getListParentKeyChain().stream().map(item -> item + "Index").collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Deprecated
    public void addMethod(String triggerName, String methodBody) {
        if (this.parentAction != null) {
            this.parentAction.addMethodBlock(this.parentConditionId, methodBody);
            return;
        }
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter())) {
            this.addMethod(triggerName, this.getCycleInputParameter(), methodBody);
        } else {
            Method method = this.methods.get(triggerName);
            if (method == null) {
                method = new Method();
            }
            method.setTrigger(triggerName);
            method.addMethodBlock(this.parentConditionId, methodBody);
            this.methods.put(triggerName, method);
        }
    }

    public void addMethod(boolean hasItem, String triggerName, String methodBody, boolean checkRepeat) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (this.parentAction != null) {
            this.parentAction.addMethodBlock(this.parentConditionId, methodBody);
            return;
        }
        if (hasItem && ToolUtil.isNotEmpty(this.getCycleInputParameter())) {
            this.addMethod(triggerName, this.getCycleInputParameter(), methodBody, checkRepeat);
        } else {
            Method method = this.methods.get(triggerName);
            if (method == null) {
                method = new Method();
            }
            if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
                method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
            }
            method.setTrigger(triggerName);
            method.addMethodBlock(this.parentConditionId, methodBody);
            this.methods.put(triggerName, method);
        }
    }

    public void addMethod(boolean hasItem, String triggerName, List<String> args, String methodBody, boolean checkRepeat) {
        Method method;
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (hasItem && ToolUtil.isNotEmpty(this.getCycleInputParameter()) && !HussarUtils.equals(this.getCycleInputParameter(), args)) {
            args = Stream.of(args, this.getCycleInputParameter()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        if ((method = this.methods.get(triggerName)) == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        this.methods.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    public void addMethod(String triggerName, String methodBody, boolean checkRepeat) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (this.parentAction != null) {
            this.parentAction.addMethodBlock(this.parentConditionId, methodBody);
            return;
        }
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter())) {
            this.addMethod(triggerName, this.getCycleInputParameter(), methodBody, checkRepeat);
        } else {
            Method method = this.methods.get(triggerName);
            if (method == null) {
                method = new Method();
            }
            if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
                method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
            }
            method.setTrigger(triggerName);
            method.addMethodBlock(this.parentConditionId, methodBody);
            this.methods.put(triggerName, method);
        }
    }

    public void addMethod(String triggerName, String methodBody, boolean checkRepeat, String comments) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (this.parentAction != null) {
            this.parentAction.addMethodBlock(this.parentConditionId, methodBody);
            return;
        }
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter())) {
            this.addMethod(triggerName, this.getCycleInputParameter(), methodBody, checkRepeat, comments);
        } else {
            Method method = this.methods.get(triggerName);
            if (method == null) {
                method = new Method();
            }
            if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
                method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
            }
            method.setTrigger(triggerName);
            method.addMethodBlock(this.parentConditionId, methodBody);
            ArrayList<String> list = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)comments)) {
                String[] commentArray = comments.split("\n");
                Collections.addAll(list, commentArray);
            }
            method.setComments(list);
            this.methods.put(triggerName, method);
        }
    }

    public void addMethod(String triggerName, boolean notNeedMethodBody, boolean checkRepeat, String comments) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        Method method = this.methods.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.setNotNeedMethodBody(notNeedMethodBody);
        this.methods.put(triggerName, method);
    }

    public Map<String, Action> getActionMap() {
        return this.actionMap;
    }

    @Deprecated
    public void addFilter(String triggerName, List<String> args, String methodBody) {
        Method method = this.methods.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        this.filter.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    public void addFilter(String triggerName, List<String> args, String methodBody, String comments) {
        Method method = this.methods.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        this.filter.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    @Deprecated
    public void addMethod(String triggerName, List<String> args, String methodBody) {
        Method method;
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter()) && !HussarUtils.equals(this.getCycleInputParameter(), args)) {
            args = Stream.of(this.getCycleInputParameter(), args).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if ((method = this.methods.get(triggerName)) == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        this.methods.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    public void addMethod(String triggerName, List<String> args, boolean isExtend, String methodBody) {
        Method method;
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter()) && !HussarUtils.equals(this.getCycleInputParameter(), args)) {
            args = Stream.of(this.getCycleInputParameter(), args).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if ((method = this.methods.get(triggerName)) == null) {
            method = new Method();
        }
        if (isExtend) {
            this.annotation.put(triggerName, triggerName);
            this.annotationComponent.add(triggerName);
            method.setAnnotationKey(triggerName);
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        this.methods.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    public void addMethod(String triggerName, List<String> args, String methodBody, boolean checkRepeat) {
        Method method;
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter()) && !HussarUtils.equals(this.getCycleInputParameter(), args)) {
            args = Stream.of(args, this.getCycleInputParameter()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        if ((method = this.methods.get(triggerName)) == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        this.methods.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    public void addMethod(String triggerName, List<String> args, String methodBody, boolean checkRepeat, String comments) {
        Method method;
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.methods.get(triggerName))) {
            return;
        }
        if (ToolUtil.isNotEmpty(this.getCycleInputParameter()) && !HussarUtils.equals(this.getCycleInputParameter(), args)) {
            args = Stream.of(args, this.getCycleInputParameter()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        if ((method = this.methods.get(triggerName)) == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(this.parentConditionId, methodBody);
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        this.methods.put(triggerName, method);
        method.getArgs().addAll(args);
    }

    @Deprecated
    public void addMethod(String trigger, String triggerName, String methodBody) {
        if (TriggerType._ON_LOAD.getType().equals(trigger)) {
            this.addMethod(this.getRootLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper(TriggerType._ON_LOAD.getType()), methodBody, false);
        } else {
            this.addMethod(triggerName, methodBody, false);
        }
    }

    public void addMethod(String trigger, String triggerName, String methodBody, String comments) {
        if (TriggerType._ON_LOAD.getType().equals(trigger)) {
            this.addMethod(this.getRootLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper(TriggerType._ON_LOAD.getType()), methodBody, false, comments);
        } else {
            this.addMethod(triggerName, methodBody, false, comments);
        }
    }

    @Deprecated
    public void addComputed(String triggerName, String methodBody) {
        Method method = this.computeds.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.computeds.put(triggerName, method);
    }

    @Deprecated
    public void addComputed(String triggerName, String methodBody, boolean checkRepeat) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.computeds.get(triggerName))) {
            return;
        }
        Method method = this.computeds.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.computeds.put(triggerName, method);
    }

    public void addComputed(String triggerName, String methodBody, boolean checkRepeat, String comments) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.computeds.get(triggerName))) {
            return;
        }
        Method method = this.computeds.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.computeds.put(triggerName, method);
    }

    @Deprecated
    public void addComputedWithGetSet(String triggerName, String methodBody) {
        Method method = new Method();
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.computedWithGetSets.put(triggerName, method);
    }

    public void addComputedWithGetSet(String triggerName, String methodBody, String comments) {
        Method method = new Method();
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.computedWithGetSets.put(triggerName, method);
    }

    @Deprecated
    public void addComputed(String triggerName, List<String> args, String methodBody) {
        Method method = this.computeds.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.getArgs().addAll(args);
        method.addMethodBlock(null, methodBody);
        this.computeds.put(triggerName, method);
    }

    public void addComputed(String triggerName, List<String> args, String methodBody, boolean checkRepeat, String comments) {
        if (checkRepeat && HussarUtils.isNotEmpty((Object)this.computeds.get(triggerName))) {
            return;
        }
        Method method = this.computeds.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.getArgs().addAll(args);
        method.addMethodBlock(null, methodBody);
        this.computeds.put(triggerName, method);
    }

    @Deprecated
    public void addWatch(String triggerName, String methodBody) {
        Method method = this.watches.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.watches.put(triggerName, method);
    }

    public void addWatch(String triggerName, String methodBody, String comments) {
        Method method = this.watches.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.addMethodBlock(null, methodBody);
        this.watches.put(triggerName, method);
    }

    public void addWatch(String triggerName, String methodBody, boolean checkRepeat, String comments) {
        if (!checkRepeat || !HussarUtils.isNotEmpty((Object)this.watches.get(triggerName))) {
            Method method = this.watches.get(triggerName);
            if (method == null) {
                method = new Method();
            }
            if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
                method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
            }
            method.setTrigger(triggerName);
            method.addMethodBlock(null, methodBody);
            this.watches.put(triggerName, method);
        }
    }

    @Deprecated
    public void addWatch(String triggerName, List<String> args, String methodBody) {
        Method method = this.watches.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.setTrigger(triggerName);
        method.getArgs().addAll(args);
        method.addMethodBlock(null, methodBody);
        this.watches.put(triggerName, method);
    }

    public void addWatch(String triggerName, List<String> args, String methodBody, String comments) {
        Method method = this.watches.get(triggerName);
        if (method == null) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        ArrayList<String> list = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)comments)) {
            String[] commentArray = comments.split("\n");
            Collections.addAll(list, commentArray);
        }
        method.setComments(list);
        method.setTrigger(triggerName);
        method.getArgs().addAll(args);
        method.addMethodBlock(null, methodBody);
        this.watches.put(triggerName, method);
    }

    public void addMounted(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("mounteds");
            String end = this.getAnnotationEnd("mounteds");
            if (this.mounteds.contains(end)) {
                int index = this.mounteds.indexOf(end);
                this.mounteds.add(index, methodBody);
            } else {
                this.mounteds.add(begin);
                this.mounteds.add(methodBody);
                this.mounteds.add(end);
            }
        } else {
            this.mounteds.add(methodBody);
        }
    }

    public void addMountedAfterOnloads(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("mountedAfterOnloads");
            String end = this.getAnnotationEnd("mountedAfterOnloads");
            if (this.mountedAfterOnloads.contains(end)) {
                int index = this.mountedAfterOnloads.indexOf(end);
                this.mountedAfterOnloads.add(index, methodBody);
            } else {
                this.mountedAfterOnloads.add(begin);
                this.mountedAfterOnloads.add(methodBody);
                this.mountedAfterOnloads.add(end);
            }
        } else {
            this.mountedAfterOnloads.add(methodBody);
        }
    }

    public void addCreated(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("createds");
            String end = this.getAnnotationEnd("createds");
            if (this.createds.contains(end)) {
                int index = this.createds.indexOf(end);
                this.createds.add(index, methodBody);
            } else {
                this.createds.add(begin);
                this.createds.add(methodBody);
                this.createds.add(end);
            }
        } else {
            this.createds.add(methodBody);
        }
    }

    public void addDestroyeds(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("destroyeds");
            String end = this.getAnnotationEnd("destroyeds");
            if (this.destroyeds.contains(end)) {
                int index = this.destroyeds.indexOf(end);
                this.destroyeds.add(index, methodBody);
            } else {
                this.destroyeds.add(begin);
                this.destroyeds.add(methodBody);
                this.destroyeds.add(end);
            }
        } else {
            this.destroyeds.add(methodBody);
        }
    }

    public void addActivated(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("activateds");
            String end = this.getAnnotationEnd("activateds");
            if (this.activateds.contains(end)) {
                int index = this.activateds.indexOf(end);
                this.activateds.add(index, methodBody);
            } else {
                this.activateds.add(begin);
                this.activateds.add(methodBody);
                this.activateds.add(end);
            }
        } else {
            this.activateds.add(methodBody);
        }
    }

    @Deprecated
    public void addDeactivated(String methodBody) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("deactivateds");
            String end = this.getAnnotationEnd("deactivateds");
            if (this.deactivateds.contains(end)) {
                int index = this.deactivateds.indexOf(end);
                this.deactivateds.add(index, methodBody);
            } else {
                this.deactivateds.add(begin);
                this.deactivateds.add(methodBody);
                this.deactivateds.add(end);
            }
        } else {
            this.deactivateds.add(methodBody);
        }
    }

    public void addDeactivated(String methodBody, boolean checkRepeat) {
        if (checkRepeat) {
            for (int i = 0; i < this.deactivateds.size(); ++i) {
                if (!methodBody.equals(this.deactivateds.get(i))) continue;
                return;
            }
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("deactivateds");
            String end = this.getAnnotationEnd("deactivateds");
            if (this.deactivateds.contains(end)) {
                int index = this.deactivateds.indexOf(end);
                this.deactivateds.add(index, methodBody);
            } else {
                this.deactivateds.add(begin);
                this.deactivateds.add(methodBody);
                this.deactivateds.add(end);
            }
        } else {
            this.deactivateds.add(methodBody);
        }
        this.deactivateds.add(methodBody);
    }

    public void addComponent(String component) {
        if (HussarUtils.isNotEmpty((Object)component)) {
            component = component + ",";
        }
        if (this.componentsList.contains(component)) {
            return;
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("components");
            String end = this.getAnnotationEnd("components");
            if (this.componentsList.contains(end)) {
                int index = this.componentsList.indexOf(end);
                this.componentsList.add(index, component);
                this.components.add(component);
            } else {
                this.componentsList.add(begin);
                this.componentsList.add(component);
                this.componentsList.add(end);
                this.components.add(begin);
                this.components.add(component);
                this.components.add(end);
            }
        } else {
            this.componentsList.add(component);
            this.components.add(component);
        }
    }

    public String getStyles() {
        return String.join((CharSequence)"\n", this.styles);
    }

    public void addStyle(String style) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("styles");
            String end = this.getAnnotationEnd("styles");
            if (this.styles.contains(end)) {
                int index = this.styles.indexOf(end);
                this.styles.add(index, style);
            } else {
                this.styles.add(begin);
                this.styles.add(style);
                this.styles.add(end);
            }
        } else {
            this.styles.add(style);
        }
    }

    public boolean hasNonScopedStyles() {
        return this.nonScopedStyles.size() > 0;
    }

    public String getNonScopedStyles() {
        return String.join((CharSequence)"\n", this.nonScopedStyles);
    }

    public void addNonScopedStyle(String style) {
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            String begin = this.getAnnotationBegin("nonScopedStyles");
            String end = this.getAnnotationEnd("nonScopedStyles");
            if (this.nonScopedStyles.contains(end)) {
                int index = this.nonScopedStyles.indexOf(end);
                this.nonScopedStyles.add(index, style);
            } else {
                this.nonScopedStyles.add(begin);
                this.nonScopedStyles.add(style);
                this.nonScopedStyles.add(end);
            }
        } else {
            this.nonScopedStyles.add(style);
        }
    }

    public String getAnnotationBegin(String type) {
        String begin = "/* begin " + type + ":" + this.annotation.get(this.currentLcdpComponent.getInstanceKey()) + "*/";
        return begin;
    }

    public String getAnnotationEnd(String type) {
        String end = "/* end " + type + ":" + this.annotation.get(this.currentLcdpComponent.getInstanceKey()) + "*/";
        return end;
    }

    public void setNonScopedStyles(List<String> nonScopedStyles) {
        this.nonScopedStyles = nonScopedStyles;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public Map<String, Method> getWatches() {
        return this.watches;
    }

    public String getParentConditionId() {
        return this.parentConditionId;
    }

    public void setParentConditionId(String parentConditionId) {
        this.parentConditionId = parentConditionId;
    }

    public Map<String, Method> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<String, Method> filter) {
        this.filter = filter;
    }

    public void addCondition(String triggerName, String id, String codeFrame, String parentId, Action parent) {
        if (parent != null) {
            parent.addConditionBlock(id, codeFrame, parentId);
            return;
        }
        triggerName = this.currentLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper(triggerName);
        Method method = this.methods.get(triggerName);
        if (null == method) {
            method = new Method();
        }
        if (this.annotation.containsKey(this.currentLcdpComponent.getInstanceKey())) {
            method.setAnnotationKey(this.annotation.get(this.currentLcdpComponent.getInstanceKey()));
        }
        method.addConditionBlock(id, codeFrame, parentId);
        this.methods.put(triggerName, method);
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public List<String> getDestroyeds() {
        return this.destroyeds;
    }

    public List<String> getActivateds() {
        return this.activateds;
    }

    public List<String> getDeactivateds() {
        return this.deactivateds;
    }

    public Action getParentAction() {
        return this.parentAction;
    }

    public void setParentAction(Action parentAction) {
        this.parentAction = parentAction;
    }

    public DictInfo getDictInfo() {
        return this.dictInfo;
    }

    @Deprecated
    public void addAsyncMethod(String triggerName, List<String> args, String methodBody) {
        if (ToolUtil.isNotEmpty(args) && args.size() > 0) {
            this.addMethod("async " + triggerName, args, methodBody, false);
        } else {
            this.addMethod("async " + triggerName, methodBody, false);
        }
    }

    public void addAsyncMethod(String triggerName, List<String> args, String methodBody, String comments) {
        if (ToolUtil.isNotEmpty(args) && args.size() > 0) {
            this.addMethod("async " + triggerName, args, methodBody, false, comments);
        } else {
            this.addMethod("async " + triggerName, methodBody, false, comments);
        }
    }

    @Deprecated
    public void addAsyncMethodWithOutSort(String triggerName, List<String> args, String methodBody) {
        this.asyncMethods.add(triggerName);
        if (ToolUtil.isNotEmpty(args) && args.size() > 0) {
            this.addMethod(triggerName, args, methodBody, false);
        } else {
            this.addMethod(triggerName, methodBody, false);
        }
    }

    public void addAsyncMethodWithOutSort(String triggerName, List<String> args, String methodBody, String comments) {
        this.asyncMethods.add(triggerName);
        if (ToolUtil.isNotEmpty(args) && args.size() > 0) {
            this.addMethod(triggerName, args, methodBody, false, comments);
        } else {
            this.addMethod(triggerName, methodBody, false, comments);
        }
    }

    public Map<String, String> getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Map<String, String> annotation) {
        this.annotation = annotation;
    }

    public List<String> getAnnotationComponent() {
        return this.annotationComponent;
    }

    public void setAnnotationComponent(List<String> annotationComponent) {
        this.annotationComponent = annotationComponent;
    }

    public List<String> getComponentsList() {
        return this.componentsList;
    }

    public List<String> getImportsList() {
        return this.importsList;
    }

    public void setImportsList(List<String> importsList) {
        this.importsList = importsList;
    }
}

