/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.constant.VfgModelType;
import com.jxdinfo.hussar.formdesign.common.constant.path.PathEnum;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.AppIdHandler;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfgModeTool {
    private static final Logger logger = LoggerFactory.getLogger(VfgModeTool.class);
    private static final String DEFAULT_APP_ID = "1646777064113700865";

    public static void setAppId(String formId) {
        if (VfgModeTool.checkVfgModel().booleanValue()) {
            AppContextUtil.setAppId(VfgModeTool.appId(formId));
        }
    }

    public static String appId(String formId) {
        String appId = AppContextUtil.getAppId();
        if (ToolUtil.isEmpty(appId)) {
            appId = VfgModeTool.getAppIdByFormId(formId);
        }
        return ToolUtil.isNotEmpty(appId) ? appId : DEFAULT_APP_ID;
    }

    public static String appId() {
        return ToolUtil.isEmpty(AppContextUtil.getAppId()) ? DEFAULT_APP_ID : AppContextUtil.getAppId();
    }

    private static String getAppIdByFormId(String formId) {
        try {
            if (HussarUtils.isNotEmpty((Object)formId)) {
                AppIdHandler appIdHandler = (AppIdHandler)SpringContextHolder.getBean(AppIdHandler.class);
                return appIdHandler.getAppIdByFormId(formId);
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u52a8\u6001\u6a21\u578b\u8868\u67e5\u8be2\u4e0d\u5230appId");
        }
        return null;
    }

    public static Boolean checkVfgModel() {
        FormDesignProperties formDesignProperties = SpringUtil.getBean(FormDesignProperties.class);
        return VfgModelType.NO_PLUS_LOW.name().equals(formDesignProperties.getVfgModel());
    }

    public static boolean isModularization() {
        String sceneType = ((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).scene();
        return sceneType.equals(PathEnum.MODULARIZATION.getScene());
    }

    public static boolean isRemote() {
        String fileManipulationPatterns = ((FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class)).getFileManipulationPatterns();
        return fileManipulationPatterns.equals("REMOTE");
    }

    public static void pushToRemote(String commitMsg, List<String> filesToAdd) {
        if (VfgModeTool.isRemote()) {
            // empty if block
        }
    }

    public static void pushToRemoteImmediately(String commitMsg, List<String> filesToAdd) {
        if (VfgModeTool.isRemote()) {
            IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
            gitlabService.pushVfgCode(commitMsg, filesToAdd, System.getProperty("user.dir"));
        }
    }

    public static class Port {
        private String backPort;
        private String frontPort;

        public Port(String backPort, String frontPort) {
            this.backPort = backPort;
            this.frontPort = frontPort;
        }

        public String getBackPort() {
            return this.backPort;
        }

        public void setBackPort(String backPort) {
            this.backPort = backPort;
        }

        public String getFrontPort() {
            return this.frontPort;
        }

        public void setFrontPort(String frontPort) {
            this.frontPort = frontPort;
        }
    }
}

