/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.app.IApp;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.datasource.FormDesignDataSource;
import com.jxdinfo.hussar.formdesign.datasource.IDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AppContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppContextUtil.class);
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private static PrefixEntry prefixEntry = (PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class);
    private static final Pattern REGEXP_IDENTIFIER = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    public static final String APP_ID_ATTRIBUTE = "appId";
    private static final String TENANT_CODE_ATTRIBUTE = "tenantCode";
    private static final String APP_ID_DEBUG = "appId\u95ee\u9898: ";

    public static String getAppId() {
        Object o;
        if (HussarUtils.isNotEmpty((Object)AppContextUtil.getRequest())) {
            Object attribute = AppContextUtil.getRequest().getAttribute(APP_ID_ATTRIBUTE);
            if (HussarUtils.isNotEmpty((Object)attribute) && attribute instanceof String) {
                return String.valueOf(attribute);
            }
            String appIdStr = Optional.ofNullable(AppContextUtil.getRequest().getParameter(APP_ID_ATTRIBUTE)).filter(appId -> !appId.isEmpty() && !"null".equals(appId) && !"undefined".equals(appId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)appIdStr)) {
                return appIdStr;
            }
            appIdStr = Optional.ofNullable(AppContextUtil.getRequest().getHeader(APP_ID_ATTRIBUTE)).filter(appId -> !appId.isEmpty() && !"null".equals(appId) && !"undefined".equals(appId)).orElse(null);
            if (HussarUtils.isNotEmpty((Object)appIdStr)) {
                return appIdStr;
            }
        }
        if (HussarUtils.isNotEmpty((Object)(o = TransmittableThreadLocalHolder.get(APP_ID_ATTRIBUTE)))) {
            return String.valueOf(o);
        }
        return null;
    }

    public static void setAppId(String appId) {
        HttpServletRequest request = AppContextUtil.getRequest();
        if (HussarUtils.isNotEmpty((Object)request)) {
            request.setAttribute(APP_ID_ATTRIBUTE, (Object)appId);
            request.removeAttribute(TENANT_CODE_ATTRIBUTE);
        }
        TransmittableThreadLocalHolder.set(APP_ID_ATTRIBUTE, appId);
    }

    public static void setPrefix(String key, String value) {
        HttpServletRequest request = AppContextUtil.getRequest();
        if (HussarUtils.isEmpty((Object)request)) {
            return;
        }
        request.setAttribute(key, (Object)value);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (HussarUtils.isEmpty((Object)attrs)) {
            return null;
        }
        if (!(attrs instanceof ServletRequestAttributes)) {
            throw new UnsupportedOperationException("AppContextUtil.getRequest(): not ServletRequestAttributes");
        }
        return ((ServletRequestAttributes)attrs).getRequest();
    }

    public static String posixFilePathPrefix() {
        String prefix = prefixEntry.getPrefix();
        String modules = formDesignProperties.getModules();
        return ToolUtil.isNotEmpty(prefix) ? FileUtil.posixPath(modules, prefix) : prefix;
    }

    public static String posixFilePathPrefix(String path) {
        String prefix = prefixEntry.getPrefix();
        String microCode = prefixEntry.getMicroPrefix();
        String modules = formDesignProperties.getModules();
        if (ToolUtil.isNotEmpty(prefix)) {
            if (ToolUtil.isNotEmpty(microCode)) {
                return "";
            }
            return FileUtil.posixPathByOldWay(modules, prefix);
        }
        return prefix;
    }

    public static String getServiceID(String frontProjectPath) {
        String prefix = prefixEntry.getPrefix();
        String microCode = prefixEntry.getMicroPrefix();
        if (ToolUtil.isEmpty(prefix)) {
            return frontProjectPath;
        }
        if (ToolUtil.isNotEmpty(microCode)) {
            return FileUtil.posixPathByOldWay(frontProjectPath.substring(0, frontProjectPath.lastIndexOf(File.separator)), prefix);
        }
        return frontProjectPath;
    }

    public static String getServiceID() {
        String prefix = prefixEntry.getPrefix();
        String microCode = prefixEntry.getMicroPrefix();
        if (ToolUtil.isEmpty(prefix)) {
            return "";
        }
        if (ToolUtil.isNotEmpty(microCode)) {
            return prefix;
        }
        return "";
    }

    public static String getUnionPrefix() {
        return prefixEntry.getPrefix();
    }

    public static String getDeploymentMode() {
        return formDesignProperties.getDeploymentMode();
    }

    public static String getServiceName() {
        if (VfgModeTool.isRemote()) {
            return "hussar-tlExample";
        }
        String property = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (ToolUtil.isNotEmpty(property)) {
            return property;
        }
        return prefixEntry.getPrefix();
    }

    public static String getGeneratorFilePathPrefixByAppId(String appId) {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfoById(appId);
        if (appInfo == null) {
            return null;
        }
        return FileUtil.posixPath(AppContextUtil.asIdentifier(appInfo.getTenantId()), AppContextUtil.asIdentifier(appInfo.getEnglishName()));
    }

    public static String getAppBackCodePrefix() {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfo();
        if (appInfo == null) {
            return null;
        }
        return FileUtil.posixPath(AppContextUtil.asIdentifier(appInfo.getTenantId()), AppContextUtil.asIdentifier(appInfo.getEnglishName())).toLowerCase();
    }

    public static String getAppBackCodePrefixByAppId(String appId) {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfoById(appId);
        if (appInfo == null) {
            return null;
        }
        return FileUtil.posixPath(AppContextUtil.asIdentifier(appInfo.getTenantId()), AppContextUtil.asIdentifier(appInfo.getEnglishName())).toLowerCase();
    }

    public static String getAppBackPackagePrefix() {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfo();
        if (appInfo == null) {
            return null;
        }
        return FileUtil.packagePath(AppContextUtil.asIdentifier(appInfo.getTenantId()), AppContextUtil.asIdentifier(appInfo.getEnglishName()));
    }

    public static String getAppRouteName() {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfo();
        if (appInfo == null) {
            return null;
        }
        return appInfo.getName();
    }

    public static String getAppRoutePrefix() {
        return AppContextUtil.posixFilePathPrefix();
    }

    public static FormDesignAppInfo getAppInfo() {
        String appId = AppContextUtil.getAppId();
        if (appId == null) {
            return null;
        }
        IApp appInfoService = null;
        try {
            appInfoService = SpringUtil.getBean(IApp.class);
            return appInfoService.getAppInfo(appId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static FormDesignAppInfo getAppInfoById(String appId) {
        if (appId == null) {
            return null;
        }
        IApp appInfoService = SpringUtil.getBean(IApp.class);
        return appInfoService.getAppInfo(appId);
    }

    public static String getAppDsName() {
        return Optional.ofNullable(AppContextUtil.getAppInfo()).map(FormDesignAppInfo::getTenantId).flatMap(tenantCode -> {
            IDataSource dataSourceService = SpringUtil.getBean(IDataSource.class);
            return Optional.ofNullable(dataSourceService.getDefaultByTenantCode(tenantCode)).map(FormDesignDataSource::getDbName);
        }).orElse(null);
    }

    public static <T> T computeInAppDs(AppDsComputation<T> computation) {
        String dbName = AppContextUtil.getAppDsName();
        if (dbName != null) {
            try {
                return AppContextUtil.computeInAppDsChangeTempDs(dbName, computation);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AppDsExecutionTargetException(e);
            }
        }
        try {
            return computation.compute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppDsExecutionTargetException(e);
        }
    }

    @HussarDs(value="#dbName")
    private static <T> T computeInAppDsChangeTempDs(String dbName, AppDsComputation<T> computation) throws Exception {
        return computation.compute();
    }

    public static void executeInAppDs(AppDsExecution execution) {
        AppContextUtil.computeInAppDs(() -> {
            execution.execute();
            return null;
        });
    }

    public static String asIdentifier(String ident) {
        if (ident == null) {
            return "_";
        }
        if (REGEXP_IDENTIFIER.matcher(ident).matches() && !JAVA_KEYWORDS.contains(ident.toLowerCase())) {
            return ident;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('_');
        for (int i = 0; i < ident.length(); ++i) {
            char ch = ident.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') && ch != '_') continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    public static class AppDsExecutionTargetException
    extends RuntimeException {
        public AppDsExecutionTargetException() {
        }

        public AppDsExecutionTargetException(String message) {
            super(message);
        }

        public AppDsExecutionTargetException(String message, Throwable cause) {
            super(message, cause);
        }

        public AppDsExecutionTargetException(Throwable cause) {
            super(cause);
        }
    }

    public static interface AppDsExecution {
        public void execute() throws Exception;
    }

    public static interface AppDsComputation<T> {
        public T compute() throws Exception;
    }
}

