/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl.vue;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.file.impl.vue.VuePathServiceImpl;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import java.io.File;
import org.springframework.stereotype.Service;

@Service(value="ModularizationVuePath")
public class ModularizationVuePath
extends VuePathServiceImpl {
    private static final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final String modularizationFrontPath = formDesignProperties.getModularizationFrontPath();

    @Override
    public String getFrontProjectPath() {
        this.getPrefix();
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String userId = BaseSecurityUtil.getUser().getUserId().toString();
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(VfgModeTool.isRemote() ? "" : this.workspace, tenantCode, userId, tenantCode + "-front", this.frontProjectPath, this.prefix));
    }

    @Override
    public String getFrontApiPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.frontApiPath, this.api, this.prefix));
    }

    @Override
    public String getVueCodePath() {
        this.getPrefix();
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, FileUtil.posixPath(this.modules, this.prefix), this.views));
    }

    @Override
    public String getVueCodePath(Integer strategy) {
        if (null != strategy) {
            return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, this.pages));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, this.views, this.prefix));
    }

    @Override
    public String getExtendScriptPath() {
        this.getPrefix();
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, this.extendScriptPath));
    }

    @Override
    public String getCloudFrontProjectPath(String frontProjectPath, String ... pathSegments) {
        this.getPrefix();
        return FileUtil.systemPath(FileUtil.posixPath(frontProjectPath.substring(0, frontProjectPath.lastIndexOf(File.separator)), this.prefix), FileUtil.posixPath(pathSegments));
    }

    @Override
    public String posixFilePathPrefix(String prefix, String ... suffix) {
        return FileUtil.systemPath(prefix, FileUtil.posixPath(suffix));
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public String concatPrefix(String prefix, String ... suffix) {
        this.getPrefix();
        return FileUtil.posixPath(prefix, this.prefix, FileUtil.posixPath(suffix));
    }

    @Override
    public String getPathName() {
        return ToolUtil.isEmpty(this.prefix) ? "" : FileUtil.posixPath("/", this.prefix);
    }

    @Override
    public String getName() {
        return VfgModeTool.isModularization() ? String.format("%s/%s", formDesignProperties.getEnvServeName(), this.prefix) : this.prefix;
    }
}

