/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util.mongo;

import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateCache;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;

public class MongoTemplateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoTemplateUtil.class);
    private static final String MONGO_PREFIX = "spring.data.mongodb.";
    private static final String MONGO_HOST = "host";
    private static final String MONGO_PORT = "port";
    private static final String MONGO_USERNAME = "username";
    private static final String MONGO_PASSWORD = "password";
    private static final String MONGO_AUTHENTICATION_DATABASE = "authentication-database";
    private static final String MONGO_DATABASE = "database";

    public static void dropDb(String dbName) {
    }

    public static MongoTemplate createDb(String dbName) {
        MongoClient mongoClient = MongoTemplateUtil.mongoClient();
        SimpleMongoClientDbFactory simpleMongoClientDbFactory = new SimpleMongoClientDbFactory(mongoClient, dbName);
        MongoDatabase db = simpleMongoClientDbFactory.getDb();
        for (String collectionName : db.listCollectionNames()) {
            if (!"forCreate".equals(collectionName)) continue;
            LOGGER.info("\u5df2\u5b58\u5728\u5e93\u540d\u4e3a" + dbName + "\u7684mongodb");
            return MongoTemplateCache.get();
        }
        db.createCollection("forCreate");
        MongoTemplate mongoTemplate = new MongoTemplate((MongoDbFactory)simpleMongoClientDbFactory);
        MongoTemplateCache.put(dbName, mongoTemplate);
        LOGGER.info("\u5efa\u5e93\u6210\u529f\uff1a{}", (Object)dbName);
        return mongoTemplate;
    }

    public static MongoClient mongoClient() {
        return MongoClients.create((String)String.format("mongodb://%s", MongoTemplateUtil.getProperty("spring.data.mongodb.host") + ":" + Integer.parseInt(MongoTemplateUtil.getProperty("spring.data.mongodb.port"))));
    }

    public static String getProperty(String key) {
        Environment propertyEnv = (Environment)SpringContextUtil.getBean(Environment.class);
        return Optional.ofNullable(propertyEnv.getProperty(key)).orElseGet(String::new);
    }
}

