/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.devtools.file.service.FileUtilsManager;
import com.jxdinfo.hussar.formdesign.devtools.model.ComponentDto;
import com.jxdinfo.hussar.formdesign.devtools.model.FileModel;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class FileUtils {
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    private static final String SYSTEM_DIR = System.getProperty("user.dir");

    private static FileUtilsManager fileUtilsManager() {
        return (FileUtilsManager)SpringContextHolder.getBean(FileUtilsManager.class);
    }

    private static FormDesignProperties formDesignProperties() {
        return (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readFileToString(file, encoding, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (String)encoding);
    }

    public static String readFileToString(File file, Charset encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readFileToString(file, encoding.name(), SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)encoding);
    }

    public static String readFileToString(String filePath, Charset encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                if (!FileUtils.exists(new File(filePath))) {
                    return null;
                }
                return FileUtils.fileUtilsManager().readFileToString(new File(filePath), encoding.name(), SYSTEM_DIR);
            }
        }
        return FileUtil.readFileToString(filePath);
    }

    public static String readFileToStringIfExists(String filePath, Charset encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readFileToStringIfExists(new File(filePath), encoding.name(), SYSTEM_DIR);
            }
        }
        return FileUtil.readFileToString(filePath);
    }

    public static Map<String, String> readFilesToStringIfExists(List<String> filePaths, Charset encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readFilesToStringIfExists(filePaths, encoding.name(), SYSTEM_DIR);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<String> iterator = filePaths.iterator();
        while (iterator.hasNext()) {
            String filePath;
            File file = new File(filePath = iterator.next());
            map.put(filePath, file.exists() ? org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)encoding) : null);
        }
        return map;
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readFileToByteArray(file, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
    }

    public static void writeStringToFile(File file, String data, Charset encoding) throws IOException {
        FileUtils.writeStringToFile(file, data, encoding.name());
    }

    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeStringToFile(file.getAbsolutePath(), new FileModel(data), encoding, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (String)encoding);
    }

    public static void writeStringToFile(File file, String data, String encoding, boolean append) throws IOException {
        FileUtils.writeStringToFile(file, data, encoding);
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeByteArrayToFile(file.getAbsolutePath(), data, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data);
    }

    public static void forceDelete(File file) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().forceDelete(file, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.forceDelete((File)file);
    }

    public static void deleteDirectory(File directory) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().deleteDirectory(directory, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static boolean deleteQuietly(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().deleteQuietly(file, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static Collection<File> listFiles(File directory, String[] extensions, boolean recursive) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().listFiles(directory, extensions, recursive, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static File[] listFiles(File directory) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().listFiles(directory, SYSTEM_DIR);
            }
        }
        return directory.listFiles();
    }

    public static void touch(File file) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().touch(file, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.touch((File)file);
    }

    public static List<String> readLines(File file, Charset encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readLines(file.getAbsolutePath(), encoding, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.readLines((File)file, (Charset)encoding);
    }

    public static List<String> readLines(File file, String encoding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().readLines(file, encoding, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.readLines((File)file, (String)encoding);
    }

    public static void writeLines(File file, Collection<?> lines) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeLines(file.getAbsolutePath(), lines, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeLines((File)file, lines);
    }

    public static void writeLines(File file, String encoding, Collection<?> lines) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeLines(file.getAbsolutePath(), encoding, lines, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines);
    }

    public static void writeLines(File file, Collection<?> lines, boolean append) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeLines(file.getAbsolutePath(), lines, append, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeLines((File)file, lines, (boolean)append);
    }

    public static void writeLines(File file, String encoding, Collection<?> lines, String lineEnding) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().writeLines(file.getAbsolutePath(), encoding, lines, lineEnding, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.writeLines((File)file, (String)encoding, lines, (String)lineEnding);
    }

    public static void forceMkdir(File directory) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().forceMkdir(directory, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.forceMkdir((File)directory);
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().copyFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), preserveFileDate, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile, (boolean)preserveFileDate);
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().moveFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath(), SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    public static void moveDirectory(File srcDir, File destDir) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().moveDirectory(srcDir.getAbsolutePath(), destDir.getAbsolutePath(), SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.moveDirectory((File)srcDir, (File)destDir);
    }

    public static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().moveFileToDirectory(srcFile.getAbsolutePath(), destDir.getAbsolutePath(), createDestDir, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.moveFileToDirectory((File)srcFile, (File)destDir, (boolean)createDestDir);
    }

    public static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().moveDirectoryToDirectory(src.getAbsolutePath(), destDir.getAbsolutePath(), createDestDir, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)createDestDir);
    }

    public static void copyFileToDirectory(File srcFile, File destDir, boolean preserveFileDate) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().copyFileToDirectory(srcFile.getAbsolutePath(), destDir.getAbsolutePath(), preserveFileDate, SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.copyFileToDirectory((File)srcFile, (File)destDir, (boolean)preserveFileDate);
    }

    public static void copyFileToDirectory(File srcFile, File destDir) throws IOException {
        FileUtils.copyFileToDirectory(srcFile, destDir, true);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().copyDirectoryToDirectory(srcDir.getAbsolutePath(), destDir.getAbsolutePath(), SYSTEM_DIR);
                return;
            }
        }
        org.apache.commons.io.FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
    }

    public static boolean exists(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().exists(file, SYSTEM_DIR);
            }
        }
        return file.exists();
    }

    public static boolean isFile(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().isFile(file, SYSTEM_DIR);
            }
        }
        return file.isFile();
    }

    public static boolean isDirectory(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().isDirectory(file, SYSTEM_DIR);
            }
        }
        return file.isDirectory();
    }

    public static long sizeOf(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().sizeOf(file, SYSTEM_DIR);
            }
        }
        return org.apache.commons.io.FileUtils.sizeOf((File)file);
    }

    public static void copyForJar(byte[] jarFile, String toFile) throws IOException {
        int a;
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().copyForJar(jarFile, toFile, SYSTEM_DIR);
                return;
            }
        }
        ByteArrayInputStream fromFile = new ByteArrayInputStream(jarFile);
        byte[] b = new byte[1024];
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        while ((a = fromFile.read(b)) != -1) {
            fos.write(b, 0, a);
        }
    }

    public static boolean isHidden(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().isHidden(file, SYSTEM_DIR);
            }
        }
        return file.isHidden();
    }

    public static boolean delete(File file) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().delete(file, SYSTEM_DIR);
            }
        }
        return file.delete();
    }

    public static void submitDeferredTasks(Map<String, String> fileList) throws IOException, LcdpException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                FileUtils.fileUtilsManager().submitDeferredTasks(fileList, SYSTEM_DIR);
                break;
            }
            default: {
                FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
                filePublishService.submitDeferredTasks(fileList);
            }
        }
    }

    public static Map<String, String> iteratorFile(File file, File rootFile) throws LcdpException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().iteratorFile(file.getAbsolutePath(), rootFile.getAbsolutePath(), SYSTEM_DIR);
            }
        }
        HashMap<String, String> fileMappingMap = new HashMap<String, String>();
        DataFileService dataFileService = (DataFileService)SpringContextHolder.getBean(DataFileService.class);
        dataFileService.iteratorFile(file, fileMappingMap, rootFile);
        return fileMappingMap;
    }

    public static List<JSONObject> iteratorTree(String projectStoreCodePath, String pid, String filters) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().iteratorTree(projectStoreCodePath, pid, filters, SYSTEM_DIR);
            }
        }
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        if (!new File(projectStoreCodePath).exists()) {
            return jsonObjects;
        }
        FileUtils.iteratorTree(jsonObjects, new File(projectStoreCodePath), pid, filters.split(","));
        return jsonObjects;
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    private static void iteratorTree(List<JSONObject> jsonObjects, File file, String pId, String[] filters) throws IOException {
        File[] files;
        if (file.isDirectory() && ToolUtil.isNotEmpty(files = file.listFiles())) {
            for (File childFile : files) {
                JSONObject jsonObject;
                File mataFile = new File(childFile.getAbsolutePath() + ".meta");
                if (!mataFile.exists() || (jsonObject = JSONObject.parseObject((String)org.apache.commons.io.FileUtils.readFileToString((File)mataFile, (Charset)StandardCharsets.UTF_8))) == null) continue;
                jsonObject.put("parentId", (Object)pId);
                jsonObjects.add(jsonObject);
                String type = jsonObject.getString("type");
                if (ToolUtil.isNotEmpty(type) && FileUtils.anyMatch(type, filters)) {
                    JSONObject dataJsonObject = JSONObject.parseObject((String)org.apache.commons.io.FileUtils.readFileToString((File)childFile, (Charset)StandardCharsets.UTF_8));
                    jsonObject.put("data", (Object)dataJsonObject);
                }
                if (!childFile.isDirectory()) continue;
                FileUtils.iteratorTree(jsonObjects, childFile, jsonObject.getString("id"), filters);
            }
        }
    }

    public static boolean anyMatch(String target, String ... conditions) {
        boolean or = false;
        for (String condition : conditions) {
            or = or || target.equals(condition);
        }
        return or;
    }

    public static List<Map<String, Object>> getAllImages(String imgPath, String splitPath) throws Exception {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().getAllImages(imgPath, splitPath, SYSTEM_DIR);
            }
        }
        ArrayList<Map<String, Object>> imgList = new ArrayList<Map<String, Object>>();
        File[] files = new File(ToolUtil.pathFomatterByOS(imgPath)).listFiles();
        FileUtils.getAllLocalImages(files, imgList, splitPath);
        return imgList;
    }

    public static String ImageToBase64ByLocal(String imgFile) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] encoded = Base64.getEncoder().encode(data);
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static void getAllLocalImages(File[] files, List<Map<String, Object>> imgList, String splitPath) throws Exception {
        if (null != files && files.length > 0) {
            for (File f : files) {
                if (f.isFile()) {
                    HashMap<String, String> imgMap = new HashMap<String, String>();
                    imgMap.put("name", f.getName());
                    imgMap.put("path", FileUtils.ImageToBase64ByLocal(f.getAbsolutePath()));
                    imgMap.put("relativePath", f.getAbsolutePath().substring(splitPath.length()).replaceAll("\\\\", "/"));
                    imgMap.put("absolutePath", URLEncoder.encode(f.getAbsolutePath().substring(FileUtils.formDesignProperties().getWorkspace().length()), "utf-8"));
                    imgList.add(imgMap);
                    continue;
                }
                File[] fileList = f.listFiles();
                FileUtils.getAllLocalImages(fileList, imgList, splitPath);
            }
        }
    }

    public static void uploadImages(String imgPath, MultipartFile[] files) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                for (MultipartFile file : files) {
                    FileUtils.fileUtilsManager().uploadImage(file, imgPath, SYSTEM_DIR);
                }
                break;
            }
            default: {
                File fileSave = new File(imgPath);
                if (!fileSave.exists()) {
                    org.apache.commons.io.FileUtils.forceMkdir((File)fileSave);
                }
                for (MultipartFile file : files) {
                    String nameOld = file.getOriginalFilename();
                    File fileFinal = new File(imgPath, nameOld);
                    file.transferTo(fileFinal);
                }
            }
        }
    }

    public static void getFile(String path, HttpServletResponse response) throws IOException {
        byte[] buffer = null;
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                buffer = FileUtils.fileUtilsManager().getFile(path, SYSTEM_DIR);
                response.reset();
                response.addHeader("Content-Length", "" + FileUtils.sizeOf(new File(path)));
                break;
            }
            default: {
                File file = new File(path);
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                buffer = new byte[((InputStream)fis).available()];
                ((InputStream)fis).read(buffer);
                ((InputStream)fis).close();
                response.reset();
                response.addHeader("Content-Length", "" + file.length());
            }
        }
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/" + path.substring(path.lastIndexOf(".") + 1) + ";charset=utf-8");
        BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)toClient).write(buffer);
        ((OutputStream)toClient).flush();
        ((OutputStream)toClient).close();
    }

    public static ComponentDto export(ComponentDto componentDto) throws Exception {
        List fileNames = componentDto.getFileNames();
        String rootPath = componentDto.getRootPath();
        String backendFileName = componentDto.getBackendFileName();
        String id = componentDto.getId();
        Map outFileNames = componentDto.getOutFileNames();
        for (int i = 0; i < fileNames.size(); ++i) {
            String absolutePath = rootPath + File.separator + (String)fileNames.get(i);
            if (((String)fileNames.get(i)).equals(backendFileName)) {
                String fileName = (String)fileNames.get(i);
                String outBackendFileName = fileName.substring(id.length());
                outFileNames.put(absolutePath, outBackendFileName);
            } else {
                outFileNames.put(absolutePath, fileNames.get(i));
            }
            fileNames.set(i, absolutePath);
        }
        componentDto.setFileNames(fileNames);
        componentDto.setOutFileNames(outFileNames);
        return componentDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inducts(MultipartFile file, String id, String backendFileName, String rootPath, List<String> fileNames) throws Exception {
        ZipInputStream zis = new ZipInputStream(file.getInputStream(), FileUtils.getFileCharset(file.getInputStream()));
        HashMap<String, BufferedOutputStream> outs = new HashMap<String, BufferedOutputStream>();
        Iterator<String> iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            String fileName;
            String outFileName = fileName = iterator.next();
            if (fileName.equals(backendFileName)) {
                outFileName = id + outFileName;
            }
            FileOutputStream fos = new FileOutputStream(FileUtil.posixPath(rootPath, outFileName));
            BufferedOutputStream out = new BufferedOutputStream(fos);
            outs.put(fileName, out);
        }
        byte[] dataByte = new byte[1024];
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String name = zipEntry.getName();
                for (String fileName : fileNames) {
                    int count;
                    if (!name.equals(fileName)) continue;
                    while ((count = zis.read(dataByte)) != -1) {
                        ((BufferedOutputStream)outs.get(fileName)).write(dataByte, 0, count);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
        }
        finally {
            for (String fileName : fileNames) {
                try {
                    if (!HussarUtils.isNotEmpty(outs.get(fileName))) continue;
                    ((BufferedOutputStream)outs.get(fileName)).flush();
                    ((BufferedOutputStream)outs.get(fileName)).close();
                }
                catch (IOException e) {
                    logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                }
            }
        }
        for (String fileName : fileNames) {
            try {
                if (!HussarUtils.isNotEmpty(outs.get(fileName))) continue;
                ((BufferedOutputStream)outs.get(fileName)).flush();
                ((BufferedOutputStream)outs.get(fileName)).close();
            }
            catch (IOException e) {
                logger.error("\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            }
        }
        logger.info("\u5199\u5165\u7ec4\u4ef6\u4fe1\u606f" + rootPath);
    }

    public static byte[] install(String path) throws Exception {
        File file = new File(path);
        return FileUtils.fileToMultipartFile(file).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsString(String frontFile, String frontJsPath) throws FileNotFoundException {
        FileInputStream frontIs = new FileInputStream(frontJsPath);
        try {
            frontFile = IOUtils.toString((InputStream)frontIs, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6js\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                if (HussarUtils.isNotEmpty((Object)frontIs)) {
                    frontIs.close();
                }
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6js\u5931\u8d25", (Throwable)e);
            }
        }
        return frontFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getFileCharset(InputStream is) {
        ZipInputStream zis = new ZipInputStream(is, StandardCharsets.UTF_8);
        boolean flag = false;
        try {
            while (zis.getNextEntry() != null) {
            }
        }
        catch (IOException | IllegalArgumentException e) {
            flag = true;
        }
        finally {
            try {
                if (HussarUtils.isNotEmpty((Object)is)) {
                    is.close();
                }
                if (HussarUtils.isNotEmpty((Object)zis)) {
                    zis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Charset charset = flag ? Charset.forName("GBK") : Charset.forName("UTF-8");
        return charset;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        FileItem fileItem = FileUtils.creatFileItem(file);
        return new CommonsMultipartFile(fileItem);
    }

    public static FileItem creatFileItem(File file) {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory(16, null);
        FileItem fileItem = diskFileItemFactory.createItem(file.getName(), "application/zip", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            OutputStream outputStream = fileItem.getOutputStream();
            while ((bytesRead = fileInputStream.read(buffer, 0, 8192)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            Files.copy(file.toPath(), outputStream);
            outputStream.close();
            fileInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileItem;
    }

    public static List<String> getFilePath(String filepath, String type) throws LcdpException, IOException {
        ArrayList<String> fileList = new ArrayList<String>();
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().getFilePath(filepath, type, SYSTEM_DIR);
            }
        }
        if (StringUtil.isEmpty((Object)type)) {
            if (FileUtils.isDirectory(new File(filepath))) {
                try (Stream<Path> paths = Files.walk(Paths.get(filepath, new String[0]), new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> fileList.add(file.toString()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filepath);
                }
            }
        } else if (FileUtils.isDirectory(new File(filepath))) {
            try (Stream<Path> paths = Files.walk(Paths.get(filepath, new String[0]), new FileVisitOption[0]);){
                paths.map(Path::toString).filter(f -> f.endsWith(type)).forEach(fileList::add);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, filepath);
            }
        }
        return fileList;
    }

    public static String getJsContent(String filePath) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().getJsContent(filePath, SYSTEM_DIR);
            }
        }
        FileReader reader = new FileReader(filePath);
        String jsContent = new BufferedReader(reader).lines().collect(Collectors.joining());
        reader.close();
        return jsContent;
    }

    public static FormDesignResponse<String> upload(MultipartFile file, String fileSavePath) throws LcdpException {
        FormDesignResponse<String> response = new FormDesignResponse<String>();
        String fileName = file.getOriginalFilename();
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                try {
                    FileUtils.fileUtilsManager().uploadImage(file, fileSavePath, SYSTEM_DIR);
                    response.setData(fileName);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, fileName);
                }
            }
            default: {
                try {
                    File fileSave = new File(fileSavePath);
                    if (!fileSave.exists()) {
                        org.apache.commons.io.FileUtils.forceMkdir((File)fileSave);
                    }
                    file.transferTo(new File(fileSavePath + File.separator + fileName));
                    response.setData(fileName);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.UPLOAD_ERROR, fileName);
                }
            }
        }
        return response;
    }

    public static Boolean writeFile(List<String> writeFileUrlList, List<JSONObject> jsonObjectList) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().writeFile(writeFileUrlList, jsonObjectList, SYSTEM_DIR);
            }
        }
        int i = 0;
        if (ToolUtil.isNotEmpty(writeFileUrlList)) {
            for (String url : writeFileUrlList) {
                try {
                    FileOutputStream outFile = new FileOutputStream(url);
                    Throwable throwable = null;
                    try {
                        String data = String.valueOf(jsonObjectList.get(i));
                        if (StringUtils.isNotEmpty((CharSequence)data)) {
                            if ("null".equals(data)) {
                                ((OutputStream)outFile).write("".getBytes());
                            } else {
                                ((OutputStream)outFile).write(data.getBytes());
                            }
                            outFile.flush();
                        }
                        ++i;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outFile == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)outFile).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)outFile).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public static boolean createNewFile(File file) throws IOException {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().createNewFile(file, SYSTEM_DIR);
            }
        }
        return file.createNewFile();
    }

    public static boolean fixName(File oldFile, File newFile) {
        switch (FileUtils.formDesignProperties().getFileManipulationPatterns()) {
            case "REMOTE": {
                return FileUtils.fileUtilsManager().fixName(oldFile.getPath(), newFile.getPath(), SYSTEM_DIR);
            }
        }
        return oldFile.renameTo(newFile);
    }
}

