/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingCache;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.refer.PageRefer;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="DataFileServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class DataFileServiceImpl
implements DataFileService {
    private static final String cache = "speedFileMappingCache";

    @Override
    @ExceptionCatcher
    public Map<String, String> getFileMapping() throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStoreCode(new String[0]).getLocalPath());
        File commonModelFile = new File(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[0]).getLocalPath() + "/common_model");
        map.putAll(FileUtils.iteratorFile(file, file));
        map.putAll(FileUtils.iteratorFile(commonModelFile, commonModelFile));
        return map;
    }

    @Override
    public void fileMappingEvict() {
    }

    @Override
    public void iteratorFile(File file, Map<String, String> fileMappingMap, File rootFile) throws LcdpException {
        if (FileUtils.exists(file)) {
            if (FileUtils.isDirectory(file)) {
                File[] files = FileUtils.listFiles(file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, fileMappingMap, rootFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                BaseFile baseFile;
                String id = "";
                try {
                    baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString(file, "UTF-8"), BaseFile.class);
                    id = baseFile.getId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
                }
                if (ToolUtil.isNotEmpty(id)) {
                    String relativePath = "common_model".equalsIgnoreCase(baseFile.getParentId()) ? "/common_model" + file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "") : file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                    if (ToolUtil.isNotEmpty(fileMappingMap.get(id))) {
                        throw new LcdpException(LcdpExceptionEnum.SAME_FILE_ID, fileMappingMap.get(id) + "\n" + relativePath);
                    }
                    fileMappingMap.put(id, FileUtil.posixPath(relativePath));
                }
            }
        }
    }

    @Override
    public Map<String, Map<String, List<String>>> getFileReferMapping() throws LcdpException {
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        File file = new File(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStoreCode(new String[0]).getLocalPath());
        this.iteratorReferFile(file, map);
        return map;
    }

    private void iteratorReferFile(File file, Map<String, Map<String, List<String>>> fileMappingMap) throws LcdpException {
        block13: {
            block12: {
                if (!FileUtils.exists(file) || !FileUtils.isDirectory(file)) break block12;
                File[] files = FileUtils.listFiles(file);
                if (files == null) break block13;
                for (File childFile : files) {
                    this.iteratorReferFile(childFile, fileMappingMap);
                }
                break block13;
            }
            if (file.getName().endsWith(".meta")) {
                Object o;
                JSONObject obj;
                String id;
                try {
                    BaseFile baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString(file, "UTF-8"), BaseFile.class);
                    String type = baseFile.getType();
                    if ("Module".equals(type)) {
                        return;
                    }
                    id = baseFile.getId();
                    String absolutePath = file.getAbsolutePath();
                    String path = absolutePath.substring(0, absolutePath.lastIndexOf("."));
                    File f = new File(ToolUtil.pathFomatterByOS(path));
                    obj = JSONObject.parseObject((String)FileUtils.readFileToString(f, "UTF-8"));
                }
                catch (Exception e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
                }
                if (ToolUtil.isNotEmpty(obj) && ToolUtil.isNotEmpty(o = obj.get((Object)"references"))) {
                    List references = JSON.parseArray((String)JSON.toJSONString((Object)o), PageRefer.class);
                    HashMap<String, List<Object>> referMap = new HashMap<String, List<Object>>();
                    for (PageRefer reference : references) {
                        List<String> referValuePathList = reference.getReferValuePath();
                        for (String referValue : referValuePathList) {
                            BaseFile refFile;
                            String refId = referValue.split("\\.")[0];
                            String refPath = FileMappingCache.getFileMappingCache().get(refId);
                            if (!ToolUtil.isNotEmpty(refPath)) continue;
                            try {
                                File f = "dict".equalsIgnoreCase(refId) || "organ".equalsIgnoreCase(refId) || "user".equalsIgnoreCase(refId) ? new File(ToolUtil.pathFomatterByOS(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[0]).getLocalPath() + refPath)) : new File(ToolUtil.pathFomatterByOS(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStoreCode(new String[0]).getLocalPath() + refPath));
                                refFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString(f, "UTF-8"), BaseFile.class);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            String type = refFile.getType();
                            List refList = (List)referMap.get(type);
                            if (ToolUtil.isNotEmpty(refList)) {
                                HashSet<String> arrayList = new HashSet<String>((Collection)referMap.get(type));
                                arrayList.add(refId);
                                referMap.put(type, new ArrayList(arrayList));
                            } else {
                                referMap.put(type, Collections.singletonList(refId));
                            }
                            fileMappingMap.put(id, referMap);
                        }
                    }
                }
            }
        }
    }
}

