/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileMappingCache {
    private static final Map<String, Map<String, String>> fileMappingCaches = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, Map<String, List<String>>>> fileReferMappingCaches = new ConcurrentHashMap<String, Map<String, Map<String, List<String>>>>();

    private FileMappingCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileMappingCacheEvict() {
        if (fileMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        Map<String, String> map = fileMappingCaches.get(FileMappingCache.dealServiceName());
        synchronized (map) {
            fileMappingCaches.get(FileMappingCache.dealServiceName()).clear();
        }
    }

    public static boolean isCacheEmpty() {
        return ToolUtil.isEmpty(fileMappingCaches.get(FileMappingCache.dealServiceName()));
    }

    public static Map<String, String> getFileMappingCache() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fileMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        FileMappingCache.deepClone(fileMappingCaches.get(FileMappingCache.dealServiceName()), map);
        return map;
    }

    public static void updateFileMappingCache(Map<String, String> map) {
        if (fileMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        FileMappingCache.deepClone(map, fileMappingCaches.get(FileMappingCache.dealServiceName()));
    }

    public static Map<String, Map<String, List<String>>> getFileReferMappingCache() {
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        if (fileReferMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileReferMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        FileMappingCache.deepReferClone(fileReferMappingCaches.get(FileMappingCache.dealServiceName()), map);
        return map;
    }

    public static void updateFileReferMappingCache(Map<String, Map<String, List<String>>> map) {
        if (fileReferMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileReferMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        FileMappingCache.deepReferClone(map, fileReferMappingCaches.get(FileMappingCache.dealServiceName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileReferMappingCacheEvict() {
        if (fileReferMappingCaches.get(FileMappingCache.dealServiceName()) == null) {
            fileReferMappingCaches.put(FileMappingCache.dealServiceName(), new ConcurrentHashMap());
        }
        Map<String, Map<String, List<String>>> map = fileReferMappingCaches.get(FileMappingCache.dealServiceName());
        synchronized (map) {
            fileReferMappingCaches.get(FileMappingCache.dealServiceName()).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deepClone(Map<String, String> fromMap, Map<String, String> toMap) {
        Map<String, String> map = fileMappingCaches.get(FileMappingCache.dealServiceName());
        synchronized (map) {
            toMap.clear();
            for (Map.Entry<String, String> entry : fromMap.entrySet()) {
                String key = entry.getKey();
                if (key == null || fromMap.get(key) == null) continue;
                toMap.put(key.toString(), fromMap.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deepReferClone(Map<String, Map<String, List<String>>> fromMap, Map<String, Map<String, List<String>>> toMap) {
        Map<String, String> map = fileMappingCaches.get(FileMappingCache.dealServiceName());
        synchronized (map) {
            toMap.clear();
            for (Map.Entry<String, Map<String, List<String>>> stringMapEntry : fromMap.entrySet()) {
                String key = stringMapEntry.getKey();
                if (key == null || fromMap.get(key) == null) continue;
                toMap.put(key.toString(), fromMap.get(key));
            }
        }
    }

    private static String dealServiceName() {
        String key = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getCloudProjectPath() + AppContextUtil.getAppId();
        return key.isEmpty() ? "main" : key;
    }
}

