/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util.types;

import com.jxdinfo.hussar.formdesign.common.util.types.FiledType;
import com.jxdinfo.hussar.formdesign.common.util.types.oracle.OracleFloat;
import com.jxdinfo.hussar.formdesign.common.util.types.oracle.OracleNumber;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DbFiledTypeUtil {
    private static final DbFiledType mysqlFiledType = new DbFiledType("mysql");
    private static final DbFiledType oracleFiledType = new DbFiledType("oracle");
    private static final DbFiledType dmFiledType = new DbFiledType("dm");

    public static String getJavaTypeByDbFiledType(String dbType, String filedType, Integer dataLength, Integer dataDot) {
        if ("mysql".equalsIgnoreCase(dbType)) {
            return mysqlFiledType.getJavaTypeByDbFiledType(filedType, dataLength, dataDot);
        }
        if ("oracle".equalsIgnoreCase(dbType)) {
            return oracleFiledType.getJavaTypeByDbFiledType(filedType, dataLength, dataDot);
        }
        if ("dm".equalsIgnoreCase(dbType)) {
            return dmFiledType.getJavaTypeByDbFiledType(filedType, dataLength, dataDot);
        }
        return "";
    }

    public static class FiledTypeJavaType {
        private String filedTypeName;
        private String javaType;
        private FiledType filedType;

        public FiledTypeJavaType(String fieldType, String javaType) {
            this.filedTypeName = fieldType;
            this.javaType = javaType;
        }

        public FiledTypeJavaType(FiledType filedType, String javaType) {
            this.filedTypeName = filedType.getName();
            this.javaType = javaType;
            this.filedType = filedType;
        }

        public String getFiledTypeName() {
            return this.filedTypeName;
        }

        public void setFiledTypeName(String filedTypeName) {
            this.filedTypeName = filedTypeName;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public FiledType getFiledType() {
            return this.filedType;
        }

        public void setFiledType(FiledType filedType) {
            this.filedType = filedType;
        }
    }

    public static class DbFiledType {
        private String dbType;
        private List<FiledTypeJavaType> filedTypeJavaTypes;

        public String getJavaTypeByDbFiledType(String filedType, Integer dataLength, Integer dataDot) {
            List filter = this.filedTypeJavaTypes.stream().filter(x -> x.getFiledTypeName().equalsIgnoreCase(filedType)).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(filter)) {
                return "";
            }
            if (filter.size() == 1) {
                return ((FiledTypeJavaType)filter.get(0)).getJavaType();
            }
            String result = null;
            Integer precision = null;
            Integer scale = null;
            for (FiledTypeJavaType x2 : filter) {
                if ((x2.getFiledType() == null || x2.getFiledType().getPrecision() == null && x2.getFiledType().getScale() == null) && dataLength == null && dataDot == null) {
                    result = x2.getJavaType();
                    continue;
                }
                if (dataLength == null || x2.getFiledType().getPrecision() == null || dataLength.compareTo(x2.getFiledType().getPrecision()) > 0 || precision != null && precision.compareTo(x2.getFiledType().getPrecision()) < 0 || scale != null && x2.getFiledType().getScale() != null && scale.compareTo(x2.getFiledType().getScale()) < 0) continue;
                result = x2.getJavaType();
                precision = x2.getFiledType().getPrecision();
                scale = x2.getFiledType().getScale();
            }
            if (result == null) {
                result = ((FiledTypeJavaType)filter.get(0)).getJavaType();
            }
            return result;
        }

        public DbFiledType(String dbType) {
            this.dbType = dbType;
            this.filedTypeJavaTypes = "mysql".equalsIgnoreCase(dbType) ? this.initMysql() : ("oracle".equalsIgnoreCase(dbType) ? this.initOracle() : ("dm".equalsIgnoreCase(dbType) ? this.initDm() : new ArrayList<FiledTypeJavaType>()));
        }

        private List<FiledTypeJavaType> initMysql() {
            ArrayList<FiledTypeJavaType> filedTypes = new ArrayList<FiledTypeJavaType>();
            filedTypes.add(new FiledTypeJavaType("BIGINT", Long.class.getName()));
            filedTypes.add(new FiledTypeJavaType("INT", Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType("MEDIUMINT", Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType("SMALLINT", Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TINYINT", Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DECIMAL", BigDecimal.class.getName()));
            filedTypes.add(new FiledTypeJavaType("FLOAT", Float.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DOUBLE", Double.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATE", LocalDate.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIME", LocalTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATETIME", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIMESTAMP", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("CHAR", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("VARCHAR", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TINYTEXT", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TEXT", String.class.getName()));
            return filedTypes;
        }

        private List<FiledTypeJavaType> initOracle() {
            ArrayList<FiledTypeJavaType> filedTypes = new ArrayList<FiledTypeJavaType>();
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(20, 0), Long.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(10, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(7, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(5, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(3, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(24), BigDecimal.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(null), Float.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(24), Double.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATE", LocalDate.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIME", LocalTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATETIME", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIMESTAMP", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("CHAR", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("VARCHAR2", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("VARCHAR2", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("CLOB", String.class.getName()));
            return filedTypes;
        }

        private List<FiledTypeJavaType> initDm() {
            ArrayList<FiledTypeJavaType> filedTypes = new ArrayList<FiledTypeJavaType>();
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(20, 0), Long.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(10, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(7, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(5, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleNumber(3, 0), Integer.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(24), BigDecimal.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(null), Float.class.getName()));
            filedTypes.add(new FiledTypeJavaType(new OracleFloat(24), Double.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATE", LocalDate.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIME", LocalTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("DATETIME", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("TIMESTAMP", LocalDateTime.class.getName()));
            filedTypes.add(new FiledTypeJavaType("CHAR", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("VARCHAR2", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("VARCHAR2", String.class.getName()));
            filedTypes.add(new FiledTypeJavaType("CLOB", String.class.getName()));
            return filedTypes;
        }

        public List<FiledTypeJavaType> getFiledTypeJavaTypes() {
            return this.filedTypeJavaTypes;
        }
    }
}

