/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util.mongo;

import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.mongo.MongoTemplateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.ObjectUtils;

public class MongoTemplateCache {
    private static final Map<String, MongoTemplate> mongoTemplateCache = new ConcurrentHashMap<String, MongoTemplate>();

    private MongoTemplateCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mongoTemplateCacheEvict() {
        Map<String, MongoTemplate> map = mongoTemplateCache;
        synchronized (map) {
            mongoTemplateCache.clear();
        }
    }

    public static boolean isCacheEmpty() {
        return ObjectUtils.isEmpty(mongoTemplateCache);
    }

    public static Map<String, MongoTemplate> getAll() {
        HashMap<String, MongoTemplate> map = new HashMap<String, MongoTemplate>();
        MongoTemplateCache.deepClone(mongoTemplateCache, map);
        return map;
    }

    public static MongoTemplate get(String dbName) {
        HashMap<String, MongoTemplate> map = new HashMap<String, MongoTemplate>();
        MongoTemplateCache.deepClone(mongoTemplateCache, map);
        return (MongoTemplate)map.get(dbName);
    }

    public static MongoTemplate get() {
        HashMap<String, MongoTemplate> map = new HashMap<String, MongoTemplate>();
        MongoTemplateCache.deepClone(mongoTemplateCache, map);
        String appId = AppContextUtil.getAppId();
        MongoTemplate mongoTemplate = (MongoTemplate)map.get(appId);
        if (ObjectUtils.isEmpty((Object)mongoTemplate)) {
            ToolUtil.getLogger(MongoTemplateCache.class).info("\u4e0d\u5b58\u5728\u540d\u4e3a {} \u7684mongodb\uff0c\u65b0\u5efa", (Object)appId);
            return MongoTemplateUtil.createDb(appId);
        }
        return mongoTemplate;
    }

    public static void put(String dbName, MongoTemplate mongoTemplate) {
        mongoTemplateCache.put(dbName, mongoTemplate);
    }

    public static void putAll(Map<String, MongoTemplate> map) {
        MongoTemplateCache.deepClone(map, mongoTemplateCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deepClone(Map<String, MongoTemplate> fromMap, Map<String, MongoTemplate> toMap) {
        Map<String, MongoTemplate> map = mongoTemplateCache;
        synchronized (map) {
            toMap.clear();
            for (Map.Entry<String, MongoTemplate> stringMongoTemplateEntry : fromMap.entrySet()) {
                String key = stringMongoTemplateEntry.getKey();
                if (key == null || fromMap.get(key) == null) continue;
                toMap.put(key.toString(), fromMap.get(key));
            }
        }
    }
}

