/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.render.FreeMarkerFunction.EmptyFunction;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class RenderCore {
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_NUMBER_FROMAT = "computer";
    private String templatePath;
    private final Map params = new HashMap();
    private String component;
    private String pageInfoPath;

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getPageInfoPath() {
        return this.pageInfoPath;
    }

    public void setPageInfoPath(String pageInfoPath) {
        this.pageInfoPath = pageInfoPath;
    }

    public void registerTemplatePath(String path) {
        this.templatePath = path;
    }

    public void registerParam(Map model) {
        this.params.put("empty", new EmptyFunction());
        this.params.putAll(model);
    }

    public RenderResult render() throws LcdpException {
        RenderResult renderResult = new RenderResult();
        renderResult.setRenderString(this.templateRender());
        renderResult.setStatus(true);
        return renderResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String templateRender() throws LcdpException {
        try {
            Template template = cfg.getTemplate(this.templatePath);
            try (StringWriter writer = new StringWriter();){
                template.process((Object)this.params, (Writer)writer);
                String string = ((Object)writer).toString();
                return string;
            }
            catch (TemplateException e) {
                throw new LcdpException((Exception)((Object)e), "\u5f02\u5e38\u7ec4\u4ef6\uff1a" + this.component + "\n\u9519\u8bef\u4fe1\u606f\uff1a\n" + e.getMessage(), this.pageInfoPath);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    static {
        cfg.setClassForTemplateLoading(RenderCore.class, "/");
        cfg.setDefaultEncoding(DEFAULT_ENCODING);
        cfg.setNumberFormat(DEFAULT_NUMBER_FROMAT);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
    }
}

