/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.model.vuecode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.jxdinfo.hussar.formdesign.common.constant.TriggerIgnore;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.factory.ModifierFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.FloatGap;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.service.Element;
import com.jxdinfo.hussar.formdesign.common.util.DomUtil;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.FormDesignStringUtil;
import com.jxdinfo.hussar.formdesign.common.util.SectionGenerateUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.BaseProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class LcdpComponent
implements Element {
    protected RenderCore renderCore = new RenderCore();
    protected Ctx ctx;
    private final Pattern IS_NUM = Pattern.compile("-?\\d+(\\.\\d+)?");
    private LcdpComponent rootLcdpComponent;
    private LcdpComponent parentLcdpComponent;
    private String instanceKey;
    private String id;
    protected String name;
    private String alias;
    private double scale;
    private String position;
    private Integer top;
    private Integer left;
    private Integer right;
    private Integer bottom;
    private Integer width;
    private Integer height;
    @JSONField(name="_width")
    private Integer listenWidth;
    @JSONField(name="_height")
    private Integer listenHeight;
    private int[] borders;
    private Integer zIndex;
    private String display;
    private boolean isHorizontalFill;
    private boolean isVerticalFill;
    private boolean isAutoHeight;
    private boolean isAutoWidth;
    private boolean isHorizontalAlign;
    private boolean isVerticalAlign;
    private boolean isFloatLeft;
    private boolean isFloatRight;
    private boolean isFixedPosition;
    private boolean isLocateRightSide;
    private boolean isFloatTop;
    private FloatGap floatGap;
    private boolean isDependent;
    private Map<String, Object> styles;
    private Map<String, Object> innerStyles;
    private Map<String, DefaultStyle> interactions;
    private Map<String, Object> interactionsVars;
    private Map<String, JSONArray> slots;
    private Map<String, Object> datas;
    private List<EventConfig> events;
    private JSONObject instances;
    private Map<String, Object> props;
    private List<String> classNames;
    private String styleSchemeClassName;
    private List<Trigger> triggers = new ArrayList<Trigger>();
    private List<Object> dynamicEventTriggers = new ArrayList<Object>();
    private String visitor;
    private final Map<String, Object> renderParams = new HashMap<String, Object>();
    private final Map<String, String> slotCodes = new HashMap<String, String>();
    private final Map<String, Map<String, String>> singleSlotCodes = new HashMap<String, Map<String, String>>();
    private String sourceCode;
    private final Map<String, String> styleExchangeToStyleTemplate = new HashMap<String, String>();
    private final Map<String, String> styleTemplateExchangeToStyle = new HashMap<String, String>();
    private Map<String, List<LcdpComponent>> childrenComponents;
    private List<String> childrenIds;
    private Map<String, String> attrs;
    private Map<String, Object> customAttr;
    private String mergeId;
    private Boolean mergeEnabled;
    private String mergeDescription;
    private boolean isProduce;
    private List<String> listParentKeyChain;

    public List<String> getListParentKeyChain() {
        return this.listParentKeyChain;
    }

    public String getEventParamInputParamSuffix(String eventParamType) {
        return "data";
    }

    public String getRowDataInputParamSuffix() {
        return "row";
    }

    public void setListParentKeyChain(List<String> listParentKeyChain) {
        this.listParentKeyChain = listParentKeyChain;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public void setClassNames(List<String> classNames) {
        this.classNames = classNames;
    }

    public void addClassName(String className) {
        if (this.classNames == null) {
            this.classNames = new ArrayList<String>();
        }
        if (!this.hasClassName(className)) {
            this.classNames.add(className);
        }
    }

    public void removeClassName(String className) {
        if (this.classNames == null) {
            return;
        }
        if (!this.hasClassName(className)) {
            return;
        }
        this.classNames = this.classNames.stream().filter(name -> !Objects.equals(name, className)).collect(Collectors.toList());
    }

    public boolean hasClassName(String className) {
        if (this.classNames == null) {
            return false;
        }
        return this.classNames.stream().anyMatch(name -> Objects.equals(name, className));
    }

    public String getStyleSchemeClassName() {
        return this.styleSchemeClassName;
    }

    public void setStyleSchemeClassName(String styleSchemeClassName) {
        this.styleSchemeClassName = styleSchemeClassName;
    }

    public Map<String, Object> getCustomAttr() {
        return this.customAttr;
    }

    public void setCustomAttr(Map<String, Object> customAttr) {
        this.customAttr = customAttr;
    }

    public LcdpComponent getRootLcdpComponent() {
        return this.rootLcdpComponent;
    }

    public void setRootLcdpComponent(LcdpComponent rootLcdpComponent) {
        this.rootLcdpComponent = rootLcdpComponent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public LcdpComponent getParentLcdpComponent() {
        return this.parentLcdpComponent;
    }

    public void setParentLcdpComponent(LcdpComponent parentLcdpComponent) {
        this.parentLcdpComponent = parentLcdpComponent;
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public String getInstanceKey(String name) {
        return this.instanceKey + name;
    }

    public void setInstanceKey(String instanceKey) {
        this.instanceKey = instanceKey;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public Integer getTop() {
        return this.top;
    }

    public void setTop(String top) {
        this.top = this.getInteger(top);
    }

    public Integer getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = this.getInteger(left);
    }

    private Integer getInteger(String str) {
        Integer i = null;
        if (str == null || !this.IS_NUM.matcher(str).matches()) {
            return i;
        }
        try {
            i = Integer.valueOf(str);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            try {
                i = (int)Float.parseFloat(str);
            }
            catch (Exception ignored1) {
                ignored1.printStackTrace();
            }
        }
        return i;
    }

    public Integer getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = this.getInteger(right);
    }

    public Integer getBottom() {
        return this.bottom;
    }

    public void setBottom(String bottom) {
        this.bottom = this.getInteger(bottom);
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getListenWidth() {
        return this.listenWidth;
    }

    public void setListenWidth(Integer listenWidth) {
        this.listenWidth = listenWidth;
    }

    public Integer getListenHeight() {
        return this.listenHeight;
    }

    public void setListenHeight(Integer listenHeight) {
        this.listenHeight = listenHeight;
    }

    public int[] getBorders() {
        return this.borders;
    }

    public void setBorders(int[] borders) {
        this.borders = borders;
    }

    public Integer getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Integer zIndex) {
        this.zIndex = zIndex;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Map<String, JSONArray> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, JSONArray> slots) {
        this.slots = slots;
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public void setDatas(Map<String, Object> datas) {
        this.datas = datas;
    }

    public List<EventConfig> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventConfig> events) {
        this.events = events;
    }

    public JSONObject getInstances() {
        return this.instances;
    }

    public void setInstances(JSONObject instances) {
        this.instances = instances;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public void setProps(Map<String, Object> props) {
        this.props = props;
    }

    public String getId() {
        return this.id;
    }

    public boolean isAutoHeight() {
        return this.isAutoHeight;
    }

    public void setAutoHeight(boolean autoHeight) {
        this.isAutoHeight = autoHeight;
    }

    public boolean isHorizontalAlign() {
        return this.isHorizontalAlign;
    }

    public void setHorizontalAlign(boolean horizontalAlign) {
        this.isHorizontalAlign = horizontalAlign;
    }

    public boolean isVerticalAlign() {
        return this.isVerticalAlign;
    }

    public void setVerticalAlign(boolean verticalAlign) {
        this.isVerticalAlign = verticalAlign;
    }

    public boolean isFloatLeft() {
        return this.isFloatLeft;
    }

    public void setFloatLeft(boolean floatLeft) {
        this.isFloatLeft = floatLeft;
    }

    public boolean isFloatRight() {
        return this.isFloatRight;
    }

    public void setFloatRight(boolean floatRight) {
        this.isFloatRight = floatRight;
    }

    public boolean isFixedPosition() {
        return this.isFixedPosition;
    }

    public void setFixedPosition(boolean fixedPosition) {
        this.isFixedPosition = fixedPosition;
    }

    public boolean isLocateRightSide() {
        return this.isLocateRightSide;
    }

    public void setLocateRightSide(boolean locateRightSide) {
        this.isLocateRightSide = locateRightSide;
    }

    public boolean isFloatTop() {
        return this.isFloatTop;
    }

    public void setFloatTop(boolean floatTop) {
        this.isFloatTop = floatTop;
    }

    public String getMergeId() {
        return this.mergeId;
    }

    public void setMergeId(String mergeId) {
        this.mergeId = mergeId;
    }

    public Boolean getMergeEnabled() {
        return this.mergeEnabled;
    }

    public void setMergeEnabled(Boolean mergeEnabled) {
        this.mergeEnabled = mergeEnabled;
    }

    public String getMergeDescription() {
        return this.mergeDescription;
    }

    public void setMergeDescription(String mergeDescription) {
        this.mergeDescription = mergeDescription;
    }

    public Map<String, Object> getRenderParamsToBind() {
        ArrayList<String> ignoreKeys = new ArrayList<String>();
        ignoreKeys.add("renderParams");
        Map<String, Object> res = ClassAdapter.getObjectToMap(this, ignoreKeys);
        if (ToolUtil.isNotEmpty(this.props)) {
            res.putAll(this.props);
        }
        if (ToolUtil.isEmpty(this.renderParams.get("componentRef"))) {
            this.renderParams.put("componentRef", this.buildComponentRef());
        }
        res.putAll(this.renderParams);
        return res;
    }

    public String buildComponentRef() {
        String componentRef = ToolUtil.isNotEmpty(this.getListParentKeyChain()) ? this.getListParentKeyChain().stream().collect(Collectors.joining("Index+", "'".concat(this.instanceKey).concat("Ref'+"), "Index")) : this.instanceKey.concat("Ref");
        return componentRef;
    }

    public Map<String, Object> getRenderParams() {
        return this.renderParams;
    }

    public void addRenderParam(String key, Object value) {
        this.renderParams.put(key, value);
    }

    public void addSlotCodes(String slotName, String content) {
        String originContent = this.slotCodes.get(slotName);
        originContent = null != originContent && !"null".equals(originContent) ? originContent + content : content;
        this.slotCodes.put(slotName, originContent);
    }

    public Map<String, String> getSlotCodes() {
        return this.slotCodes;
    }

    public void addSingleSlotCodes(String slotName, String instanceKey, String content) {
        Map<String, String> originContent = this.singleSlotCodes.get(slotName);
        if (null == originContent || "null".equals(originContent)) {
            originContent = new HashMap<String, String>();
        }
        originContent.put(instanceKey, content);
        this.singleSlotCodes.put(slotName, originContent);
    }

    public Map<String, Map<String, String>> getSingleSlotCodes() {
        return this.singleSlotCodes;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getAttrRenderTagName() {
        return "";
    }

    public String getDefaultValue() {
        return "''";
    }

    public void registerParam(Map map) {
        this.renderCore.registerParam(map);
    }

    public void registerTemplatePath(String path) {
        this.renderCore.registerTemplatePath(path);
    }

    public Map<String, List<LcdpComponent>> getChildrenComponents() {
        return this.childrenComponents;
    }

    public void setChildrenComponents(Map<String, List<LcdpComponent>> childrenComponents) {
        this.childrenComponents = childrenComponents;
    }

    public boolean isProduce() {
        return this.isProduce;
    }

    public void setProduce(boolean produce) {
        this.isProduce = produce;
    }

    public void addChildComponent(String slotName, LcdpComponent lcdpComponent) {
        if (this.childrenComponents == null) {
            this.childrenComponents = new HashMap<String, List<LcdpComponent>>(16);
        }
        List<LcdpComponent> lcdpComponents = this.childrenComponents.get(slotName) == null ? new ArrayList<LcdpComponent>() : this.childrenComponents.get(slotName);
        lcdpComponents.add(lcdpComponent);
        if (this.childrenIds == null) {
            this.childrenIds = new ArrayList<String>();
        }
        this.childrenIds.add(lcdpComponent.getInstanceKey());
        this.childrenComponents.put(slotName, lcdpComponents);
    }

    public List<String> getTriggers() {
        if (ToolUtil.isNotEmpty(this.triggers)) {
            return this.triggers.stream().map(Trigger::getName).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<Trigger> getTrigger() {
        return this.triggers;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    public void addTrigger(Trigger trigger) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        this.triggers.add(trigger);
    }

    public List<Object> getDynamicEventTriggers() {
        return this.dynamicEventTriggers;
    }

    public void setDynamicEventTriggers(List<Object> dynamicEventTriggers) {
        this.dynamicEventTriggers = dynamicEventTriggers;
    }

    public boolean haveTriggerByTriggerName(String triggerName) {
        if (this.triggers != null) {
            for (Trigger trigger : this.triggers) {
                if (!HussarUtils.equals((Object)trigger.getName(), (Object)triggerName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getVisitor() {
        return this.visitor;
    }

    public BaseProvideVisitor<LcdpComponent, Ctx> getProvideVisitor(String name) {
        Object visitor = null;
        String beanName = this.getName() + "." + name;
        try {
            visitor = SpringUtil.getBean(beanName);
        }
        catch (Exception ignored) {
            visitor = SpringUtil.getPluginUtil().getBean(beanName, "", "");
        }
        try {
            if (visitor == null) {
                switch (name) {
                    case "value": {
                        Class<?> valueVisitorClazz = Class.forName("com.jxdinfo.hussar.formdesign.base.visitor.DefaultValueProvideVisitor");
                        visitor = valueVisitorClazz.newInstance();
                        break;
                    }
                    case "state": {
                        Class<?> stateVisitorClazz = Class.forName("com.jxdinfo.hussar.formdesign.base.visitor.DefaultStateVisitor");
                        visitor = stateVisitorClazz.newInstance();
                        break;
                    }
                    case "interActive": {
                        Class<?> interActiveVisitor = Class.forName("com.jxdinfo.hussar.formdesign.base.visitor.DefaultInterActiveVisitor");
                        visitor = interActiveVisitor.newInstance();
                        break;
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return (BaseProvideVisitor)visitor;
    }

    @Override
    public void accept(VoidVisitor<LcdpComponent, Ctx> voidVisitor, Ctx ctx) throws Exception {
        voidVisitor.visit(this, ctx);
    }

    @Override
    public void accept(BaseProvideVisitor<LcdpComponent, Ctx> provideVisitor, Ctx ctx, Map<String, Object> params) throws LcdpException {
        provideVisitor.visit(this, ctx, params);
    }

    public void setVisitor(String visitor) {
        this.visitor = visitor;
    }

    public void print(Ctx ctx, String pageInfoPath) throws LcdpException {
        RenderResult renderResult = this.render(pageInfoPath);
        if (renderResult.isStatus()) {
            String renderCode = renderResult.getRenderString();
            renderCode = this.codeFormatter(ctx, renderCode);
            if (!this.equals(ctx.getRootLcdpComponent())) {
                renderCode = this.dealByElement(renderCode);
            }
            if (ToolUtil.isNotEmpty(renderCode) && !renderCode.endsWith("\n") && !renderCode.endsWith("\r")) {
                renderCode = renderCode + System.lineSeparator();
            }
            this.setSourceCode(renderCode);
        }
    }

    public RenderResult render(String pageInfoPath) throws LcdpException {
        this.renderCore.registerParam(this.getRenderParamsToBind());
        this.renderCore.setComponent(this.getInstanceKey() + " " + this.name + "\n");
        this.renderCore.setPageInfoPath(pageInfoPath);
        return this.renderCore.render();
    }

    public String codeFormatter(Ctx ctx, String code) {
        return code;
    }

    /*
     * WARNING - void declaration
     */
    private String dealByElement(String renderCode) {
        List<Trigger> toRenderTriggers;
        void var11_17;
        Object elements;
        String[] commentArray;
        String comments = this.getProps().getOrDefault("exegesis", "").toString();
        StringBuilder comment = new StringBuilder();
        if (HussarUtils.isEmpty((Object)comments)) {
            comments = HussarUtils.isNotEmpty((Object)this.getAlias()) ? this.getAlias() : "";
        }
        for (String line : commentArray = comments.split("\n")) {
            comment.append("<!-- ");
            comment.append(line);
            comment.append(" -->");
            comment.append("\r\n");
        }
        ArrayList<String> upperTag = new ArrayList<String>();
        if (renderCode.contains("@ionChange")) {
            upperTag.add("@ionChange");
        }
        if (renderCode.contains(":autoFill")) {
            upperTag.add(":autoFill");
        }
        if (renderCode.contains("@ionblur")) {
            upperTag.add("@ionBlur");
        }
        if (renderCode.contains("@ionfocus")) {
            upperTag.add("@ionFocus");
        }
        org.jsoup.nodes.Element element = DomUtil.parseElement(renderCode);
        Map<String, String> toRenderAttrs = this.attrs;
        Map<String, Object> toRenderCustomAttrs = this.customAttr;
        org.jsoup.nodes.Element connectElement = element;
        if (null != this.getAttrRenderTagName() && !"".equals(this.getAttrRenderTagName()) && (elements = element.getElementsByTag(this.getAttrRenderTagName())).size() == 1) {
            connectElement = elements.first();
        }
        if (toRenderAttrs != null && toRenderAttrs.size() > 0) {
            toRenderAttrs.forEach((arg_0, arg_1) -> ((org.jsoup.nodes.Element)connectElement).attr(arg_0, arg_1));
        }
        if (toRenderCustomAttrs != null && toRenderCustomAttrs.size() > 0) {
            for (Map.Entry entry : toRenderCustomAttrs.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                connectElement.attr(key, String.valueOf(value));
            }
        }
        element.addClass(this.instanceKey);
        String componentName = this.name;
        String string = StyleFactory.get(componentName);
        if (ToolUtil.isNotEmpty(string)) {
            String string2;
            if (string.startsWith(".") && (string2 = string.substring(1)).contains(".")) {
                String string3 = string2.replace(".", " ");
            }
            element.addClass((String)var11_17);
        }
        if (ToolUtil.isNotEmpty(this.classNames)) {
            this.classNames.forEach(className -> element.addClass(className));
        }
        if (ToolUtil.isNotEmpty(this.styleSchemeClassName) && !var11_17.equals("hk_ins_hkTag")) {
            element.addClass(this.styleSchemeClassName);
        }
        if (ToolUtil.isNotEmpty(toRenderTriggers = this.triggers)) {
            toRenderTriggers.forEach(trigger -> {
                if (!Arrays.asList(TriggerIgnore.triggerIgnore).contains(trigger.getName())) {
                    String event = trigger.getName();
                    String attrName = "@" + event + ModifierFactory.getModifiers(componentName, event);
                    String underlineName = trigger.getName().replace(".", "_").replace("-", "_");
                    String humpName = FormDesignStringUtil.underlineToHump(underlineName);
                    String triggerName = this.instanceKey + ToolUtil.firstLetterToUpper(humpName);
                    if (ToolUtil.isEmpty(trigger.getArgs())) {
                        element.attr(attrName, triggerName);
                    } else {
                        String triAttr = triggerName + "( " + StringUtils.join(trigger.getArgs(), (String)",") + " )";
                        element.attr(attrName, triAttr);
                    }
                }
            });
        }
        renderCode = element.toString().replace("\"true\"", "true").replace("\"false\"", "false");
        if (toRenderCustomAttrs != null) {
            for (Map.Entry entry : toRenderCustomAttrs.entrySet()) {
                String attr = (String)entry.getKey();
                Object attrVal = entry.getValue();
                if (!(attrVal instanceof Integer)) continue;
                renderCode = renderCode.replace(attr + "=\"" + attrVal + "\"", attr + "=" + attrVal);
            }
        }
        if (ToolUtil.isNotEmpty(upperTag)) {
            for (String string4 : upperTag) {
                renderCode = renderCode.replaceAll(string4.toLowerCase(), string4);
            }
        }
        if (Objects.equals(this.mergeEnabled, true)) {
            String id = ToolUtil.isNotEmpty(this.mergeId) ? this.mergeId : this.instanceKey;
            String string5 = this.mergeDescription;
            renderCode = SectionGenerateUtil.wrapVueComponent(id, renderCode, this.instanceKey, string5);
        }
        return comment + renderCode;
    }

    public List<String> getChildrenIds() {
        return this.childrenIds;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public void addAttr(String key, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(key, value);
    }

    public void addCustomAttr(String key, Object value) {
        if (this.customAttr == null) {
            this.customAttr = new HashMap<String, Object>();
        }
        this.customAttr.put(key, value);
    }

    public Map<String, Object> getStyles() {
        if (this.styles == null) {
            this.styles = new HashMap<String, Object>();
        }
        this.styles.putAll(this.positionStyles());
        if (ToolUtil.isNotEmpty(this.position) && !this.isDependent) {
            this.styles.put("position", this.position);
        }
        return this.styles;
    }

    public void setStyles(Map<String, Object> styles) {
        this.styles = styles;
    }

    public abstract Map<String, String> styleTemplate();

    public abstract Map<String, String> propsTemplate();

    public Map<String, String> outerStyleTemplate() {
        return Collections.emptyMap();
    }

    public boolean isScopedStyle(String styleName) {
        return true;
    }

    public Map<String, Object> getInnerStyles() {
        return this.innerStyles;
    }

    public void setInnerStyles(Map<String, Object> innerStyles) {
        this.innerStyles = innerStyles;
    }

    private Map<String, String> positionStyles() {
        HashMap<String, String> positionStyles = new HashMap<String, String>(16);
        if (null != this.top) {
            positionStyles.put("top", this.addPX(this.top));
        }
        if (null != this.left) {
            positionStyles.put("left", this.addPX(this.left));
        }
        if (null != this.bottom) {
            positionStyles.put("bottom", this.addPX(this.bottom));
        }
        if (null != this.right) {
            positionStyles.put("right", this.addPX(this.right));
        }
        if (ToolUtil.isNotEmpty(this.display) && !this.isDependent) {
            positionStyles.put("display", this.display);
        }
        this.autoAdaption(positionStyles);
        return positionStyles;
    }

    private void autoAdaption(Map<String, String> positionStyles) {
        String calcTemplate = "calc(100%% - %s - %s)";
        this.dealFillHorizon(positionStyles, calcTemplate);
        this.dealFillVertical(positionStyles, calcTemplate);
        this.dealAutoHeight(positionStyles);
        this.dealFloatLeft(positionStyles);
        this.dealFloatRight(positionStyles);
        this.dealFloatTop(positionStyles);
        this.dealHorizontalAlignAndVerticalAlign(positionStyles);
        this.dealFixedPosition(positionStyles);
        this.dealAutoWidth(positionStyles);
    }

    private void dealFixedPosition(Map<String, String> positionStyles) {
        if (this.isFixedPosition) {
            this.position = "fixed";
        }
    }

    private void dealLocateRightSide(Map<String, String> positionStyles) {
    }

    private void dealFloatTop(Map<String, String> positionStyles) {
        if (this.isFloatTop) {
            positionStyles.put("position", "relative");
            this.position = "relative";
            Object floatGapMarginTop = this.getFloatGap().getMarginTop();
            Object floatGapMarginRight = this.getFloatGap().getMarginRight();
            Object floatGapMarginLeft = this.getFloatGap().getMarginLeft();
            Object floatGapMarginBottom = this.getFloatGap().getMarginBottom();
            String topGap = "";
            if (null != floatGapMarginTop) {
                topGap = this.dealThemeBaseFloatGap(floatGapMarginTop);
            }
            String rightGap = "";
            if (null != floatGapMarginRight) {
                rightGap = this.dealThemeBaseFloatGap(floatGapMarginRight);
            }
            String leftGap = "";
            if (null != floatGapMarginLeft) {
                leftGap = this.dealThemeBaseFloatGap(floatGapMarginLeft);
            }
            String bottomGap = "";
            if (null != floatGapMarginBottom) {
                bottomGap = this.dealThemeBaseFloatGap(floatGapMarginBottom);
            }
            if (this.isHorizontalFill) {
                rightGap = this.right + "px";
                leftGap = this.left + "px";
            }
            if (ToolUtil.isNotEmpty(topGap)) {
                positionStyles.put("margin-top", topGap);
            }
            if (ToolUtil.isNotEmpty(bottomGap)) {
                positionStyles.put("margin-bottom", bottomGap);
            }
            if (ToolUtil.isNotEmpty(leftGap)) {
                positionStyles.put("margin-left", leftGap);
            }
            if (ToolUtil.isNotEmpty(rightGap)) {
                positionStyles.put("margin-right", rightGap);
            }
            this.removeLeftTopRightBottom(positionStyles);
        }
    }

    private void removeLeftTopRightBottom(Map<String, String> positionStyles) {
        positionStyles.remove("left");
        positionStyles.remove("right");
        positionStyles.remove("bottom");
        positionStyles.remove("top");
    }

    private void dealFloatRight(Map<String, String> positionStyles) {
        if (this.isFloatRight) {
            this.position = "relative";
            positionStyles.put("float", "right");
            this.dealFloatLeftAndRight(positionStyles);
        }
    }

    private void dealMarginPosition(Map<String, String> positionStyles, String marginLeft, String s, String marginRight, String marginRight2, String marginBottom, String marginBottom2, String marginTop, String marginTop2) {
        positionStyles.put(marginLeft, s);
        positionStyles.put(marginRight, marginRight2 + "px");
        positionStyles.put(marginBottom, marginBottom2 + "px");
        positionStyles.put(marginTop, marginTop2 + "px");
    }

    private void dealFloatLeft(Map<String, String> positionStyles) {
        if (this.isFloatLeft) {
            this.position = "relative";
            positionStyles.put("float", "left");
            this.dealFloatLeftAndRight(positionStyles);
        }
    }

    private void dealFloatLeftAndRight(Map<String, String> positionStyles) {
        Object floatGapMarginTop = this.getFloatGap().getMarginTop();
        Object floatGapMarginBottom = this.getFloatGap().getMarginBottom();
        Object floatGapMarginLeft = this.getFloatGap().getMarginLeft();
        Object floatGapMarginRight = this.getFloatGap().getMarginRight();
        String topGap = "";
        if (null != floatGapMarginTop) {
            topGap = this.dealThemeBaseFloatGap(floatGapMarginTop);
        }
        String rightGap = "";
        if (null != floatGapMarginRight) {
            rightGap = this.dealThemeBaseFloatGap(floatGapMarginRight);
        }
        String leftGap = "";
        if (null != floatGapMarginLeft) {
            leftGap = this.dealThemeBaseFloatGap(floatGapMarginLeft);
        }
        String bottomGap = "";
        if (null != floatGapMarginBottom) {
            bottomGap = this.dealThemeBaseFloatGap(floatGapMarginBottom);
        }
        if (this.isVerticalFill) {
            topGap = this.top + "px";
            bottomGap = this.bottom + "px";
        }
        if (ToolUtil.isNotEmpty(topGap)) {
            positionStyles.put("margin-top", topGap);
        }
        if (ToolUtil.isNotEmpty(bottomGap)) {
            positionStyles.put("margin-bottom", bottomGap);
        }
        if (ToolUtil.isNotEmpty(leftGap)) {
            positionStyles.put("margin-left", leftGap);
        }
        if (ToolUtil.isNotEmpty(rightGap)) {
            positionStyles.put("margin-right", rightGap);
        }
        this.removeLeftTopRightBottom(positionStyles);
    }

    private String dealThemeBaseFloatGap(Object marginValue) {
        if (DynDataUtil.isBasicType(marginValue)) {
            return marginValue + "px";
        }
        Optional space = DynDataUtil.subscript(marginValue, "template").flatMap(DynDataUtil::asString);
        if (space.isPresent()) {
            return "var(--p-" + (String)space.get() + ")";
        }
        return "";
    }

    private void dealHorizontalAlignAndVerticalAlign(Map<String, String> positionStyles) {
        if (this.isHorizontalAlign) {
            positionStyles.put("right", "unset");
            positionStyles.put("left", "50%");
            positionStyles.put("transform", "translateX(-50%)");
        }
        if (this.isVerticalAlign) {
            positionStyles.put("bottom", "unset");
            positionStyles.put("top", "50%");
            positionStyles.put("transform", "translateY(-50%)");
        }
        if (this.isVerticalAlign && this.isHorizontalAlign) {
            positionStyles.put("transform", "translate(-50%,-50%)");
        }
    }

    private void dealAutoHeight(Map<String, String> positionStyles) {
        if (this.isAutoHeight) {
            positionStyles.put("height", "auto");
        }
    }

    private void dealAutoWidth(Map<String, String> positionStyles) {
        if (this.isAutoWidth) {
            positionStyles.put("width", "auto");
        }
    }

    private void dealFillVertical(Map<String, String> positionStyles, String calcTemplate) {
        if (this.isVerticalFill) {
            if (null != this.ctx && this.equals(this.ctx.getRootLcdpComponent())) {
                positionStyles.put("height", "100%");
            } else {
                String theTop = this.top == null ? "0px" : String.valueOf(this.top) + "px";
                String theBottom = this.bottom == null ? "0px" : String.valueOf(this.bottom) + "px";
                positionStyles.put("height", String.format(calcTemplate, theTop, theBottom));
            }
        } else if (null != this.listenHeight) {
            positionStyles.put("height", this.addPX(this.height));
        }
    }

    private void dealFillHorizon(Map<String, String> positionStyles, String calcTemplate) {
        if (this.isHorizontalFill) {
            String theLeft = this.left == null ? "0px" : String.valueOf(this.left) + "px";
            String theRight = this.right == null ? "0px" : String.valueOf(this.right) + "px";
            positionStyles.put("width", String.format(calcTemplate, theLeft, theRight));
        } else if (null != this.listenWidth) {
            positionStyles.put("width", this.addPX(this.width));
        }
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String instanceClassName() {
        return "." + this.instanceKey + " ";
    }

    public void setCtx(Ctx ctx) {
        this.ctx = ctx;
    }

    private String addPX(Integer integer) {
        return integer == 0 ? "0" : integer + "px";
    }

    public boolean isHorizontalFill() {
        return this.isHorizontalFill;
    }

    public void setHorizontalFill(boolean horizontalFill) {
        this.isHorizontalFill = horizontalFill;
    }

    public boolean isVerticalFill() {
        return this.isVerticalFill;
    }

    public void setVerticalFill(boolean verticalFill) {
        this.isVerticalFill = verticalFill;
    }

    public FloatGap getFloatGap() {
        return this.floatGap;
    }

    public void setFloatGap(FloatGap floatGap) {
        this.floatGap = floatGap;
    }

    public boolean isDependent() {
        return this.isDependent;
    }

    public void setDependent(boolean dependent) {
        this.isDependent = dependent;
    }

    public boolean isAutoWidth() {
        return this.isAutoWidth;
    }

    public void setAutoWidth(boolean autoWidth) {
        this.isAutoWidth = autoWidth;
    }

    public Map<String, DefaultStyle> getInteractions() {
        return this.interactions;
    }

    public void setInteractions(Map<String, DefaultStyle> interactions) {
        this.interactions = interactions;
    }

    public Map<String, Object> getInteractionsVars() {
        return this.interactionsVars;
    }

    public void setInteractionsVars(Map<String, Object> interactionsVars) {
        this.interactionsVars = interactionsVars;
    }

    protected void styleExchangeToStyleTemplate(String styleName, String styleTemplateName) {
        this.styleExchangeToStyleTemplate.put(styleName, styleTemplateName);
    }

    protected void styleTemplateExchangeToStyle(String styleTemplateName, String styleName) {
        this.styleTemplateExchangeToStyle.put(styleTemplateName, styleName);
    }

    public Map<String, String> getStyleExchangeToStyleTemplate() {
        return this.styleExchangeToStyleTemplate;
    }

    public Map<String, String> getStyleTemplateExchangeToStyle() {
        return this.styleTemplateExchangeToStyle;
    }

    public String getCommonStyleClassPrefix() {
        return ".lcdp_axe";
    }

    public String getComponentOwnStylePrefix() {
        String componentIdentifyClassName = this.equals(this.ctx.getRootLcdpComponent()) ? "." + this.getInstanceKey() : " ." + this.getInstanceKey();
        String pageIdentifyClassName = "." + this.ctx.getPageName();
        return this.getCommonStyleClassPrefix() + pageIdentifyClassName + componentIdentifyClassName;
    }

    public void putSlot(String where, LcdpComponent lcdpComponent) {
        if (HussarUtils.isEmpty(this.slots)) {
            this.slots = new HashMap<String, JSONArray>();
        }
        if (HussarUtils.isEmpty((Object)this.slots.get(where))) {
            this.slots.put(where, new JSONArray());
        }
        this.slots.get(where).add((Object)lcdpComponent);
    }
}

