/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.config;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.impl.StorageServiceOfflineImpl;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.RecordService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.client.service.impl.RecordServiceImpl;
import com.jxdinfo.hussar.formdesign.storage.client.service.impl.StorageServiceImpl;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StorageServicesConfig {
    private final StorageContext storageContext;
    private final FormDesignProperties formDesignProperties;

    @Autowired
    public StorageServicesConfig(StorageContext storageContext, FormDesignProperties formDesignProperties) {
        this.storageContext = storageContext;
        this.formDesignProperties = formDesignProperties;
    }

    @Bean
    public StorageService storageService() {
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
        if (this.formDesignProperties.getNoCodeScenes() == FormDesignScenes.NO_CODE_OFFLINE) {
            return new StorageServiceOfflineImpl(FileUtil.posixPath(pathStrategy.javaPathService().getDefaultBackProjectPath(), this.formDesignProperties.getNoCodeStore()), this.storageContext);
        }
        if (this.formDesignProperties.getScenes() == FormDesignScenes.DEVELOP) {
            return new StorageServiceImpl((StorageConfiguration)this.storageContext);
        }
        return new StorageServiceOfflineImpl(FileUtil.posixPath(pathStrategy.javaPathService().getDefaultBackProjectPath(), this.formDesignProperties.getProjectPath()), this.storageContext);
    }

    @Bean
    public RecordService recordService() {
        return new RecordServiceImpl((StorageConfiguration)this.storageContext);
    }
}

