/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolUtil {
    private static final Pattern REGEX_LINE_SEPARATOR = Pattern.compile("\\n|\\r\\n?", 8);

    private ToolUtil() {
    }

    public static String firstLetterToUpper(String str) {
        char[] ch = str.toCharArray();
        if (ch.length > 0 && ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    public static boolean isEmpty(Object a) {
        boolean result = false;
        if (a == null) {
            result = true;
        } else if (a instanceof String) {
            result = "".equals(a.toString().trim());
        } else if (a instanceof List) {
            result = ((List)a).size() == 0;
        } else if (a instanceof Map) {
            result = ((Map)a).size() == 0;
        } else if (a instanceof Set) {
            result = ((Set)a).size() == 0;
        } else if (a instanceof Object[]) {
            result = ((Object[])a).length == 0;
        } else if (a instanceof int[]) {
            result = ((int[])a).length == 0;
        } else if (a instanceof long[]) {
            result = ((long[])a).length == 0;
        }
        return result;
    }

    public static boolean isNotEmpty(Object a) {
        return !ToolUtil.isEmpty(a);
    }

    public static String get32UUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String get36UUID() {
        return UUID.randomUUID().toString();
    }

    public static String firstToLower(String str) {
        if (ToolUtil.isEmpty(str)) {
            return "";
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String textFomatterByOS(String text) {
        if (ToolUtil.isEmpty(text)) {
            return "";
        }
        return REGEX_LINE_SEPARATOR.matcher(text).replaceAll(System.lineSeparator());
    }

    public static String pathFomatterByOS(String oPath) {
        return oPath.replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    public static String pathToPackage(String path) {
        return path.replace("/", ".").replace(File.separator, ".").replace("//", ".").replace("\\", ".").replace("\\\\", ".");
    }

    public static String formatToDividePath(String path) {
        return path.replace("\\", "/").replace("\\\\", "/").replace(File.separator, "/");
    }

    public static List<String> stringToList(String splitStr) {
        return Optional.of(Arrays.asList(splitStr.split(","))).orElseGet(ArrayList::new);
    }

    public static String splicingBySeparator(String separator, String ... strings) {
        StringBuffer buffer = new StringBuffer();
        for (String string : strings) {
            if (ToolUtil.isEmpty(separator)) {
                buffer.append(string);
                continue;
            }
            buffer.append(string).append(separator);
        }
        String result = buffer.toString();
        if (separator.equals(buffer.substring(buffer.length() - 1))) {
            result = buffer.substring(0, buffer.length() - 1);
        }
        return result;
    }

    public static String timeBetween(long start, long end) {
        return String.format("%.3fs", (double)Math.abs(end - start) / 1000.0);
    }

    public static long getCurrentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static String logTime(long start) {
        return String.format("%.3f", (double)(Calendar.getInstance().getTimeInMillis() - start) / 1000.0);
    }

    public static void triggerGarbageCollect() {
        GcTaskHolder.trigger();
    }

    public static <K, V> List<Map<K, V>> castListMap(Object obj, Class<K> kCalzz, Class<V> vCalzz) {
        ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>();
        if (obj instanceof List) {
            for (Object mapObj : (List)obj) {
                if (!(mapObj instanceof Map)) continue;
                HashMap<K, V> map = new HashMap<K, V>(16);
                for (Map.Entry entry : ((Map)mapObj).entrySet()) {
                    map.put(kCalzz.cast(entry.getKey()), vCalzz.cast(entry.getValue()));
                }
                result.add(map);
            }
            return result;
        }
        return null;
    }

    private static class DebouncedTask {
        private final long interval;
        private final Runnable task;
        private final ScheduledExecutorService pool = Executors.newScheduledThreadPool(1);
        private long due = Long.MIN_VALUE;

        public DebouncedTask(long interval, Runnable task) {
            if (task == null) {
                throw new NullPointerException();
            }
            this.interval = Math.max(interval, 0L);
            this.task = task;
        }

        public synchronized void execute() {
            long now = System.currentTimeMillis();
            if (this.due >= now) {
                return;
            }
            this.pool.schedule(this.task, this.interval, TimeUnit.MILLISECONDS);
            this.due = now + this.interval;
        }
    }

    private static final class GcTaskHolder {
        private static final Logger logger = LoggerFactory.getLogger(GcTaskHolder.class);
        private static final long GC_DEBOUNCE_INTERVAL = 1000L;
        private static final DebouncedTask task = new DebouncedTask(1000L, GcTaskHolder::gc);

        private GcTaskHolder() {
        }

        public static void trigger() {
            task.execute();
        }

        private static void gc() {
            logger.debug("\u624b\u5de5\u89e6\u53d1\u5783\u573e\u56de\u6536\uff0c\u9632\u6296\u65f6\u95f4 {}ms", (Object)1000L);
            long gcStart = ToolUtil.getCurrentTime();
            System.gc();
            logger.debug("\u624b\u5de5\u5783\u573e\u56de\u6536\u5171\u8017\u65f6: {}s", (Object)ToolUtil.logTime(gcStart));
        }
    }
}

